/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.connections.httpclient.ProxyMappings;

public class ProxyMappingsTest {
    private static final List<String> DEFAULT_MAPPINGS = Arrays.asList(".*\\.(google|googleapis)\\.com;http://proxy1:8080", ".*\\.facebook\\.com;http://proxy2:8080");
    private static final List<String> MAPPINGS_WITH_FALLBACK = new ArrayList<String>();
    private static final List<String> MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION = new ArrayList<String>();
    private static final List<String> MAPPINGS_WITH_PROXY_AUTHENTICATION = new ArrayList<String>();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    ProxyMappings proxyMappings;

    @Before
    public void setup() {
        ProxyMappings.clearCache();
        this.proxyMappings = ProxyMappings.valueOf(DEFAULT_MAPPINGS);
    }

    @Test
    public void proxyMappingFromEmptyListShouldBeEmpty() {
        MatcherAssert.assertThat((Object)new ProxyMappings(new ArrayList()).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldReturnProxy1ForConfiguredProxyMapping() {
        ProxyMappings.ProxyMapping proxy = this.proxyMappings.getProxyFor("account.google.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)proxy.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
    }

    @Test
    public void shouldReturnProxy1ForConfiguredProxyMappingAlternative() {
        ProxyMappings.ProxyMapping proxy = this.proxyMappings.getProxyFor("www.googleapis.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)proxy.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
    }

    @Test
    public void shouldReturnProxy1ForConfiguredProxyMappingWithSubDomain() {
        ProxyMappings.ProxyMapping proxy = this.proxyMappings.getProxyFor("awesome.account.google.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)proxy.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
    }

    @Test
    public void shouldReturnProxy2ForConfiguredProxyMapping() {
        ProxyMappings.ProxyMapping proxy = this.proxyMappings.getProxyFor("login.facebook.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)proxy.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy2"));
    }

    @Test
    public void shouldReturnNoProxyForUnknownHost() {
        ProxyMappings.ProxyMapping proxy = this.proxyMappings.getProxyFor("login.microsoft.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldRejectNull() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("hostname");
        this.proxyMappings.getProxyFor(null);
    }

    @Test
    public void shouldReturnFallbackForNotExplicitlyMappedHostname() {
        ProxyMappings proxyMappingsWithFallback = ProxyMappings.valueOf(MAPPINGS_WITH_FALLBACK);
        ProxyMappings.ProxyMapping proxy = proxyMappingsWithFallback.getProxyFor("login.salesforce.com");
        MatcherAssert.assertThat((Object)proxy.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
    }

    @Test
    public void shouldReturnCorrectProxyOrFallback() {
        ProxyMappings proxyMappingsWithFallback = ProxyMappings.valueOf(MAPPINGS_WITH_FALLBACK);
        ProxyMappings.ProxyMapping forGoogle = proxyMappingsWithFallback.getProxyFor("login.google.com");
        MatcherAssert.assertThat((Object)forGoogle.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
        ProxyMappings.ProxyMapping forFacebook = proxyMappingsWithFallback.getProxyFor("login.facebook.com");
        MatcherAssert.assertThat((Object)forFacebook.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy2"));
        ProxyMappings.ProxyMapping forMicrosoft = proxyMappingsWithFallback.getProxyFor("login.microsoft.com");
        MatcherAssert.assertThat((Object)forMicrosoft.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
        ProxyMappings.ProxyMapping forSalesForce = proxyMappingsWithFallback.getProxyFor("login.salesforce.com");
        MatcherAssert.assertThat((Object)forSalesForce.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
    }

    @Test
    public void shouldReturnFallbackForNotExplicitlyMappedHostnameAndHonorProxyExceptions() {
        ProxyMappings proxyMappingsWithFallbackAndProxyException = ProxyMappings.valueOf(MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION);
        ProxyMappings.ProxyMapping forGoogle = proxyMappingsWithFallbackAndProxyException.getProxyFor("login.google.com");
        MatcherAssert.assertThat((Object)forGoogle.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
        ProxyMappings.ProxyMapping forFacebook = proxyMappingsWithFallbackAndProxyException.getProxyFor("login.facebook.com");
        MatcherAssert.assertThat((Object)forFacebook.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy2"));
        ProxyMappings.ProxyMapping forAcmeCorp = proxyMappingsWithFallbackAndProxyException.getProxyFor("myapp.acme.corp.com");
        MatcherAssert.assertThat((Object)forAcmeCorp.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ProxyMappings.ProxyMapping forMicrosoft = proxyMappingsWithFallbackAndProxyException.getProxyFor("login.microsoft.com");
        MatcherAssert.assertThat((Object)forMicrosoft.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
        ProxyMappings.ProxyMapping forSalesForce = proxyMappingsWithFallbackAndProxyException.getProxyFor("login.salesforce.com");
        MatcherAssert.assertThat((Object)forSalesForce.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
    }

    @Test
    public void shouldReturnProxyAuthentication() {
        ProxyMappings proxyMappingsWithProxyAuthen = ProxyMappings.valueOf(MAPPINGS_WITH_PROXY_AUTHENTICATION);
        ProxyMappings.ProxyMapping forGoogle = proxyMappingsWithProxyAuthen.getProxyFor("login.google.com");
        MatcherAssert.assertThat((Object)forGoogle.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy1"));
        ProxyMappings.ProxyMapping forFacebook = proxyMappingsWithProxyAuthen.getProxyFor("login.facebook.com");
        MatcherAssert.assertThat((Object)forFacebook.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy2"));
        ProxyMappings.ProxyMapping forStackOverflow = proxyMappingsWithProxyAuthen.getProxyFor("stackexchange.com");
        MatcherAssert.assertThat((Object)forStackOverflow.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"proxy3"));
        MatcherAssert.assertThat((Object)forStackOverflow.getProxyHost().getPort(), (Matcher)CoreMatchers.is((Object)88));
        MatcherAssert.assertThat((Object)forStackOverflow.getProxyCredentials().getUserName(), (Matcher)CoreMatchers.is((Object)"user01"));
        MatcherAssert.assertThat((Object)forStackOverflow.getProxyCredentials().getPassword(), (Matcher)CoreMatchers.is((Object)"pas2w0rd"));
        ProxyMappings.ProxyMapping forAcmeCorp = proxyMappingsWithProxyAuthen.getProxyFor("myapp.acme.corp.com");
        MatcherAssert.assertThat((Object)forAcmeCorp.getProxyHost(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ProxyMappings.ProxyMapping forMicrosoft = proxyMappingsWithProxyAuthen.getProxyFor("login.microsoft.com");
        MatcherAssert.assertThat((Object)forMicrosoft.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
        ProxyMappings.ProxyMapping forSalesForce = proxyMappingsWithProxyAuthen.getProxyFor("login.salesforce.com");
        MatcherAssert.assertThat((Object)forSalesForce.getProxyHost().getHostName(), (Matcher)CoreMatchers.is((Object)"fallback"));
    }

    @Test
    public void shouldReturnMappingForHttpProxy() {
        ProxyMappings proxyMappings = ProxyMappings.withFixedProxyMapping((String)"https://some-proxy.redhat.com:8080", null);
        ProxyMappings.ProxyMapping forGoogle = proxyMappings.getProxyFor("login.google.com");
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)forGoogle.getProxyHost().getHostName());
    }

    @Test
    public void shouldReturnMappingForHttpProxyWithNoProxy() {
        ProxyMappings proxyMappings = ProxyMappings.withFixedProxyMapping((String)"https://some-proxy.redhat.com:8080", (String)"login.facebook.com");
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("login.google.com").getProxyHost().getHostName());
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("facebook.com").getProxyHost().getHostName());
        Assert.assertNull((Object)proxyMappings.getProxyFor("login.facebook.com").getProxyHost());
        Assert.assertNull((Object)proxyMappings.getProxyFor("auth.login.facebook.com").getProxyHost());
    }

    @Test
    public void shouldReturnMappingForHttpProxyWithMultipleNoProxy() {
        ProxyMappings proxyMappings = ProxyMappings.withFixedProxyMapping((String)"https://some-proxy.redhat.com:8080", (String)"login.facebook.com,corp.com");
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("login.google.com").getProxyHost().getHostName());
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("facebook.com").getProxyHost().getHostName());
        Assert.assertNull((Object)proxyMappings.getProxyFor("login.facebook.com").getProxyHost());
        Assert.assertNull((Object)proxyMappings.getProxyFor("auth.login.facebook.com").getProxyHost());
        Assert.assertNull((Object)proxyMappings.getProxyFor("myapp.acme.corp.com").getProxyHost());
    }

    @Test
    public void shouldReturnMappingForNoProxyWithInvalidChars() {
        ProxyMappings proxyMappings = ProxyMappings.withFixedProxyMapping((String)"https://some-proxy.redhat.com:8080", (String)"[lj]ogin.facebook.com");
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("login.facebook.com").getProxyHost().getHostName());
        Assert.assertEquals((Object)"some-proxy.redhat.com", (Object)proxyMappings.getProxyFor("jogin.facebook.com").getProxyHost().getHostName());
    }

    @Test
    public void shouldReturnEmptyMappingForEmptyHttpProxy() {
        Assert.assertNull((Object)ProxyMappings.withFixedProxyMapping(null, (String)"facebook.com"));
    }

    static {
        MAPPINGS_WITH_FALLBACK.addAll(DEFAULT_MAPPINGS);
        MAPPINGS_WITH_FALLBACK.add(".*;http://fallback:8080");
        MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION.addAll(DEFAULT_MAPPINGS);
        MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION.add(".*\\.acme\\.corp\\.com;NO_PROXY");
        MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION.add(".*;http://fallback:8080");
        MAPPINGS_WITH_PROXY_AUTHENTICATION.add(".*stackexchange\\.com;http://user01:pas2w0rd@proxy3:88");
        MAPPINGS_WITH_PROXY_AUTHENTICATION.addAll(MAPPINGS_WITH_FALLBACK_AND_PROXY_EXCEPTION);
    }
}

