/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.runtime;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import netx.jnlp.AppletDesc;
import netx.jnlp.JNLPFile;
import netx.jnlp.runtime.AppletAudioClip;
import netx.jnlp.runtime.AppletInstance;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.util.WeakList;

public class AppletEnvironment
implements AppletContext,
AppletStub {
    private JNLPFile file;
    private AppletInstance appletInstance;
    private Applet applet;
    private Map parameters;
    private Frame frame;
    private WeakList weakClips = new WeakList();
    private boolean appletStarted = false;
    private boolean destroyed = false;

    public AppletEnvironment(JNLPFile file, final AppletInstance appletInstance) {
        this.file = file;
        this.appletInstance = appletInstance;
        this.applet = appletInstance.getApplet();
        this.parameters = file.getApplet().getParameters();
        this.frame = new Frame(file.getApplet().getName() + " - Applet");
        this.frame.setResizable(false);
        appletInstance.addWindow(this.frame);
        WindowAdapter closer = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                appletInstance.destroy();
                System.exit(0);
            }
        };
        this.frame.addWindowListener(closer);
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Illegal applet stub/context access: applet destroyed.");
        }
    }

    public void destroy() {
        this.destroyed = true;
        List clips = this.weakClips.hardList();
        for (int i = 0; i < clips.size(); ++i) {
            ((AppletAudioClip)clips.get(i)).dispose();
        }
    }

    public Frame getAppletFrame() {
        return this.frame;
    }

    public void startApplet() {
        block3: {
            this.checkDestroyed();
            if (this.appletStarted) {
                return;
            }
            this.appletStarted = true;
            try {
                AppletDesc appletDesc = this.file.getApplet();
                this.applet.setStub(this);
                this.frame.setLayout(new BorderLayout());
                this.frame.add(this.applet);
                this.frame.validate();
                this.frame.pack();
                Insets insets = this.frame.getInsets();
                this.frame.setSize(appletDesc.getWidth() + insets.left + insets.right, appletDesc.getHeight() + insets.top + insets.bottom);
                this.frame.show();
                this.applet.init();
                this.applet.start();
                this.frame.invalidate();
                this.frame.validate();
                this.frame.repaint();
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public Applet getApplet(String name) {
        this.checkDestroyed();
        if (name != null && name.equals(this.file.getApplet().getName())) {
            return this.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        this.checkDestroyed();
        return Collections.enumeration(Arrays.asList(this.applet));
    }

    public AudioClip getAudioClip(URL location) {
        this.checkDestroyed();
        AppletAudioClip clip = new AppletAudioClip(location);
        this.weakClips.add(clip);
        this.weakClips.trimToSize();
        return clip;
    }

    public Image getImage(URL location) {
        this.checkDestroyed();
        Image image = new ImageIcon(location).getImage();
        return image;
    }

    public void showDocument(URL uRL) {
        this.checkDestroyed();
    }

    public void showDocument(URL uRL, String str) {
        this.checkDestroyed();
    }

    public void showStatus(String str) {
        this.checkDestroyed();
    }

    public void setStream(String key, InputStream stream) {
        this.checkDestroyed();
    }

    public InputStream getStream(String key) {
        this.checkDestroyed();
        return null;
    }

    public Iterator getStreamKeys() {
        this.checkDestroyed();
        return null;
    }

    public void appletResize(int width, int height) {
        this.checkDestroyed();
        Insets insets = this.frame.getInsets();
        this.frame.setSize(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public AppletContext getAppletContext() {
        this.checkDestroyed();
        return this;
    }

    public URL getCodeBase() {
        this.checkDestroyed();
        return this.file.getCodeBase();
    }

    public URL getDocumentBase() {
        this.checkDestroyed();
        return this.file.getApplet().getDocumentBase();
    }

    public String getParameter(String name) {
        this.checkDestroyed();
        return (String)this.parameters.get(name);
    }

    public boolean isActive() {
        this.checkDestroyed();
        return true;
    }
}

