/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.DefaultEnumLiteralDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.EnumLiteralDefinition;
import org.jooq.meta.SchemaDefinition;

public class DefaultEnumDefinition
extends AbstractDefinition
implements EnumDefinition {
    private final List<EnumLiteralDefinition> literals = new ArrayList<EnumLiteralDefinition>();
    private final boolean isSynthetic;

    public DefaultEnumDefinition(SchemaDefinition schema, String name, String comment) {
        this(schema, name, comment, false);
    }

    public DefaultEnumDefinition(SchemaDefinition schema, String name, String comment, boolean isSynthetic) {
        super(schema.getDatabase(), schema, name, comment);
        this.isSynthetic = isSynthetic;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getSchema().getDefinitionPath());
        result.add(this);
        return result;
    }

    public void addLiteral(String literal) {
        this.literals.add(new DefaultEnumLiteralDefinition(this.getDatabase(), this, literal, literal, this.literals.size() + 1));
    }

    public void addLiterals(String ... l) {
        for (String literal : l) {
            this.addLiteral(literal);
        }
    }

    @Override
    public List<String> getLiterals() {
        return this.literals.stream().map(l -> l.getLiteral()).collect(Collectors.toList());
    }

    @Override
    public List<EnumLiteralDefinition> getLiteralDefinitions() {
        return new ArrayList<EnumLiteralDefinition>(this.literals);
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic;
    }
}

