/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.JoglVersion;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;

public class GLFBODrawableImpl
extends GLDrawableImpl
implements GLFBODrawable {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG || Debug.debug("FBObject");
    private final GLDrawableImpl parent;
    private GLCapabilitiesImmutable origParentChosenCaps;
    private boolean initialized = false;
    private int texUnit;
    private int samples;
    private boolean fboResetQuirk;
    private FBObject[] fbos;
    private int fboIBack;
    private int fboIFront;
    private int pendingFBOReset = -1;
    private boolean fboBound;
    private static volatile boolean resetQuirkInfoDumped = false;
    private static final int bufferCount = 2;
    private SwapBufferContext swapBufferContext;
    private static final String illegalBufferName = "Only GL_FRONT and GL_BACK buffer are allowed, passed ";

    protected GLFBODrawableImpl(GLDrawableFactoryImpl gLDrawableFactoryImpl, GLDrawableImpl gLDrawableImpl, NativeSurface nativeSurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
        super(gLDrawableFactoryImpl, nativeSurface, gLCapabilitiesImmutable, false);
        this.parent = gLDrawableImpl;
        this.origParentChosenCaps = this.getChosenGLCapabilities();
        this.texUnit = n;
        this.samples = gLCapabilitiesImmutable.getNumSamples();
        this.fboResetQuirk = false;
        this.swapBufferContext = null;
    }

    private final void initialize(boolean bl, GL gL) {
        if (bl) {
            int n;
            GLCapabilities gLCapabilities = (GLCapabilities)this.getChosenGLCapabilities();
            int n2 = gL.getMaxRenderbufferSamples();
            int n3 = n = this.samples <= n2 ? this.samples : n2;
            if (DEBUG) {
                System.err.println("GLFBODrawableImpl.initialize(): samples " + this.samples + " -> " + n + "/" + n2);
            }
            this.samples = n;
            n = this.samples > 0 ? 1 : (gLCapabilities.getDoubleBuffered() ? 2 : 1);
            this.fbos = new FBObject[n];
            this.fboIBack = 0;
            this.fboIFront = this.fbos.length - 1;
            for (int i = 0; i < n; ++i) {
                this.fbos[i] = new FBObject();
                this.fbos[i].reset(gL, this.getWidth(), this.getHeight(), this.samples, false);
                if (this.fbos[i].getNumSamples() != this.samples) {
                    throw new InternalError("Sample number mismatch: " + this.samples + ", fbos[" + i + "] " + this.fbos[i]);
                }
                if (this.samples > 0) {
                    this.fbos[i].attachColorbuffer(gL, 0, gLCapabilities.getAlphaBits() > 0);
                } else {
                    this.fbos[i].attachTexture2D(gL, 0, gLCapabilities.getAlphaBits() > 0);
                }
                if (gLCapabilities.getStencilBits() > 0) {
                    this.fbos[i].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH_STENCIL, 24);
                    continue;
                }
                this.fbos[i].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
            }
            this.fbos[this.fboIFront].resetSamplingSink(gL);
            this.fboBound = false;
            this.fbos[0].formatToGLCapabilities(gLCapabilities);
            gLCapabilities.setDoubleBuffered(gLCapabilities.getDoubleBuffered() || this.samples > 0);
            this.initialized = true;
        } else {
            this.initialized = false;
            for (int i = 0; i < this.fbos.length; ++i) {
                this.fbos[i].destroy(gL);
            }
            this.fbos = null;
            this.fboBound = false;
            this.pendingFBOReset = -1;
        }
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.initialize(" + bl + "): " + this);
            Thread.dumpStack();
        }
    }

    public final void setSwapBufferContext(SwapBufferContext swapBufferContext) {
        this.swapBufferContext = swapBufferContext;
    }

    private final void reset(GL gL, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.fboResetQuirk) {
            try {
                this.fbos[n].reset(gL, n2, n3, n4, false);
                if (this.fbos[n].getNumSamples() != n4) {
                    throw new InternalError("Sample number mismatch: " + n4 + ", fbos[" + n + "] " + this.fbos[n]);
                }
                return;
            }
            catch (GLException gLException) {
                if (DEBUG) {
                    gLException.printStackTrace();
                }
                if (!resetQuirkInfoDumped) {
                    resetQuirkInfoDumped = true;
                    System.err.println("GLFBODrawable: FBO Reset failed: " + gLException.getMessage());
                    System.err.println("GLFBODrawable: Enabling FBOResetQuirk, due to GL driver bug.");
                    JoglVersion joglVersion = JoglVersion.getInstance();
                    if (DEBUG) {
                        System.err.println(VersionUtil.getPlatformInfo());
                        System.err.println(joglVersion.toString());
                        System.err.println(JoglVersion.getGLInfo(gL, null));
                    } else {
                        System.err.println(joglVersion.getBriefOSGLBuildInfo(gL, null));
                    }
                }
                this.fboResetQuirk = true;
            }
        }
        this.fbos[n].destroy(gL);
        this.fbos[n] = new FBObject();
        this.fbos[n].reset(gL, this.getWidth(), this.getHeight(), n4, false);
        if (this.fbos[n].getNumSamples() != n4) {
            throw new InternalError("Sample number mismatch: " + n4 + ", fbos[" + n + "] " + this.fbos[n]);
        }
        if (n4 > 0) {
            this.fbos[n].attachColorbuffer(gL, 0, n5 > 0);
        } else {
            this.fbos[n].attachTexture2D(gL, 0, n5 > 0);
        }
        if (n6 > 0) {
            this.fbos[n].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH_STENCIL, 24);
        } else {
            this.fbos[n].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reset(GL gL, int n) throws GLException {
        boolean bl;
        if (!this.initialized) {
            return;
        }
        GLContext gLContext = GLContext.getCurrent();
        GLContext gLContext2 = gL.getContext();
        boolean bl2 = bl = null != gLContext && gLContext != gLContext2;
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.reset(newSamples " + n + "): BEGIN - ctxSwitch " + bl + ", " + this);
            Thread.dumpStack();
        }
        Throwable throwable = null;
        Throwable throwable2 = null;
        gLContext2.makeCurrent();
        this.fboBound = false;
        try {
            int n2 = gL.getMaxRenderbufferSamples();
            int n3 = n = n <= n2 ? n : n2;
            if (0 == this.samples && 0 < n || 0 < this.samples && 0 == n) {
                if (DEBUG) {
                    System.err.println("GLFBODrawableImpl.reset(): samples [on/off] reconfig: " + this.samples + " -> " + n + "/" + n2);
                }
                this.initialize(false, gL);
                this.samples = n;
                this.initialize(true, gL);
            } else {
                if (DEBUG) {
                    System.err.println("GLFBODrawableImpl.reset(): simple reconfig: " + this.samples + " -> " + n + "/" + n2);
                }
                int n4 = this.getWidth();
                int n5 = this.getHeight();
                this.samples = n;
                this.pendingFBOReset = 1 < this.fbos.length ? this.fboIFront : -1;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
                for (int i = 0; i < this.fbos.length; ++i) {
                    if (this.pendingFBOReset == i) continue;
                    this.reset(gL, i, n4, n5, this.samples, gLCapabilitiesImmutable.getAlphaBits(), gLCapabilitiesImmutable.getStencilBits());
                }
                GLCapabilities gLCapabilities = (GLCapabilities)this.surface.getGraphicsConfiguration().getChosenCapabilities();
                this.fbos[0].formatToGLCapabilities(gLCapabilities);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
        }
        finally {
            try {
                gLContext2.release();
                if (bl) {
                    gLContext.makeCurrent();
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
            }
        }
        if (null != throwable) {
            throw new GLException("GLFBODrawableImpl.reset(..) FBObject.reset(..) exception", throwable);
        }
        if (null != throwable2) {
            throw new GLException("GLFBODrawableImpl.reset(..) GLContext.release() exception", throwable2);
        }
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.reset(newSamples " + n + "): END " + this);
        }
    }

    @Override
    public final GLContext createContext(GLContext gLContext) {
        GLContext gLContext2 = this.parent.createContext(gLContext);
        gLContext2.setGLDrawable(this, false);
        return gLContext2;
    }

    @Override
    public final GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.parent.getGLDynamicLookupHelper();
    }

    @Override
    protected final int getDefaultDrawFramebuffer() {
        return this.initialized ? this.fbos[this.fboIBack].getWriteFramebuffer() : 0;
    }

    @Override
    protected final int getDefaultReadFramebuffer() {
        return this.initialized ? this.fbos[this.fboIFront].getReadFramebuffer() : 0;
    }

    @Override
    protected final void setRealizedImpl() {
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)this.surface.getGraphicsConfiguration();
        if (this.realized) {
            this.parent.setRealized(true);
            this.origParentChosenCaps = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
            GLCapabilities gLCapabilities = (GLCapabilities)this.origParentChosenCaps.cloneMutable();
            gLCapabilities.copyFrom(this.getRequestedGLCapabilities());
            mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilities);
        } else {
            mutableGraphicsConfiguration.setChosenCapabilities(this.origParentChosenCaps);
            this.parent.setRealized(false);
        }
    }

    @Override
    protected final void contextRealized(GLContext gLContext, boolean bl) {
        this.initialize(bl, gLContext.getGL());
    }

    @Override
    protected final void contextMadeCurrent(GLContext gLContext, boolean bl) {
        GL gL = gLContext.getGL();
        if (bl) {
            this.fbos[this.fboIBack].bind(gL);
            this.fboBound = true;
        } else if (this.fboBound) {
            this.swapFBOImpl(gLContext);
            this.swapFBOImplPost(gLContext);
            this.fboBound = false;
            if (DEBUG) {
                System.err.println("Post FBO swap(@release): done");
            }
        }
    }

    @Override
    protected void swapBuffersImpl(boolean bl) {
        GLContext gLContext = GLContext.getCurrent();
        boolean bl2 = false;
        if (null != gLContext && gLContext.getGLDrawable() == this && this.fboBound) {
            this.swapFBOImpl(gLContext);
            bl2 = true;
            this.fboBound = false;
            if (DEBUG) {
                System.err.println("Post FBO swap(@swap): done");
            }
        }
        if (null != this.swapBufferContext) {
            this.swapBufferContext.swapBuffers(bl);
        }
        if (bl2) {
            this.swapFBOImplPost(gLContext);
        }
    }

    private final void swapFBOImplPost(GLContext gLContext) {
        if (0 <= this.pendingFBOReset) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
            this.reset(gLContext.getGL(), this.pendingFBOReset, this.getWidth(), this.getHeight(), this.samples, gLCapabilitiesImmutable.getAlphaBits(), gLCapabilitiesImmutable.getStencilBits());
            this.pendingFBOReset = -1;
        }
    }

    private final void swapFBOImpl(GLContext gLContext) {
        FBObject.Colorbuffer colorbuffer;
        int n;
        GL gL = gLContext.getGL();
        this.fbos[this.fboIBack].markUnbound();
        if (DEBUG && (n = (this.fboIFront + 1) % this.fbos.length) != this.fboIBack) {
            throw new InternalError("XXX: " + n + "!=" + this.fboIBack);
        }
        this.fboIFront = this.fboIBack;
        this.fboIBack = (this.fboIBack + 1) % this.fbos.length;
        FBObject.Colorbuffer colorbuffer2 = colorbuffer = this.samples > 0 ? this.fbos[this.fboIFront].getSamplingSink() : this.fbos[this.fboIFront].getColorbuffer(0);
        if (!(colorbuffer instanceof FBObject.TextureAttachment)) {
            if (null == colorbuffer) {
                throw new GLException("Front colorbuffer is null: samples " + this.samples + ", " + this);
            }
            throw new GLException("Front colorbuffer is not a texture: " + colorbuffer.getClass().getName() + ": samples " + this.samples + ", " + colorbuffer + ", " + this);
        }
        FBObject.Colorbuffer colorbuffer3 = colorbuffer;
        gL.glActiveTexture(33984 + this.texUnit);
        this.fbos[this.fboIFront].use(gL, (FBObject.TextureAttachment)colorbuffer3);
        if (DEBUG) {
            System.err.println("Post FBO swap(X): fboI back " + this.fboIBack + ", front " + this.fboIFront + ", num " + this.fbos.length);
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final void resetSize(GL gL) throws GLException {
        this.reset(gL, this.samples);
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit;
    }

    @Override
    public final void setTextureUnit(int n) {
        this.texUnit = n;
    }

    @Override
    public final int getNumSamples() {
        return this.samples;
    }

    @Override
    public void setNumSamples(GL gL, int n) throws GLException {
        if (this.samples != n) {
            this.reset(gL, n);
        }
    }

    @Override
    public FBObject getFBObject(int n) throws IllegalArgumentException {
        FBObject fBObject;
        if (!this.initialized) {
            return null;
        }
        switch (n) {
            case 1028: {
                if (this.samples > 0) {
                    fBObject = this.fbos[0].getSamplingSinkFBO();
                    break;
                }
                fBObject = this.fbos[this.fboIFront];
                break;
            }
            case 1029: {
                fBObject = this.fbos[this.fboIBack];
                break;
            }
            default: {
                throw new IllegalArgumentException(illegalBufferName + GLFBODrawableImpl.toHexString(n));
            }
        }
        return fBObject;
    }

    @Override
    public final FBObject.TextureAttachment getTextureBuffer(int n) throws IllegalArgumentException {
        FBObject.TextureAttachment textureAttachment;
        if (!this.initialized) {
            return null;
        }
        switch (n) {
            case 1028: {
                if (this.samples > 0) {
                    textureAttachment = this.fbos[0].getSamplingSink();
                    break;
                }
                textureAttachment = (FBObject.TextureAttachment)this.fbos[this.fboIFront].getColorbuffer(0);
                break;
            }
            case 1029: {
                if (this.samples > 0) {
                    throw new IllegalArgumentException("Cannot access GL_BACK buffer of MSAA FBO: " + this);
                }
                textureAttachment = (FBObject.TextureAttachment)this.fbos[this.fboIBack].getColorbuffer(0);
                break;
            }
            default: {
                throw new IllegalArgumentException(illegalBufferName + GLFBODrawableImpl.toHexString(n));
            }
        }
        return textureAttachment;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[Initialized " + this.initialized + ", realized " + this.isRealized() + ", texUnit " + this.texUnit + ", samples " + this.samples + ",\n\tFactory   " + this.getFactory() + ",\n\tHandle    " + GLFBODrawableImpl.toHexString(this.getHandle()) + ",\n\tCaps      " + this.surface.getGraphicsConfiguration().getChosenCapabilities() + ",\n\tfboI back " + this.fboIBack + ", front " + this.fboIFront + ", num " + (this.initialized ? this.fbos.length : 0) + ",\n\tFBO front read " + this.getDefaultReadFramebuffer() + ", " + this.getFBObject(1028) + ",\n\tFBO back  write " + this.getDefaultDrawFramebuffer() + ", " + this.getFBObject(1029) + ",\n\tSurface   " + this.getNativeSurface() + "]";
    }

    public static class ResizeableImpl
    extends GLFBODrawableImpl
    implements GLFBODrawable.Resizeable {
        protected ResizeableImpl(GLDrawableFactoryImpl gLDrawableFactoryImpl, GLDrawableImpl gLDrawableImpl, ProxySurface proxySurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
            super(gLDrawableFactoryImpl, gLDrawableImpl, proxySurface, gLCapabilitiesImmutable, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setSize(GLContext gLContext, int n, int n2) throws NativeWindowException, GLException {
            int n3;
            if (DEBUG) {
                System.err.println("GLFBODrawableImpl.ResizeableImpl setSize: (" + Thread.currentThread().getName() + "): " + n + "x" + n2 + " - surfaceHandle 0x" + Long.toHexString(this.getNativeSurface().getSurfaceHandle()));
            }
            if (1 >= (n3 = this.lockSurface())) {
                throw new NativeWindowException("Could not lock surface: " + this);
            }
            try {
                ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (!(upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize)) {
                    throw new InternalError("GLFBODrawableImpl.ResizableImpl's ProxySurface doesn't hold a UpstreamSurfaceHookMutableSize but " + upstreamSurfaceHook.getClass().getName() + ", " + proxySurface + ", ush");
                }
                ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSize(n, n2);
                if (null != gLContext && gLContext.isCreated()) {
                    this.resetSize(gLContext.getGL());
                }
            }
            finally {
                this.unlockSurface();
            }
        }
    }

    public static interface SwapBufferContext {
        public void swapBuffers(boolean var1);
    }
}

