/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import org.joda.money.IllegalCurrencyException;
import org.joda.money.format.AmountPrinterParser;
import org.joda.money.format.LiteralPrinterParser;
import org.joda.money.format.MoneyAmountStyle;
import org.joda.money.format.MoneyFormatter;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;
import org.joda.money.format.SignedPrinterParser;

public final class MoneyFormatterBuilder {
    private final List<MoneyPrinter> printers = new ArrayList<MoneyPrinter>();
    private final List<MoneyParser> parsers = new ArrayList<MoneyParser>();

    public MoneyFormatterBuilder appendAmount() {
        AmountPrinterParser pp = new AmountPrinterParser(MoneyAmountStyle.ASCII_DECIMAL_POINT_GROUP3_COMMA);
        return this.appendInternal(pp, pp);
    }

    public MoneyFormatterBuilder appendAmountLocalized() {
        AmountPrinterParser pp = new AmountPrinterParser(MoneyAmountStyle.LOCALIZED_GROUPING);
        return this.appendInternal(pp, pp);
    }

    public MoneyFormatterBuilder appendAmount(MoneyAmountStyle style) {
        MoneyFormatter.checkNotNull(style, "MoneyAmountStyle must not be null");
        AmountPrinterParser pp = new AmountPrinterParser(style);
        return this.appendInternal(pp, pp);
    }

    public MoneyFormatterBuilder appendCurrencyCode() {
        return this.appendInternal(Singletons.CODE, Singletons.CODE);
    }

    public MoneyFormatterBuilder appendCurrencyNumeric3Code() {
        return this.appendInternal(Singletons.NUMERIC_3_CODE, Singletons.NUMERIC_3_CODE);
    }

    public MoneyFormatterBuilder appendCurrencyNumericCode() {
        return this.appendInternal(Singletons.NUMERIC_CODE, Singletons.NUMERIC_CODE);
    }

    public MoneyFormatterBuilder appendCurrencySymbolLocalized() {
        return this.appendInternal(SingletonPrinters.LOCALIZED_SYMBOL, null);
    }

    public MoneyFormatterBuilder appendLiteral(CharSequence literal) {
        if (literal == null || literal.length() == 0) {
            return this;
        }
        LiteralPrinterParser pp = new LiteralPrinterParser(literal.toString());
        return this.appendInternal(pp, pp);
    }

    public MoneyFormatterBuilder append(MoneyFormatter formatter) {
        MoneyFormatter.checkNotNull(formatter, "MoneyFormatter must not be null");
        formatter.getPrinterParser().appendTo(this);
        return this;
    }

    public MoneyFormatterBuilder append(MoneyPrinter printer, MoneyParser parser) {
        return this.appendInternal(printer, parser);
    }

    public MoneyFormatterBuilder appendSigned(MoneyFormatter whenPositiveOrZero, MoneyFormatter whenNegative) {
        return this.appendSigned(whenPositiveOrZero, whenPositiveOrZero, whenNegative);
    }

    public MoneyFormatterBuilder appendSigned(MoneyFormatter whenPositive, MoneyFormatter whenZero, MoneyFormatter whenNegative) {
        MoneyFormatter.checkNotNull(whenPositive, "MoneyFormatter whenPositive must not be null");
        MoneyFormatter.checkNotNull(whenZero, "MoneyFormatter whenZero must not be null");
        MoneyFormatter.checkNotNull(whenNegative, "MoneyFormatter whenNegative must not be null");
        SignedPrinterParser pp = new SignedPrinterParser(whenPositive, whenZero, whenNegative);
        return this.appendInternal(pp, pp);
    }

    private MoneyFormatterBuilder appendInternal(MoneyPrinter printer, MoneyParser parser) {
        this.printers.add(printer);
        this.parsers.add(parser);
        return this;
    }

    public MoneyFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public MoneyFormatter toFormatter(Locale locale) {
        MoneyFormatter.checkNotNull(locale, "Locale must not be null");
        MoneyPrinter[] printersCopy = this.printers.toArray(new MoneyPrinter[this.printers.size()]);
        MoneyParser[] parsersCopy = this.parsers.toArray(new MoneyParser[this.parsers.size()]);
        return new MoneyFormatter(locale, printersCopy, parsersCopy);
    }

    private static enum Singletons implements MoneyPrinter,
    MoneyParser
    {
        CODE("${code}"){

            @Override
            public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
                appendable.append(money.getCurrencyUnit().getCode());
            }

            @Override
            public void parse(MoneyParseContext context) {
                int endPos = context.getIndex() + 3;
                if (endPos > context.getTextLength()) {
                    context.setError();
                } else {
                    String code = context.getTextSubstring(context.getIndex(), endPos);
                    try {
                        context.setCurrency(CurrencyUnit.of(code));
                        context.setIndex(endPos);
                    }
                    catch (IllegalCurrencyException ex) {
                        context.setError();
                    }
                }
            }
        }
        ,
        NUMERIC_3_CODE("${numeric3Code}"){

            @Override
            public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
                appendable.append(money.getCurrencyUnit().getNumeric3Code());
            }

            @Override
            public void parse(MoneyParseContext context) {
                int endPos = context.getIndex() + 3;
                if (endPos > context.getTextLength()) {
                    context.setError();
                } else {
                    String code = context.getTextSubstring(context.getIndex(), endPos);
                    try {
                        context.setCurrency(CurrencyUnit.ofNumericCode(code));
                        context.setIndex(endPos);
                    }
                    catch (IllegalCurrencyException ex) {
                        context.setError();
                    }
                }
            }
        }
        ,
        NUMERIC_CODE("${numericCode}"){

            @Override
            public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
                appendable.append(Integer.toString(money.getCurrencyUnit().getNumericCode()));
            }

            @Override
            public void parse(MoneyParseContext context) {
                char ch;
                int count;
                for (count = 0; count < 3 && context.getIndex() + count < context.getTextLength() && (ch = context.getText().charAt(context.getIndex() + count)) >= '0' && ch <= '9'; ++count) {
                }
                int endPos = context.getIndex() + count;
                String code = context.getTextSubstring(context.getIndex(), endPos);
                try {
                    context.setCurrency(CurrencyUnit.ofNumericCode(code));
                    context.setIndex(endPos);
                }
                catch (IllegalCurrencyException ex) {
                    context.setError();
                }
            }
        };

        private final String toString;

        private Singletons(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }

    private static enum SingletonPrinters implements MoneyPrinter
    {
        LOCALIZED_SYMBOL;


        @Override
        public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
            appendable.append(money.getCurrencyUnit().getSymbol(context.getLocale()));
        }

        public String toString() {
            return "${symbolLocalized}";
        }
    }
}

