/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ValueInfo;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.ProcessClassLoaderFactory;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_RESOURCE = "jbpm.cfg.xml";
    static final String OBJECT_NAME = "jbpm.configuration";
    private static ObjectFactory defaultObjectFactory;
    private static final Map instances;
    private static final ThreadLocal threadLocalConfigurationStack;
    private final ObjectFactory objectFactory;
    private final String resourceName;
    private final transient ThreadLocal threadLocalContextStack = new ThreadLocal();
    private JobExecutor jobExecutor;
    private volatile boolean isClosed;
    private static final Log log;

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this(objectFactory, null);
    }

    private JbpmConfiguration(ObjectFactory objectFactory, String resourceName) {
        if (objectFactory == null) {
            throw new IllegalArgumentException("object factory is null");
        }
        this.objectFactory = objectFactory;
        this.resourceName = resourceName;
    }

    ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    String getResourceName() {
        return this.resourceName;
    }

    public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
        defaultObjectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance;
        if (resource == null) {
            resource = DEFAULT_RESOURCE;
        }
        Map map = instances;
        synchronized (map) {
            instance = (JbpmConfiguration)instances.get(resource);
            if (instance == null) {
                if (defaultObjectFactory != null) {
                    log.info((Object)"configuring from default object factory");
                    instance = new JbpmConfiguration(defaultObjectFactory);
                } else {
                    log.info((Object)("configuring from resource: " + resource));
                    InputStream jbpmCfgXmlStream = ClassLoaderUtil.getStream(resource, false);
                    if (jbpmCfgXmlStream == null && !DEFAULT_RESOURCE.equals(resource)) {
                        log.warn((Object)("configuration resource not found: " + resource));
                    }
                    ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(jbpmCfgXmlStream);
                    instance = JbpmConfiguration.createJbpmConfiguration(objectFactory, resource);
                }
                instances.put(resource, instance);
            }
        }
        return instance;
    }

    public static boolean hasInstance(String resource) {
        return instances.containsKey(resource != null ? resource : DEFAULT_RESOURCE);
    }

    protected static ObjectFactory parseObjectFactory(InputStream inputStream) {
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ObjectFactoryImpl objectFactory = new ObjectFactoryImpl();
        objectFactoryParser.parseElementsFromResource("org/jbpm/default.jbpm.cfg.xml", objectFactory);
        if (inputStream != null) {
            objectFactoryParser.parseElementsStream(inputStream, objectFactory);
        }
        return objectFactory;
    }

    private static ObjectFactory loadDefaultObjectFactory() {
        log.info((Object)"loading default configuration");
        return ObjectFactoryParser.parseResource("org/jbpm/default.jbpm.cfg.xml");
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        ObjectFactory objectFactory;
        if (xml != null) {
            log.info((Object)"configuring from xml string");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        } else {
            objectFactory = JbpmConfiguration.loadDefaultObjectFactory();
        }
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    protected static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory) {
        return JbpmConfiguration.createJbpmConfiguration(objectFactory, null);
    }

    private static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory, String resourceName) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration(objectFactory, resourceName);
        if (objectFactory instanceof ObjectFactoryImpl) {
            ObjectFactoryImpl objectFactoryImpl = (ObjectFactoryImpl)objectFactory;
            objectFactoryImpl.addObjectInfo(new ValueInfo("jbpmConfiguration", jbpmConfiguration));
            objectFactoryImpl.addObjectInfo(new ValueInfo(OBJECT_NAME, jbpmConfiguration));
        }
        return jbpmConfiguration;
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        ObjectFactory objectFactory;
        if (inputStream != null) {
            log.info((Object)("configuring from " + inputStream));
            objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        } else {
            objectFactory = JbpmConfiguration.loadDefaultObjectFactory();
        }
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        ObjectFactory objectFactory;
        if (resource != null) {
            log.info((Object)("configuring from resource: " + resource));
            InputStream inputStream = ClassLoaderUtil.getStream(resource, false);
            if (inputStream == null) {
                throw new IllegalArgumentException("resource not found: " + resource);
            }
            objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn((Object)("failed to close resource: " + resource), (Throwable)e);
            }
        } else {
            objectFactory = JbpmConfiguration.loadDefaultObjectFactory();
        }
        return JbpmConfiguration.createJbpmConfiguration(objectFactory, resource);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        this.ensureOpen();
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        this.pushJbpmContext(jbpmContext);
        return jbpmContext;
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            ServiceFactory serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
            return serviceFactory;
        }
        finally {
            jbpmContext.close();
        }
    }

    private DbPersistenceServiceFactory getPersistenceServiceFactory(String jbpmContextName) {
        return (DbPersistenceServiceFactory)this.getServiceFactory("persistence", jbpmContextName);
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        ProcessClassLoaderFactory factory = (ProcessClassLoaderFactory)Configs.getObject("process.class.loader.factory");
        return factory.getProcessClassLoader(processDefinition);
    }

    public void cleanSchema() {
        this.cleanSchema("default.jbpm.context");
    }

    public void cleanSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).cleanSchema();
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    public void createSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).createSchema();
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    public void dropSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).dropSchema();
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new JbpmException(this + " is closed");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.close("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String jbpmContextName) {
        if (this.isClosed) {
            return;
        }
        Object object = this;
        synchronized (object) {
            List contextStack;
            if (this.jobExecutor != null) {
                try {
                    this.jobExecutor.stopAndJoin();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.jobExecutor = null;
            }
            if ((contextStack = (List)this.threadLocalContextStack.get()) != null && !contextStack.isEmpty()) {
                log.warn((Object)("closing " + contextStack.size() + " open contexts;" + " make sure to close JbpmContext after use"));
                JbpmContext[] jbpmContexts = contextStack.toArray(new JbpmContext[contextStack.size()]);
                for (int i = 0; i < jbpmContexts.length; ++i) {
                    jbpmContexts[i].close();
                }
            }
            JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
            try {
                Map serviceFactories = jbpmContext.getServices().getServiceFactories();
                if (serviceFactories != null) {
                    for (ServiceFactory serviceFactory : serviceFactories.values()) {
                        serviceFactory.close();
                    }
                }
            }
            finally {
                jbpmContext.close();
            }
            this.threadLocalContextStack.set(null);
        }
        this.isClosed = true;
        if (this.resourceName != null) {
            object = instances;
            synchronized (object) {
                instances.remove(this.resourceName);
            }
        }
    }

    static JbpmConfiguration getCurrentJbpmConfiguration() {
        List stack = (List)threadLocalConfigurationStack.get();
        return stack == null || stack.isEmpty() ? null : (JbpmConfiguration)stack.get(stack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearInstances() {
        Map map = instances;
        synchronized (map) {
            instances.clear();
        }
    }

    public JbpmContext getCurrentJbpmContext() {
        this.ensureOpen();
        List stack = (List)this.threadLocalContextStack.get();
        return stack == null || stack.isEmpty() ? null : (JbpmContext)stack.get(stack.size() - 1);
    }

    void pushJbpmContext(JbpmContext jbpmContext) {
        ArrayList<JbpmConfiguration> configStack = (ArrayList<JbpmConfiguration>)threadLocalConfigurationStack.get();
        if (configStack == null) {
            configStack = new ArrayList<JbpmConfiguration>();
            threadLocalConfigurationStack.set(configStack);
        }
        configStack.add(this);
        ArrayList<JbpmContext> contextStack = (ArrayList<JbpmContext>)this.threadLocalContextStack.get();
        if (contextStack == null) {
            contextStack = new ArrayList<JbpmContext>();
            this.threadLocalContextStack.set(contextStack);
        }
        contextStack.add(jbpmContext);
    }

    private static void remove(ThreadLocal threadLocal) {
        try {
            Method removeMethod = ThreadLocal.class.getMethod("remove", null);
            try {
                removeMethod.invoke((Object)threadLocal, null);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(JbpmConfiguration.class + " has no access to " + removeMethod);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new JbpmException(removeMethod + " threw exception", cause);
            }
        }
        catch (NoSuchMethodException e) {
            threadLocal.set(null);
        }
    }

    void popJbpmContext(JbpmContext jbpmContext) {
        int configIndex;
        int contextIndex;
        boolean threadSafetyFlag = false;
        boolean creationOrderFlag = false;
        List contextStack = (List)this.threadLocalContextStack.get();
        if (contextStack == null || (contextIndex = contextStack.lastIndexOf(jbpmContext)) == -1) {
            threadSafetyFlag = true;
        } else {
            if (contextIndex != contextStack.size() - 1) {
                creationOrderFlag = true;
            }
            contextStack.remove(contextIndex);
            if (contextStack.isEmpty()) {
                JbpmConfiguration.remove(this.threadLocalContextStack);
            }
        }
        List configStack = (List)threadLocalConfigurationStack.get();
        if (configStack == null || (configIndex = configStack.lastIndexOf(this)) == -1) {
            threadSafetyFlag = true;
        } else {
            if (configIndex != configStack.size() - 1) {
                creationOrderFlag = true;
            }
            configStack.remove(configIndex);
            if (configStack.isEmpty()) {
                JbpmConfiguration.remove(threadLocalConfigurationStack);
            }
        }
        if (threadSafetyFlag) {
            log.warn((Object)(jbpmContext + " was not closed in the thread that created it;" + " JbpmContext is not safe for access from multiple threads!"));
        } else if (creationOrderFlag) {
            log.warn((Object)(jbpmContext + " was not closed in a block-structured manner;" + " check try-finally clauses around JbpmContext blocks"));
        }
    }

    public void startJobExecutor() {
        this.getJobExecutor().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutor getJobExecutor() {
        this.ensureOpen();
        JbpmConfiguration jbpmConfiguration = this;
        synchronized (jbpmConfiguration) {
            if (this.jobExecutor == null) {
                this.jobExecutor = (JobExecutor)this.objectFactory.createObject("jbpm.job.executor");
            }
        }
        return this.jobExecutor;
    }

    public String toString() {
        return "JbpmConfiguration" + (this.resourceName != null ? '(' + this.resourceName + ')' : '@' + Integer.toHexString(this.hashCode()));
    }

    static {
        instances = new HashMap();
        threadLocalConfigurationStack = new ThreadLocal();
        log = LogFactory.getLog(JbpmConfiguration.class);
    }

    public static class Configs {
        private Configs() {
        }

        public static ObjectFactory getObjectFactory() {
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            return jbpmContext != null ? jbpmContext.getObjectFactory() : JbpmConfiguration.getInstance().getObjectFactory();
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            JbpmConfiguration.setDefaultObjectFactory(objectFactory);
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static synchronized Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static int getInt(String name) {
            return (Integer)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }
}

