/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.invocation;

import java.security.Principal;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.common.invocation.AbstractInvocationHandlerJSE;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.ResourceInjector;
import org.jboss.wsf.spi.invocation.ResourceInjectorFactory;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;
import org.w3c.dom.Element;

public final class InvocationHandlerJAXWS
extends AbstractInvocationHandlerJSE {
    private static final String POJO_JNDI_PREFIX = "java:comp/env/";

    @Override
    protected void onEndpointInstantiated(Endpoint endpoint, Invocation invocation) {
        InjectionsMetaData injectionsMD = (InjectionsMetaData)endpoint.getAttachment(InjectionsMetaData.class);
        Object targetBean = this.getTargetBean(invocation);
        this.log.debug((Object)("Injecting resources on JAXWS JSE endpoint: " + targetBean));
        if (injectionsMD != null) {
            InjectionHelper.injectResources(targetBean, injectionsMD, endpoint.getJNDIContext());
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ResourceInjectorFactory resourceInjectorFactory = (ResourceInjectorFactory)spiProvider.getSPI(ResourceInjectorFactory.class);
        ResourceInjector wsContextInjector = resourceInjectorFactory.newResourceInjector();
        wsContextInjector.inject(targetBean, (WebServiceContext)ThreadLocalAwareWebServiceContext.getInstance());
        this.log.debug((Object)("Calling postConstruct method on JAXWS JSE endpoint: " + targetBean));
        InjectionHelper.callPostConstructMethod(targetBean);
        endpoint.addAttachment(PreDestroyHolder.class, (Object)new PreDestroyHolder(targetBean));
    }

    @Override
    protected void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    @Override
    protected void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    @Override
    public Context getJNDIContext(Endpoint ep) throws NamingException {
        return (Context)new InitialContext().lookup(POJO_JNDI_PREFIX);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }

    private Object getTargetBean(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return invocationContext.getTargetBean();
    }

    private static final class ThreadLocalAwareWebServiceContext
    implements WebServiceContext {
        private static final ThreadLocalAwareWebServiceContext SINGLETON = new ThreadLocalAwareWebServiceContext();
        private final ThreadLocal<WebServiceContext> contexts = new InheritableThreadLocal<WebServiceContext>();

        private ThreadLocalAwareWebServiceContext() {
        }

        private static ThreadLocalAwareWebServiceContext getInstance() {
            return SINGLETON;
        }

        private void setMessageContext(WebServiceContext ctx) {
            this.contexts.set(ctx);
        }

        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            WebServiceContext delegee = this.contexts.get();
            return delegee == null ? null : delegee.getEndpointReference(referenceParameters);
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            WebServiceContext delegee = this.contexts.get();
            return (T)(delegee == null ? null : delegee.getEndpointReference(clazz, referenceParameters));
        }

        public MessageContext getMessageContext() {
            WebServiceContext delegee = this.contexts.get();
            return delegee == null ? null : delegee.getMessageContext();
        }

        public Principal getUserPrincipal() {
            WebServiceContext delegee = this.contexts.get();
            return delegee == null ? null : delegee.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            WebServiceContext delegee = this.contexts.get();
            return delegee == null ? false : delegee.isUserInRole(role);
        }
    }
}

