/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.xml.BeansXmlElement;
import org.jboss.weld.xml.WeldXmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedElements {
    private List<BeansXmlElement> alternativesElements = new ArrayList<BeansXmlElement>();
    private List<BeansXmlElement> decoratorsElements = new ArrayList<BeansXmlElement>();
    private List<BeansXmlElement> interceptorsElements = new ArrayList<BeansXmlElement>();

    public void merge(URL url, Document beansXmlDocument) {
        Element documentElement = beansXmlDocument.getDocumentElement();
        this.alternativesElements.addAll(this.getNamedElement(url, documentElement, "alternatives", XmlMessage.MULTIPLE_ALTERNATIVES));
        this.interceptorsElements.addAll(this.getNamedElement(url, documentElement, "interceptors", XmlMessage.MULTIPLE_INTERCEPTORS));
        this.decoratorsElements.addAll(this.getNamedElement(url, documentElement, "decorators", XmlMessage.MULTIPLE_DECORATORS));
    }

    private List<BeansXmlElement> getNamedElement(URL url, Element beans, String name, XmlMessage multipleViolationMessage) {
        ArrayList<BeansXmlElement> elements = new ArrayList<BeansXmlElement>();
        NodeList nodeList = beans.getElementsByTagName(name);
        if (nodeList.getLength() > 1) {
            throw new WeldXmlException(multipleViolationMessage, new Object[0]);
        }
        if (nodeList.getLength() == 1) {
            BeansXmlElement element = BeansXmlElement.of(url, nodeList.item(0));
            elements.add(element);
        }
        return elements;
    }

    public List<BeansXmlElement> getAlternativesElements() {
        return this.alternativesElements;
    }

    public List<BeansXmlElement> getDecoratorsElements() {
        return this.decoratorsElements;
    }

    public List<BeansXmlElement> getInterceptorsElements() {
        return this.interceptorsElements;
    }
}

