/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.collections.Iterators;

public class GlobalObserverNotifierService
implements BootstrapService {
    private final Set<BeanManagerImpl> beanManagers = new CopyOnWriteArraySet<BeanManagerImpl>();
    private final ObserverNotifier globalLenientObserverNotifier;
    private final ObserverNotifier globalStrictObserverNotifier;

    public GlobalObserverNotifierService(ServiceRegistry services, String contextId) {
        TypeSafeObserverResolver resolver = new TypeSafeObserverResolver(services.get(MetaAnnotationStore.class), GlobalObserverNotifierService.createGlobalObserverMethodIterable(this.beanManagers), services.get(WeldConfiguration.class));
        this.globalLenientObserverNotifier = ObserverNotifier.of(contextId, resolver, services, false);
        this.globalStrictObserverNotifier = ObserverNotifier.of(contextId, resolver, services, true);
    }

    private static Iterable<ObserverMethod<?>> createGlobalObserverMethodIterable(final Set<BeanManagerImpl> beanManagers) {
        return new Iterable<ObserverMethod<?>>(){

            @Override
            public Iterator<ObserverMethod<?>> iterator() {
                Iterator observerMethodIterators = Iterators.transform(beanManagers.iterator(), new BeanManagerToObserverMethodIterable());
                return Iterators.concat(observerMethodIterators);
            }
        };
    }

    public void registerBeanManager(BeanManagerImpl manager) {
        this.beanManagers.add(manager);
    }

    public ObserverNotifier getGlobalLenientObserverNotifier() {
        return this.globalLenientObserverNotifier;
    }

    public ObserverNotifier getGlobalStrictObserverNotifier() {
        return this.globalStrictObserverNotifier;
    }

    public Iterable<ObserverMethod<?>> getAllObserverMethods() {
        return GlobalObserverNotifierService.createGlobalObserverMethodIterable(this.beanManagers);
    }

    @Override
    public void cleanupAfterBoot() {
        this.globalStrictObserverNotifier.clear();
        this.globalLenientObserverNotifier.clear();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.beanManagers.clear();
    }

    private static class BeanManagerToObserverMethodIterable
    implements Function<BeanManagerImpl, Iterator<ObserverMethod<?>>> {
        private BeanManagerToObserverMethodIterable() {
        }

        @Override
        public Iterator<ObserverMethod<?>> apply(BeanManagerImpl manager) {
            return manager.getObservers().iterator();
        }
    }
}

