/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl.config;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLEntryImpl;
import org.jboss.security.acl.BasicACLPermission;
import org.jboss.security.acl.CompositeACLPermission;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.IdentityFactory;
import org.jboss.xb.binding.GenericValueContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLEntryHolder
implements GenericValueContainer {
    private static Logger logger = Logger.getLogger(ACLEntryHolder.class);
    private Identity identity;
    private CompositeACLPermission permission;

    public void addChild(QName name, Object value) {
        logger.debug((Object)("addChild: name=" + name + ", value=" + value));
        if ("identity-name".equals(name.getLocalPart())) {
            String identityName = (String)value;
            this.identity = this.getIdentityFromString(identityName);
        } else if ("permissions".equals(name.getLocalPart())) {
            String permissions = (String)value;
            this.permission = this.getPermissionsFromString(permissions);
        }
    }

    public Object instantiate() {
        return new ACLEntryImpl(this.permission, this.identity);
    }

    public Class<?> getTargetClass() {
        return ACLEntry.class;
    }

    private Identity getIdentityFromString(String identityName) {
        try {
            return IdentityFactory.createIdentity(identityName);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception caught while constructing Identity object", (Throwable)e);
            return null;
        }
    }

    private CompositeACLPermission getPermissionsFromString(String permissionString) {
        ArrayList<BasicACLPermission> permissions = new ArrayList<BasicACLPermission>();
        if (permissionString != null) {
            String[] elements;
            for (String element : elements = permissionString.split(",")) {
                try {
                    permissions.add(BasicACLPermission.valueOf(element));
                }
                catch (RuntimeException re) {
                    logger.debug((Object)("No BasicACLPermission named " + element + " found"), (Throwable)re);
                }
            }
        }
        return new CompositeACLPermission(permissions.toArray(new BasicACLPermission[permissions.size()]));
    }
}

