/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl.config;

import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.security.acl.config.ACLConfiguration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;

public class ACLConfigurationFactory {
    private static final String schemaName = "schema/jboss-acl-config_1_0.xsd";
    private static Logger log = Logger.getLogger(ACLConfigurationFactory.class);

    public static ACLConfiguration getConfiguration(InputStream aclConfigFileStream) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        SchemaBinding schema = XsdBinder.bind((InputStream)tcl.getResourceAsStream(schemaName), null);
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        try {
            ACLConfiguration configuration = (ACLConfiguration)unmarshaller.unmarshal(aclConfigFileStream, schema);
            return configuration;
        }
        catch (JBossXBException e) {
            log.debug((Object)"Error parsing ACL configuration file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

