/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ELException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.SeamResourceBundle;
import org.jboss.seam.core.Validators;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Param {
    private static final LogProvider log = Logging.getLogProvider(Param.class);
    private final String name;
    private Expressions.ValueExpression valueExpression;
    private boolean required;
    private Expressions.ValueExpression converterValueExpression;
    private String converterId;
    private Expressions.ValueExpression validatorValueExpression;
    private String validatorId;

    public Param(String name) {
        this.name = name;
    }

    public Converter getConverter() {
        if (this.converterId != null) {
            return FacesContext.getCurrentInstance().getApplication().createConverter(this.converterId);
        }
        if (this.converterValueExpression != null) {
            return (Converter)this.converterValueExpression.getValue();
        }
        if (this.valueExpression == null) {
            return null;
        }
        Class type = this.valueExpression.getType();
        if (type == null) {
            return null;
        }
        return FacesContext.getCurrentInstance().getApplication().createConverter(type);
    }

    public Validator getValidator() {
        if (this.validatorId != null) {
            return FacesContext.getCurrentInstance().getApplication().createValidator(this.validatorId);
        }
        if (this.validatorValueExpression != null) {
            return (Validator)this.validatorValueExpression.getValue();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setValueExpression(Expressions.ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public Expressions.ValueExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setConverterValueExpression(Expressions.ValueExpression converterValueExpression) {
        this.converterValueExpression = converterValueExpression;
    }

    public Expressions.ValueExpression getConverterValueExpression() {
        return this.converterValueExpression;
    }

    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    public String getConverterId() {
        return this.converterId;
    }

    public String toString() {
        return "PageParameter(" + this.name + ")";
    }

    public String getStringValueFromModel(FacesContext facesContext) {
        Object value = this.getValueExpression().getValue();
        if (value == null) {
            return null;
        }
        Converter converter = null;
        try {
            converter = this.getConverter();
        }
        catch (RuntimeException re) {
            log.warn("could not create converter for: " + this.name, re);
            return null;
        }
        return converter == null ? value.toString() : converter.getAsString(facesContext, (UIComponent)facesContext.getViewRoot(), value);
    }

    public String getStringValueFromRequest(FacesContext facesContext, Map<String, String[]> requestParameters) throws ValidatorException {
        String[] parameterValues = requestParameters.get(this.getName());
        if (parameterValues == null || parameterValues.length == 0) {
            if (this.isRequired() && !Contexts.getPageContext().isSet(this.getName())) {
                this.addRequiredMessage(facesContext);
            }
            return null;
        }
        if (parameterValues.length > 1) {
            throw new IllegalArgumentException("page parameter may not be multi-valued: " + this.getName());
        }
        String value = parameterValues[0];
        if (value.length() == 0 && this.isRequired()) {
            this.addRequiredMessage(facesContext);
            return null;
        }
        return value;
    }

    public Object convertValueFromString(FacesContext facesContext, String value) {
        Converter converter = null;
        try {
            converter = this.getConverter();
        }
        catch (RuntimeException re) {
            log.warn("could not create converter for: " + this.name, re);
            return null;
        }
        return converter == null ? value : converter.getAsObject(facesContext, (UIComponent)facesContext.getViewRoot(), value);
    }

    public void validateConvertedValue(FacesContext facesContext, Object value) {
        Validator validator = this.getValidator();
        if (validator != null) {
            validator.validate(facesContext, (UIComponent)facesContext.getViewRoot(), value);
        }
        if (this.valueExpression != null) {
            InvalidValue[] invalidValues;
            ELContext elContext = facesContext.getELContext();
            try {
                invalidValues = Validators.instance().validate(this.valueExpression.toUnifiedValueExpression(), elContext, value);
            }
            catch (ELException ele) {
                Throwable cause = ele.getCause();
                if (cause == null) {
                    cause = ele;
                }
                throw new ValidatorException(this.createMessage(cause), cause);
            }
            if (invalidValues.length > 0) {
                throw new ValidatorException(this.createMessage(invalidValues));
            }
        }
    }

    private FacesMessage createMessage(InvalidValue[] invalidValues) {
        return FacesMessages.createFacesMessage(FacesMessage.SEVERITY_ERROR, invalidValues[0].getMessage(), new Object[0]);
    }

    private FacesMessage createMessage(Throwable cause) {
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, "model validation failed:" + cause, null);
    }

    private void addRequiredMessage(FacesContext facesContext) {
        ResourceBundle resourceBundle = SeamResourceBundle.getBundle();
        throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, resourceBundle.getString("javax.faces.component.UIInput.REQUIRED"), null));
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public Expressions.ValueExpression getValidatorValueExpression() {
        return this.validatorValueExpression;
    }

    public void setValidatorValueExpression(Expressions.ValueExpression validatorValueExpression) {
        this.validatorValueExpression = validatorValueExpression;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

