/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpServletResponse;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockServletContext;
import org.jboss.seam.util.EnumerationIterator;

public class MockExternalContext
extends ExternalContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public MockExternalContext() {
        this.context = new MockServletContext();
        this.request = new MockHttpServletRequest(new MockHttpSession(this.context));
        this.response = new MockHttpServletResponse();
    }

    public MockExternalContext(ServletContext context) {
        this.context = context;
        this.request = new MockHttpServletRequest(new MockHttpSession(context));
        this.response = new MockHttpServletResponse();
    }

    public MockExternalContext(ServletContext context, HttpSession session) {
        this.context = context;
        this.request = new MockHttpServletRequest(session);
        this.response = new MockHttpServletResponse();
    }

    public MockExternalContext(ServletContext context, HttpServletRequest request) {
        this.context = context;
        this.request = request;
        this.response = new MockHttpServletResponse();
    }

    public MockExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public MockExternalContext(HttpServletRequest request) {
        this.request = request;
    }

    public void dispatch(String url) throws IOException {
    }

    public String encodeActionURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeNamespace(String ns) {
        return ns;
    }

    public String encodeResourceURL(String url) {
        return this.encodeURL(url);
    }

    public Map getApplicationMap() {
        return new AttributeMap(){

            public Enumeration keys() {
                return MockExternalContext.this.context.getAttributeNames();
            }

            public Object getAttribute(String key) {
                return MockExternalContext.this.context.getAttribute(key);
            }

            public void setAttribute(String key, Object value) {
                MockExternalContext.this.context.setAttribute(key, value);
            }

            public void removeAttribute(String key) {
                MockExternalContext.this.context.removeAttribute(key);
            }
        };
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Object getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration e = this.context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.put(name, this.context.getInitParameter(name));
        }
        return result;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Object getRequest() {
        return this.request;
    }

    public String getRequestContextPath() {
        String path = (String)this.request.getAttribute("org.jboss.seam.web.requestContextPath");
        return path != null ? path : this.request.getContextPath();
    }

    public Map getRequestCookieMap() {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        if (this.request != null && this.request.getCookies() != null) {
            for (Cookie cookie : this.request.getCookies()) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public Map getRequestHeaderMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            result.put(name, this.request.getHeader(name));
        }
        return result;
    }

    public Map getRequestHeaderValuesMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Enumeration en = this.request.getHeaderNames();
        while (en.hasMoreElements()) {
            String header = (String)en.nextElement();
            ArrayList headerList = Collections.list(this.request.getHeaders(header));
            String[] headers = new String[headerList.size()];
            for (int i = 0; i < headerList.size(); ++i) {
                headers[i] = (String)headerList.get(i);
            }
            result.put(header, headers);
        }
        return result;
    }

    public Locale getRequestLocale() {
        return Locale.ENGLISH;
    }

    public Iterator getRequestLocales() {
        return Collections.singleton(Locale.ENGLISH).iterator();
    }

    public Map getRequestMap() {
        return new AttributeMap(){

            public Enumeration keys() {
                return MockExternalContext.this.request.getAttributeNames();
            }

            public Object getAttribute(String key) {
                return MockExternalContext.this.request.getAttribute(key);
            }

            public void setAttribute(String key, Object value) {
                MockExternalContext.this.request.setAttribute(key, value);
            }

            public void removeAttribute(String key) {
                MockExternalContext.this.request.removeAttribute(key);
            }
        };
    }

    public Map getRequestParameterMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = this.request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, this.request.getParameter(name));
        }
        return map;
    }

    public Iterator getRequestParameterNames() {
        return this.request.getParameterMap().keySet().iterator();
    }

    public Map getRequestParameterValuesMap() {
        return this.request.getParameterMap();
    }

    public String getRequestPathInfo() {
        String path = (String)this.request.getAttribute("org.jboss.seam.web.requestPathInfo");
        return path != null ? path : this.request.getPathInfo();
    }

    public String getRequestServletPath() {
        String path = (String)this.request.getAttribute("org.jboss.seam.web.requestServletPath");
        return path != null ? path : this.request.getServletPath();
    }

    public URL getResource(String name) throws MalformedURLException {
        return this.context.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.context.getResourceAsStream(name);
    }

    public Set getResourcePaths(String name) {
        return this.context.getResourcePaths(name);
    }

    public Object getResponse() {
        return this.response;
    }

    public Object getSession(boolean create) {
        return this.request.getSession();
    }

    public Map getSessionMap() {
        final HttpSession session = this.request.getSession(true);
        return new AttributeMap(){

            public Enumeration keys() {
                return session.getAttributeNames();
            }

            public Object getAttribute(String key) {
                return session.getAttribute(key);
            }

            public void setAttribute(String key, Object value) {
                session.setAttribute(key, value);
            }

            public void removeAttribute(String key) {
                session.removeAttribute(key);
            }
        };
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void log(String message, Throwable t) {
    }

    public void log(String t) {
    }

    public void redirect(String url) throws IOException {
        this.response.sendRedirect(url);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String getResponseContentType() {
        return this.response.getContentType();
    }

    protected String encodeURL(String url) {
        if (this.response != null) {
            String encodedUrl = this.response.encodeURL(url);
            url = encodedUrl != null ? encodedUrl : url;
        }
        return url;
    }

    static abstract class AttributeMap
    implements Map {
        AttributeMap() {
        }

        public abstract Enumeration keys();

        public Object get(Object key) {
            return this.getAttribute((String)key);
        }

        public Object put(Object key, Object value) {
            Object result = this.get(key);
            this.setAttribute((String)key, value);
            return result;
        }

        public void clear() {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                this.remove(e.nextElement());
            }
        }

        public boolean containsKey(Object key) {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                if (!key.equals(e.nextElement())) continue;
                return true;
            }
            return false;
        }

        public boolean containsValue(Object value) {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                if (!value.equals(this.get(e.nextElement()))) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public abstract Object getAttribute(String var1);

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public Set keySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return new EnumerationIterator(AttributeMap.this.keys());
                }

                public int size() {
                    return AttributeMap.this.size();
                }
            };
        }

        public abstract void setAttribute(String var1, Object var2);

        public abstract void removeAttribute(String var1);

        public void putAll(Map t) {
            for (Map.Entry me : t.entrySet()) {
                this.put(me.getKey(), me.getValue());
            }
        }

        public Object remove(Object key) {
            Object result = this.getAttribute((String)key);
            this.removeAttribute((String)key);
            return result;
        }

        public int size() {
            int i = 0;
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++i;
            }
            return i;
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }
    }
}

