/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jmx;

import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

@Name(value="org.jboss.seam.jmx.jbossClusterMonitor")
@BypassInterceptors
@Scope(value=ScopeType.APPLICATION)
@Startup
@Install(precedence=0, classDependencies={"org.jgroups.MembershipListener"})
public class JBossClusterMonitor {
    private static Log log = Logging.getLog(JBossClusterMonitor.class);
    private MBeanServer jbossMBeanServer;
    private boolean clustered;
    private ObjectName clusteringCacheObjectName;
    private ObjectName serverObjectName;

    @Create
    public void create() {
        this.jbossMBeanServer = this.locateJBoss();
        if (!this.isJBoss()) {
            return;
        }
        try {
            this.clusteringCacheObjectName = new ObjectName("jboss.cache:service=TomcatClusteringCache");
            this.serverObjectName = new ObjectName("jboss.system:type=Server");
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("Invalid JMX name: " + e.getMessage()), new Object[0]);
        }
        try {
            this.jbossMBeanServer.getMBeanInfo(this.clusteringCacheObjectName);
            this.clustered = true;
            log.info((Object)"JBoss cluster detected", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean nodeIsShuttingDown() {
        if (!this.isJBoss()) {
            return false;
        }
        try {
            return (Boolean)this.jbossMBeanServer.getAttribute(this.serverObjectName, "InShutdown");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLastNode() {
        if (!this.clustered) {
            return true;
        }
        try {
            return ((Vector)this.jbossMBeanServer.getAttribute(this.clusteringCacheObjectName, "Members")).size() == 1;
        }
        catch (Exception e) {
            log.warn((Object)"Could not determine number of members in cluster", e, new Object[0]);
            return true;
        }
    }

    public boolean failover() {
        return this.isClustered() && this.nodeIsShuttingDown() && !this.isLastNode();
    }

    public boolean isJBoss() {
        return this.jbossMBeanServer != null;
    }

    protected MBeanServer locateJBoss() {
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.getDefaultDomain().equals("jboss")) continue;
            return server;
        }
        return null;
    }

    public static JBossClusterMonitor getInstance(ServletContext ctx) {
        return (JBossClusterMonitor)ctx.getAttribute(Seam.getComponentName(JBossClusterMonitor.class));
    }
}

