/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private Object entity;
    private int status;
    private Headers<Object> metadata = new Headers();
    private static final SimpleDateFormat dateFormatRFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    public Response build() {
        return new ServerResponse(this.entity, this.status, this.metadata);
    }

    public Response.ResponseBuilder clone() {
        ResponseBuilderImpl impl = new ResponseBuilderImpl();
        impl.metadata.putAll((Map)((Object)this.metadata));
        impl.entity = this.entity;
        impl.status = this.status;
        return impl;
    }

    public Response.ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        this.metadata.putSingle("Content-Type", (Object)type);
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        this.metadata.putSingle("Content-Type", (Object)type);
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant.getMediaType() != null) {
            this.type(variant.getMediaType());
        }
        if (variant.getLanguage() != null) {
            this.language(variant.getLanguage());
        }
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", (Object)variant.getEncoding());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        String vary = ResponseBuilderImpl.createVaryHeader(variants);
        this.metadata.putSingle("Vary", (Object)vary);
        return this;
    }

    public static String createVaryHeader(List<Variant> variants) {
        boolean accept = false;
        boolean acceptLanguage = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        String vary = null;
        if (accept) {
            vary = "Accept";
        }
        if (acceptLanguage) {
            vary = vary == null ? "Accept-Language" : vary + ", Accept-Language";
        }
        if (acceptEncoding) {
            vary = vary == null ? "Accept-Encoding" : vary + ", Accept-Encoding";
        }
        return vary;
    }

    public Response.ResponseBuilder language(String language) {
        this.metadata.putSingle("Content-Language", (Object)language);
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        if (!location.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String path = location.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            URI baseUri = ResteasyProviderFactory.getContextData(HttpRequest.class).getUri().getBaseUri();
            location = baseUri.resolve(path);
        }
        this.metadata.putSingle("Location", (Object)location);
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        if (!location.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String path = location.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            URI baseUri = ResteasyProviderFactory.getContextData(HttpRequest.class).getUri().getBaseUri();
            location = baseUri.resolve(path);
        }
        this.metadata.putSingle("Content-Location", (Object)location);
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        this.metadata.putSingle("ETag", (Object)tag);
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        this.metadata.putSingle("ETag", (Object)tag);
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        this.metadata.putSingle("Last-Modified", (Object)DateUtil.formatDate(lastModified));
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        this.metadata.putSingle("Cache-Control", (Object)cacheControl);
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        this.metadata.add(name, value);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies == null) {
            this.metadata.remove("Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            this.metadata.add("Set-Cookie", (Object)cookie);
        }
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        this.metadata.putSingle("Content-Language", (Object)language);
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        this.metadata.putSingle("Expires", (Object)dateFormatRFC822.format(expires));
        return this;
    }
}

