/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.Value;

abstract class RetainingInjector<T>
implements Injector<T> {
    private volatile Value<T> value;
    private static final AtomicReferenceFieldUpdater<RetainingInjector, Value> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(RetainingInjector.class, Value.class, "value");

    RetainingInjector() {
    }

    @Override
    public void inject(T value) throws InjectionException {
        if (!valueUpdater.compareAndSet(this, null, () -> value)) {
            throw new InjectionException("Value already set for this injector");
        }
    }

    @Override
    public void uninject() {
        if (valueUpdater.getAndSet(this, null) == null) {
            // empty if block
        }
    }

    protected Value<T> getStoredValue() {
        return this.value;
    }

    protected Value<T> setStoredValue(Value<T> value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return valueUpdater.getAndSet(this, value);
    }
}

