/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import org.jboss.metadata.annotation.creator.AbstractProcessor;
import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ejb.jboss.DenyAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.EjbNameThreadLocal;
import org.jboss.metadata.annotation.creator.ejb.jboss.InterceptorsProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossAspectDomainProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossJndiPolicyProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossPoolProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.PermitAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.RolesAllowedProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.RunAsProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.TransactionAttributeClassProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.TransactionAttributeMethodProcessor;
import org.jboss.metadata.annotation.creator.jboss.AbstractComponentProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnvironmentRefsGroupMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnterpriseBeanProcessor<MD extends JBossEnterpriseBeanMetaData>
extends AbstractComponentProcessor<MD>
implements Processor<JBossMetaData, Class<?>> {
    protected abstract MD create(Class<?> var1);

    protected AbstractEnterpriseBeanProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new TransactionAttributeClassProcessor(finder));
        this.addMethodProcessor(new TransactionAttributeMethodProcessor(finder));
        this.addTypeProcessor(new RunAsProcessor(finder));
        this.addTypeProcessor(new DeclareRolesProcessor(finder));
        this.addMethodProcessor(new DenyAllProcessor(finder));
        this.addTypeProcessor(new RolesAllowedProcessor(finder));
        this.addMethodProcessor(new RolesAllowedProcessor(finder));
        this.addTypeProcessor(new PermitAllProcessor(finder));
        this.addMethodProcessor(new PermitAllProcessor(finder));
        this.addTypeProcessor(new InterceptorsProcessor(finder));
        this.addMethodProcessor(new InterceptorsProcessor(finder));
        this.addTypeProcessor(new JBossAspectDomainProcessor(finder));
        this.addTypeProcessor(new JBossJndiPolicyProcessor(finder));
        this.addTypeProcessor(new JBossPoolProcessor(finder));
    }

    @Override
    public void process(JBossMetaData ejbJarMetaData, Class<?> beanClass) {
        MD beanMetaData = this.create(beanClass);
        if (beanMetaData == null) {
            return;
        }
        this.process(ejbJarMetaData, (JBossEnterpriseBeanMetaData)beanMetaData, beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JBossMetaData ejbJarMetaData, JBossEnterpriseBeanMetaData beanMetaData, Class<?> beanClass) {
        EjbNameThreadLocal.ejbName.set(beanMetaData.getEjbName());
        try {
            SecurityRolesMetaData securityRoles;
            JBossEnvironmentRefsGroupMetaData env = (JBossEnvironmentRefsGroupMetaData)beanMetaData.getJndiEnvironmentRefsGroup();
            if (env == null) {
                env = new JBossEnvironmentRefsGroupMetaData();
                beanMetaData.setJndiEnvironmentRefsGroup(env);
            }
            super.process(env, beanClass);
            if (ejbJarMetaData.getEnterpriseBeans() == null) {
                ejbJarMetaData.setEnterpriseBeans(new JBossEnterpriseBeansMetaData());
            }
            ejbJarMetaData.getEnterpriseBeans().add(beanMetaData);
            this.processClass(beanMetaData, beanClass);
            JBossAssemblyDescriptorMetaData assembly = ejbJarMetaData.getAssemblyDescriptor();
            if (assembly == null) {
                assembly = new JBossAssemblyDescriptorMetaData();
                ejbJarMetaData.setAssemblyDescriptor(assembly);
            }
            if ((securityRoles = assembly.getSecurityRoles()) == null) {
                securityRoles = new SecurityRolesMetaData();
                assembly.setSecurityRoles(securityRoles);
            }
            super.processClass(securityRoles, beanClass);
            ExcludeListMetaData excludes = assembly.getExcludeList();
            if (excludes == null) {
                excludes = new ExcludeListMetaData();
                assembly.setExcludeList(excludes);
            }
            super.processClass(excludes, beanClass);
            MethodPermissionsMetaData permissions = assembly.getMethodPermissions();
            if (permissions == null) {
                permissions = new MethodPermissionsMetaData();
                assembly.setMethodPermissions(permissions);
            }
            super.processClass(permissions, beanClass);
            InterceptorBindingsMetaData interceptors = assembly.getInterceptorBindings();
            if (interceptors == null) {
                interceptors = new InterceptorBindingsMetaData();
                assembly.setInterceptorBindings(interceptors);
            }
            super.processClass(interceptors, beanClass);
        }
        finally {
            EjbNameThreadLocal.ejbName.set(null);
        }
    }

    @Override
    public abstract Collection<Class<? extends Annotation>> getAnnotationTypes();

    @Override
    public Collection<Class<? extends Annotation>> getProcessedAnnotations(AbstractProcessor.Scope scope) {
        if (scope == AbstractProcessor.Scope.TYPE) {
            return this.getAnnotationTypes();
        }
        return Collections.EMPTY_SET;
    }
}

