/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JBossAOPCMojo
extends AbstractMojo {
    private boolean verbose;
    private boolean suppress;
    private boolean noopt;
    private boolean report;
    private boolean includeProjectDependency;
    private String classPath;
    private File[] aoppaths;
    private String aopClassPath;
    private String[] includes;
    private Properties properties;
    private boolean test;
    private MavenProject project;
    private List<Artifact> pluginArtifacts;

    public void execute() throws MojoExecutionException {
        this.compileOutOfProcess(this.createCommandLine());
    }

    private String createClassPathList() {
        if (this.getClassPath() != null && this.getClassPath().length() > 0) {
            return this.getClassPath();
        }
        StringBuffer sb = new StringBuffer();
        for (Artifact a : this.pluginArtifacts) {
            sb.append(a.getFile().toString()).append(File.pathSeparator);
        }
        if (this.includeProjectDependency) {
            for (Object o : this.project.getDependencyArtifacts()) {
                if (((Artifact)o).getFile() == null) continue;
                sb.append(((Artifact)o).getFile().toString()).append(File.pathSeparator);
            }
        }
        if (this.isTest()) {
            sb.append(this.project.getBuild().getTestOutputDirectory()).append(File.pathSeparator);
        }
        sb.append(this.project.getBuild().getOutputDirectory());
        return sb.toString();
    }

    private Commandline createCommandLine() {
        String aoppath;
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        cl.addArguments(new String[]{"-cp", this.createClassPathList()});
        if (this.properties != null && !this.properties.isEmpty()) {
            for (String string : this.properties.keySet()) {
                String value = this.properties.getProperty(string);
                if (string.startsWith("-D")) {
                    cl.addArguments(new String[]{string + "=" + value});
                    continue;
                }
                cl.addArguments(new String[]{"-D" + string + "=" + value});
            }
        }
        cl.addArguments(new String[]{"org.jboss.aop.standalone.Compiler"});
        if (this.isVerbose()) {
            cl.addArguments(new String[]{"-verbose"});
        }
        if (this.isSuppress()) {
            cl.addArguments(new String[]{"-suppress"});
        }
        if (this.isNoopt()) {
            cl.addArguments(new String[]{"-noopt"});
        }
        if (this.hasReport()) {
            cl.addArguments(new String[]{"-report"});
        }
        if (this.getAopClassPath() != null && this.getAopClassPath().length() > 0) {
            cl.addArguments(new String[]{"-aopclasspath", this.getAopClassPath()});
        }
        if ((aoppath = this.getAoppath()) != null && aoppath.length() > 0) {
            cl.addArguments(new String[]{"-aoppath", aoppath});
        }
        if (this.includes != null && this.includes.length > 0) {
            for (String include : this.includes) {
                File f = null;
                f = this.isTest() ? new File(this.project.getBuild().getTestOutputDirectory(), include) : new File(this.project.getBuild().getOutputDirectory(), include);
                cl.addArguments(new String[]{f.getAbsolutePath()});
            }
        } else if (this.isTest()) {
            cl.addArguments(new String[]{this.project.getBuild().getTestOutputDirectory()});
        } else {
            cl.addArguments(new String[]{this.project.getBuild().getOutputDirectory()});
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing aopc: " + cl.toString()));
        }
        return cl;
    }

    private void compileOutOfProcess(Commandline cl) {
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            this.processStream(new BufferedReader(new StringReader(err.getOutput())), true);
            this.processStream(new BufferedReader(new StringReader(out.getOutput())), false);
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
    }

    private String getAoppath() {
        StringBuffer sb = new StringBuffer();
        if (this.aoppaths != null) {
            for (File aoppath : this.aoppaths) {
                if (aoppath == null) continue;
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(aoppath.getAbsolutePath());
            }
            return sb.toString();
        }
        return null;
    }

    private void processStream(BufferedReader input, boolean isError) {
        String err = null;
        try {
            while ((err = input.readLine()) != null) {
                if (isError) {
                    this.getLog().error((CharSequence)err);
                    continue;
                }
                this.getLog().info((CharSequence)err);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getClassPath() {
        return this.classPath;
    }

    private boolean isVerbose() {
        return this.verbose;
    }

    private boolean isSuppress() {
        return this.suppress;
    }

    private boolean isNoopt() {
        return this.noopt;
    }

    private boolean hasReport() {
        return this.report;
    }

    private String getAopClassPath() {
        return this.aopClassPath;
    }

    protected boolean isTest() {
        return this.test;
    }

    protected void setTest(boolean test) {
        this.test = test;
    }
}

