/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.maven.plugins.retro.AbstractWeaveMojo;
import org.jboss.maven.plugins.retro.util.JarUtil;

public class WeaveMojo
extends AbstractWeaveMojo {
    protected List pluginArtifacts;
    protected File classesDirectory;
    protected File outputDirectory;
    protected boolean attachJar = false;
    protected List classpathElements;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (!this.getClassesDirecotry().exists() || !this.getClassesDirecotry().isDirectory()) {
            this.getLog().info((CharSequence)"No classes found to weave.");
            return;
        }
        this.getLog().info((CharSequence)("Weaving classes in: " + this.getClassesDirecotry()));
        try {
            this.doWeave(this.buildWeaveClasspath(), this.generateWeaverArgs());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during weave: " + e);
        }
        this.getLog().info((CharSequence)"Weaving complete.");
        if (this.attachJar) {
            String jarFilePath = this.project.getBuild().getDirectory() + File.separator + this.project.getArtifactId() + "-" + this.getJarClassifier() + ".jar";
            try {
                File jarFile = JarUtil.createJarFile(this.getOutputPath(), jarFilePath);
                this.projectHelper.attachArtifact(this.project, jarFile, this.getJarClassifier());
                this.getLog().info((CharSequence)("Weaved jar file created: " + jarFile.getAbsolutePath()));
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Unable to create Jar file: " + ioe));
            }
        }
    }

    protected String[] generateWeaverArgs() {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.verbose) {
            argsList.add("-verbose");
        }
        if (this.suppress) {
            argsList.add("-suppress");
        }
        if (this.useSystemClasspath) {
            argsList.add("-useSystemClasspath");
            argsList.add(Boolean.toString(this.useSystemClasspath));
        }
        argsList.add("-cp");
        argsList.add(this.buildWeaveClasspath());
        if (this.weaverClass != null) {
            argsList.add("-weaverClass");
            argsList.add(this.weaverClass);
        }
        argsList.add("-outputDir");
        argsList.add(this.getOutputPath());
        argsList.add(this.getClassesDirecotry().getAbsolutePath());
        String[] args = new String[argsList.size()];
        return argsList.toArray(args);
    }

    protected String buildWeaveClasspath() {
        StringBuilder classpath = new StringBuilder();
        List cpElements = this.getClasspathElements();
        for (Object element : cpElements) {
            classpath.append(element);
            classpath.append(this.pathSep);
        }
        boolean useRetroDep = true;
        NameFileFilter nameFilter = new NameFileFilter("Weaver.class");
        Collection weaverClassFiles = FileUtils.listFiles((File)this.getClassesDirecotry(), (IOFileFilter)nameFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (weaverClassFiles.size() > 0) {
            useRetroDep = false;
        }
        for (Object artifactObj : this.pluginArtifacts) {
            try {
                Artifact artifact = (Artifact)artifactObj;
                if (artifact.getFile() == null || !useRetroDep && artifact.getArtifactId().equals("jboss-retro")) continue;
                classpath.append(artifact.getFile().getCanonicalPath());
                classpath.append(this.pathSep);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)"Could not get filename");
            }
        }
        return classpath.toString();
    }

    protected String getOutputPath() {
        return this.outputDirectory.getAbsolutePath();
    }

    public File getClassesDirecotry() {
        return this.classesDirectory;
    }

    public List getClasspathElements() {
        return this.classpathElements;
    }
}

