/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.processor.validation.AbstractFormatValidator;
import org.jboss.logging.processor.validation.FormatPart;
import org.jboss.logging.processor.validation.StringFormatPart;
import org.jboss.logging.processor.validation.StringPart;

class StringFormatValidator
extends AbstractFormatValidator {
    public static final String PATTERN = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private final Set<FormatPart> formatParts = new TreeSet<FormatPart>();
    private final Set<StringFormatPart> formats = new TreeSet<StringFormatPart>();
    private int argumentCount;
    private boolean valid;
    private final String format;

    private StringFormatValidator(String format) {
        this.format = format;
        this.valid = true;
    }

    public static StringFormatValidator of(String format) {
        StringFormatValidator result;
        block2: {
            result = new StringFormatValidator(format);
            try {
                result.init();
                result.validate();
            }
            catch (RuntimeException e) {
                if (!result.isValid()) break block2;
                result.valid = false;
                result.setDetailMessage("Format '%s' appears to be invalid. Error: %s", format, e.getMessage());
            }
        }
        return result;
    }

    public static StringFormatValidator of(String format, Object ... parameters) {
        StringFormatValidator result;
        block2: {
            result = new StringFormatValidator(format);
            try {
                result.init();
                result.validate(parameters);
            }
            catch (RuntimeException e) {
                if (!result.isValid()) break block2;
                result.valid = false;
                result.setSummaryMessage("Format '%s' appears to be invalid. Error: %s", format, e.getMessage());
            }
        }
        return result;
    }

    private void validate() {
        if (!this.format.equalsIgnoreCase(this.asFormat())) {
            this.valid = false;
            this.setSummaryMessage("Formats don't match. Internal error: %s Reconstructed: %s", this.format, this.asFormat());
            this.setDetailMessage("The original is '%s' and the reconstructed format is '%s'. This is likely an internal error and should be reported.", this.format, this.asFormat());
        } else {
            TreeMap paramMap = new TreeMap();
            int counter = 0;
            int index = 0;
            block12: for (StringFormatPart stringFormatPart : this.formats) {
                List<Object> params;
                if (counter == this.argumentCount) break;
                if (stringFormatPart.index() > 0 || stringFormatPart.index() == 0) {
                    index = stringFormatPart.index();
                } else if (stringFormatPart.index() < -1) {
                    index = 0;
                }
                if (paramMap.containsKey(index)) {
                    params = (List)paramMap.get(index);
                    if (index > 0) {
                        continue;
                    }
                } else {
                    params = new ArrayList();
                    paramMap.put(index, params);
                }
                ++counter;
                switch (stringFormatPart.conversion()) {
                    case BOOLEAN: {
                        params.add(true);
                        continue block12;
                    }
                    case DATE_TIME: {
                        params.add(new Date());
                        continue block12;
                    }
                    case DECIMAL: 
                    case HEX_FLOATING_POINT: {
                        params.add(Float.valueOf(1.5f));
                        continue block12;
                    }
                    case DECIMAL_INTEGER: 
                    case HEX_INTEGER: 
                    case OCTAL_INTEGER: {
                        params.add(33);
                        continue block12;
                    }
                    case HEX: 
                    case STRING: {
                        params.add("JBoss");
                        continue block12;
                    }
                    case SCIENTIFIC_NOTATION: 
                    case SCIENTIFIC_NOTATION_OR_DECIMAL: {
                        params.add(10000.5505);
                        continue block12;
                    }
                    case UNICODE_CHAR: {
                        params.add(Character.valueOf('c'));
                        continue block12;
                    }
                    case LINE_SEPARATOR: 
                    case PERCENT: {
                        --counter;
                        continue block12;
                    }
                }
                this.valid = false;
                this.setSummaryMessage("Format not found: %s", stringFormatPart);
            }
            if (this.valid) {
                try {
                    ArrayList params = new ArrayList();
                    for (Map.Entry entry : paramMap.entrySet()) {
                        params.addAll((Collection)entry.getValue());
                    }
                    String.format(this.format, params.toArray());
                }
                catch (IllegalFormatException e) {
                    this.valid = false;
                    this.setSummaryMessage("Invalid format for '%s' with parameters '%s'. java.util.Formatter Error: %s", this.format, paramMap, e.getMessage());
                    this.setDetailMessage("Format '%s' with parameters '%s' is invalid. StringFormatValidator: %s", this.format, paramMap, this);
                }
            }
        }
    }

    private void validate(Object ... parameters) {
        int paramCount;
        this.validate();
        int n = paramCount = parameters == null ? 0 : parameters.length;
        if (this.argumentCount != paramCount) {
            this.valid = false;
            this.setSummaryMessage("Parameter lengths do not match. Format (%s) requires %d arguments, supplied %d.", this.format, this.argumentCount, paramCount);
        }
        if (this.valid) {
            try {
                String.format(this.format, parameters);
            }
            catch (IllegalFormatException e) {
                this.valid = false;
                this.setSummaryMessage("Invalid format for '%s' with parameters '%s'. java.util.Formatter Error: %s", this.format, Arrays.asList(parameters), e.getMessage());
                this.setDetailMessage("Format '%s' with parameters '%s' is invalid. StringFormatValidator: %s", this.format, Arrays.asList(parameters), this);
            }
        }
    }

    @Override
    public int argumentCount() {
        return this.argumentCount;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public String asFormat() {
        StringBuilder result = new StringBuilder();
        for (FormatPart formatPart : this.formatParts) {
            result.append(formatPart.part());
        }
        return result.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "formatParts=" + this.formatParts + ", argumentCount=" + this.argumentCount + "]";
    }

    private void init() {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(this.format);
        int position = 0;
        int i = 0;
        while (i < this.format.length()) {
            if (matcher.find(i)) {
                if (matcher.start() != i) {
                    this.formatParts.add(StringPart.of(position++, this.format.substring(i, matcher.start())));
                }
                String[] formatGroup = new String[6];
                for (int groupIndex = 0; groupIndex < matcher.groupCount(); ++groupIndex) {
                    formatGroup[groupIndex] = matcher.group(groupIndex + 1);
                }
                StringFormatPart stringFormatPart = StringFormatPart.of(position++, formatGroup);
                this.formatParts.add(stringFormatPart);
                this.formats.add(stringFormatPart);
                i = matcher.end();
                continue;
            }
            StringFormatValidator.checkText(this.format.substring(i));
            this.formatParts.add(StringPart.of(position, this.format.substring(i)));
            break;
        }
        HashSet<Integer> counted = new HashSet<Integer>();
        for (StringFormatPart stringFormatPart : this.formats) {
            if (stringFormatPart.conversion().isLineSeparator() || stringFormatPart.conversion().isPercent()) continue;
            if (stringFormatPart.index() > 0) {
                if (!counted.add(stringFormatPart.index())) continue;
                ++this.argumentCount;
                continue;
            }
            if (stringFormatPart.index() != 0) continue;
            ++this.argumentCount;
        }
    }

    private static void checkText(String text) {
        int index = text.indexOf(37);
        if (index != -1) {
            char c = index > text.length() - 2 ? (char)'%' : (char)text.charAt(index + 1);
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
    }
}

