/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.intf.model.MessageInterface;
import org.jboss.logging.processor.intf.model.MessageMethod;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Strings;

@SupportedOptions(value={"generatedTranslationFilesPath"})
final class TranslationFileGenerator
extends AbstractGenerator {
    private static final Map<String, Integer> levels = new HashMap<String, Integer>();
    public static final String GENERATED_FILES_PATH_OPTION = "generatedTranslationFilesPath";
    public static final String LEVEL_OPTION = "org.jboss.logging.tools.level";
    public static final String GENERATED_FILE_EXTENSION = ".i18n_locale_COUNTRY_VARIANT.properties";
    public static final String DEFAULT_FILE_EXTENSION = ".i18n.properties";
    private static final String DEFAULT_FILE_COMMENT = "# This file is for reference only, changes have no effect on the generated interface implementations.";
    private final String generatedFilesPath;
    private final LevelComparator comparator;

    public TranslationFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.generatedFilesPath = options.get(GENERATED_FILES_PATH_OPTION);
        String highLevel = options.get(LEVEL_OPTION);
        if (highLevel == null) {
            highLevel = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(TranslationFileGenerator.LEVEL_OPTION);
                }
            });
        }
        if (highLevel != null) {
            if (!levels.containsKey(highLevel)) {
                this.logger().error("Invalid property '%s' defined. The value %s is invalid.", LEVEL_OPTION, highLevel);
            }
            this.comparator = new LevelComparator(highLevel);
        } else {
            this.comparator = null;
        }
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.generatedFilesPath != null && element.getKind().isInterface()) {
            String packageName = this.elementUtils().getPackageOf(element).getQualifiedName().toString();
            String relativePath = packageName.replace('.', File.separatorChar);
            String fileName = ElementHelper.getPrimaryClassNamePrefix(element) + GENERATED_FILE_EXTENSION;
            this.generateSkeletalTranslationFile(relativePath, fileName, messageInterface);
        }
        this.generateDefaultTranslationFile(messageInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void generateSkeletalTranslationFile(String relativePath, String fileName, MessageInterface messageInterface) {
        block16: {
            if (messageInterface == null) {
                throw new NullPointerException("The translations parameter cannot be null");
            }
            File pathFile = new File(this.generatedFilesPath, relativePath);
            pathFile.mkdirs();
            File file = new File(pathFile, fileName);
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file));
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!this.writeMessage(messageMethod) || !processed.add(messageMethod.translationKey())) continue;
                if (messageMethod.isLoggerMethod()) {
                    writer.write(String.format("# Level: %s", messageMethod.logLevel()));
                    writer.newLine();
                }
                writer.write(String.format("# Message: %s", messageMethod.message().value()));
                writer.newLine();
                writer.write(String.format("%s=", messageMethod.translationKey()));
                writer.newLine();
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block16;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot close generated skeletal translation file %s", fileName);
            }
            break block16;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated skeletal translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot close generated skeletal translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot close generated skeletal translation file %s", fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generateDefaultTranslationFile(MessageInterface messageInterface) {
        block15: {
            String fileName = messageInterface.simpleName() + DEFAULT_FILE_EXTENSION;
            BufferedWriter writer = null;
            FileObject fileObject = this.filer().createResource(StandardLocation.CLASS_OUTPUT, messageInterface.packageName(), fileName, new Element[0]);
            writer = new BufferedWriter(new OutputStreamWriter(fileObject.openOutputStream()));
            writer.write(Strings.fill("#", DEFAULT_FILE_COMMENT.length()));
            writer.newLine();
            writer.write("#");
            writer.newLine();
            writer.write(DEFAULT_FILE_COMMENT);
            writer.newLine();
            writer.write("#");
            writer.newLine();
            writer.write(Strings.fill("#", DEFAULT_FILE_COMMENT.length()));
            writer.newLine();
            writer.newLine();
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!this.writeMessage(messageMethod) || !processed.add(messageMethod.translationKey())) continue;
                MessageMethod.Message msg = messageMethod.message();
                writer.write(String.format("# Id: %s", msg.hasId() ? Integer.valueOf(msg.id()) : "none"));
                writer.newLine();
                if (messageMethod.isLoggerMethod()) {
                    writer.write(String.format("# Level: %s", messageMethod.logLevel()));
                    writer.newLine();
                }
                writer.write(String.format("# Message: %s", msg.value()));
                writer.newLine();
                writer.write(String.format("%s=", messageMethod.translationKey()));
                writer.write(messageMethod.message().value());
                writer.newLine();
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block15;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
            }
            break block15;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot write generated default translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot write generated default translation file %s", fileName);
                }
            }
        }
    }

    private boolean writeMessage(MessageMethod method) {
        return this.comparator == null || !method.isLoggerMethod() || this.comparator.compareTo(method.logLevel()) >= 0;
    }

    static {
        levels.put("ALL", Integer.MIN_VALUE);
        levels.put("CONFIG", 700);
        levels.put("DEBUG", 500);
        levels.put("ERROR", 1000);
        levels.put("FATAL", 1100);
        levels.put("FINE", 500);
        levels.put("FINER", 400);
        levels.put("FINEST", 300);
        levels.put("INFO", 800);
        levels.put("OFF", Integer.MAX_VALUE);
        levels.put("SEVERE", 1000);
        levels.put("TRACE", 400);
        levels.put("WARN", 900);
        levels.put("WARNING", 900);
    }

    private static final class LevelComparator
    implements Comparable<String> {
        private final Integer levelIntValue;

        private LevelComparator(String level) {
            this.levelIntValue = (Integer)levels.get(level);
            if (this.levelIntValue == null) {
                throw new IllegalArgumentException(String.format("Level %s is invalid.", level));
            }
        }

        @Override
        public int compareTo(String o) {
            Integer level;
            String cmpLevel = o;
            int lastDot = o.lastIndexOf(".");
            if (lastDot > -1) {
                cmpLevel = o.substring(lastDot + 1);
            }
            if ((level = (Integer)levels.get(cmpLevel)) == null) {
                throw new IllegalArgumentException(String.format("Level %s is invalid.", cmpLevel));
            }
            return level.compareTo(this.levelIntValue);
        }
    }
}

