/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins.graph;

import java.util.Set;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.ScopedController;
import org.jboss.dependency.plugins.graph.HierarchyLookupStrategy;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.metadata.spi.scope.ScopeKey;

public class ScopeKeyLookupStrategy
extends HierarchyLookupStrategy {
    private ScopeKey scopeKey;

    public ScopeKeyLookupStrategy(ScopeKey scopeKey) {
        if (scopeKey == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.scopeKey = scopeKey;
    }

    protected ControllerContext getContextInternal(AbstractController controller, Object name, ControllerState state) {
        AbstractController parent = controller.getParentController();
        while (parent != null) {
            controller = parent;
            parent = controller.getParentController();
        }
        AbstractController match = this.findMatchingScopedController(controller);
        if (match != null) {
            return this.getLocalContext(match, name, state);
        }
        return null;
    }

    private AbstractController findMatchingScopedController(AbstractController current) {
        ScopedController scopedController;
        ScopeKey key;
        boolean related = true;
        if (current instanceof ScopedController && (key = (scopedController = (ScopedController)current).getScopeKey()) != null) {
            if (this.scopeKey.equals((Object)key)) {
                return current;
            }
            related = false;
            ScopeKey ck = this.scopeKey;
            int keySize = key.getScopes().size();
            for (int ckSize = ck.getScopes().size(); ck != null && keySize < ckSize; ck = ck.getParent(), --ckSize) {
                if (!key.isParent(ck)) continue;
                related = true;
                break;
            }
        }
        if (related) {
            Set<AbstractController> children = current.getControllers();
            for (AbstractController child : children) {
                AbstractController found = this.findMatchingScopedController(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

