/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentVisitor<T, C>
implements DeploymentVisitor<T> {
    private static final Logger log = Logger.getLogger(AbstractDeploymentVisitor.class);

    protected void addComponent(DeploymentUnit unit, C componentMD) {
        String name = this.getName(unit, componentMD);
        DeploymentUnit component = unit.addComponent(name);
        component.addAttachment(componentMD.getClass().getName(), componentMD);
    }

    public void deploy(DeploymentUnit unit, T deployment) throws DeploymentException {
        List<C> components = this.getComponents(deployment);
        if (components != null && !components.isEmpty()) {
            ArrayList<C> visited = new ArrayList<C>();
            try {
                for (C component : components) {
                    this.addComponent(unit, component);
                    visited.add(component);
                }
            }
            catch (Throwable t) {
                for (int i = visited.size() - 1; i >= 0; --i) {
                    this.safeRemoveComponent(unit, visited.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
            }
        }
    }

    protected abstract List<C> getComponents(T var1);

    protected abstract String getName(DeploymentUnit var1, C var2);

    protected void removeComponent(DeploymentUnit unit, C component) {
        String name = this.getName(unit, component);
        unit.removeComponent(name);
    }

    protected void safeRemoveComponent(DeploymentUnit unit, C component) {
        try {
            this.removeComponent(unit, component);
        }
        catch (Throwable ignored) {
            log.warn((Object)("Error during component removal: " + unit.getName()), ignored);
        }
    }

    public void undeploy(DeploymentUnit unit, T deployment) {
        List<C> components = this.getComponents(deployment);
        if (components != null && !components.isEmpty()) {
            for (C component : components) {
                this.safeRemoveComponent(unit, component);
            }
        }
    }
}

