package org.xml.sax.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecuritySupport12 extends SecuritySupport
{
  public ClassLoader getContextClassLoader()
  {
    return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
    {
      public Object run()
      {
        ClassLoader localClassLoader = null;
        try
        {
          localClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException localSecurityException)
        {
        }
        return localClassLoader;
      }
    });
  }

  public String getSystemProperty(String paramString)
  {
    return (String)AccessController.doPrivileged(new PrivilegedAction(paramString)
    {
      private final String val$propName;

      public Object run()
      {
        return System.getProperty(this.val$propName);
      }
    });
  }

  public FileInputStream getFileInputStream(File paramFile)
    throws FileNotFoundException
  {
    try
    {
      return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(paramFile)
      {
        private final File val$file;

        public Object run()
          throws FileNotFoundException
        {
          return new FileInputStream(this.val$file);
        }
      });
    }
    catch (PrivilegedActionException localPrivilegedActionException)
    {
    }
    throw ((FileNotFoundException)localPrivilegedActionException.getException());
  }

  public InputStream getResourceAsStream(ClassLoader paramClassLoader, String paramString)
  {
    return (InputStream)AccessController.doPrivileged(new PrivilegedAction(paramClassLoader, paramString)
    {
      private final ClassLoader val$cl;
      private final String val$name;

      public Object run()
      {
        InputStream localInputStream;
        if (this.val$cl == null)
          localInputStream = ClassLoader.getSystemResourceAsStream(this.val$name);
        else
          localInputStream = this.val$cl.getResourceAsStream(this.val$name);
        return localInputStream;
      }
    });
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.xml.sax.helpers.SecuritySupport12
 * JD-Core Version:    0.6.0
 */