/*     */ package org.slf4j.impl;
/*     */ 
/*     */ import org.apache.log4j.Level;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.slf4j.Marker;
/*     */ import org.slf4j.helpers.MarkerIgnoringBase;
/*     */ import org.slf4j.helpers.MessageFormatter;
/*     */ import org.slf4j.spi.LocationAwareLogger;
/*     */ 
/*     */ public final class Log4jLoggerAdapter extends MarkerIgnoringBase
/*     */   implements LocationAwareLogger
/*     */ {
/*     */   final Logger logger;
/*  62 */   static final String FQCN = Log4jLoggerAdapter.class.getName();
/*     */ 
/*     */   Log4jLoggerAdapter(Logger logger)
/*     */   {
/*  67 */     this.logger = logger;
/*     */   }
/*     */ 
/*     */   public String getName() {
/*  71 */     return this.logger.getName();
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/*  81 */     return this.logger.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public void trace(String msg)
/*     */   {
/*  90 */     this.logger.log(FQCN, Level.TRACE, msg, null);
/*     */   }
/*     */ 
/*     */   public void trace(String format, Object arg)
/*     */   {
/* 104 */     if (this.logger.isTraceEnabled()) {
/* 105 */       String msgStr = MessageFormatter.format(format, arg);
/* 106 */       this.logger.log(FQCN, Level.TRACE, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void trace(String format, Object arg1, Object arg2)
/*     */   {
/* 122 */     if (this.logger.isTraceEnabled()) {
/* 123 */       String msgStr = MessageFormatter.format(format, arg1, arg2);
/* 124 */       this.logger.log(FQCN, Level.TRACE, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void trace(String format, Object[] argArray)
/*     */   {
/* 139 */     if (this.logger.isTraceEnabled()) {
/* 140 */       String msgStr = MessageFormatter.arrayFormat(format, argArray);
/* 141 */       this.logger.log(FQCN, Level.TRACE, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void trace(String msg, Throwable t)
/*     */   {
/* 153 */     this.logger.log(FQCN, Level.TRACE, msg, t);
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 164 */     return this.logger.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public void debug(String msg)
/*     */   {
/* 173 */     this.logger.log(FQCN, Level.DEBUG, msg, null);
/*     */   }
/*     */ 
/*     */   public void debug(String format, Object arg)
/*     */   {
/* 187 */     if (this.logger.isDebugEnabled()) {
/* 188 */       String msgStr = MessageFormatter.format(format, arg);
/* 189 */       this.logger.log(FQCN, Level.DEBUG, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(String format, Object arg1, Object arg2)
/*     */   {
/* 205 */     if (this.logger.isDebugEnabled()) {
/* 206 */       String msgStr = MessageFormatter.format(format, arg1, arg2);
/* 207 */       this.logger.log(FQCN, Level.DEBUG, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(String format, Object[] argArray)
/*     */   {
/* 222 */     if (this.logger.isDebugEnabled()) {
/* 223 */       String msgStr = MessageFormatter.arrayFormat(format, argArray);
/* 224 */       this.logger.log(FQCN, Level.DEBUG, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(String msg, Throwable t)
/*     */   {
/* 236 */     this.logger.log(FQCN, Level.DEBUG, msg, t);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 246 */     return this.logger.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public void info(String msg)
/*     */   {
/* 255 */     this.logger.log(FQCN, Level.INFO, msg, null);
/*     */   }
/*     */ 
/*     */   public void info(String format, Object arg)
/*     */   {
/* 269 */     if (this.logger.isInfoEnabled()) {
/* 270 */       String msgStr = MessageFormatter.format(format, arg);
/* 271 */       this.logger.log(FQCN, Level.INFO, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void info(String format, Object arg1, Object arg2)
/*     */   {
/* 287 */     if (this.logger.isInfoEnabled()) {
/* 288 */       String msgStr = MessageFormatter.format(format, arg1, arg2);
/* 289 */       this.logger.log(FQCN, Level.INFO, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void info(String format, Object[] argArray)
/*     */   {
/* 304 */     if (this.logger.isInfoEnabled()) {
/* 305 */       String msgStr = MessageFormatter.arrayFormat(format, argArray);
/* 306 */       this.logger.log(FQCN, Level.INFO, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void info(String msg, Throwable t)
/*     */   {
/* 318 */     this.logger.log(FQCN, Level.INFO, msg, t);
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 328 */     return this.logger.isEnabledFor(Level.WARN);
/*     */   }
/*     */ 
/*     */   public void warn(String msg)
/*     */   {
/* 337 */     this.logger.log(FQCN, Level.WARN, msg, null);
/*     */   }
/*     */ 
/*     */   public void warn(String format, Object arg)
/*     */   {
/* 351 */     if (this.logger.isEnabledFor(Level.WARN)) {
/* 352 */       String msgStr = MessageFormatter.format(format, arg);
/* 353 */       this.logger.log(FQCN, Level.WARN, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void warn(String format, Object arg1, Object arg2)
/*     */   {
/* 369 */     if (this.logger.isEnabledFor(Level.WARN)) {
/* 370 */       String msgStr = MessageFormatter.format(format, arg1, arg2);
/* 371 */       this.logger.log(FQCN, Level.WARN, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void warn(String format, Object[] argArray)
/*     */   {
/* 386 */     if (this.logger.isEnabledFor(Level.WARN)) {
/* 387 */       String msgStr = MessageFormatter.arrayFormat(format, argArray);
/* 388 */       this.logger.log(FQCN, Level.WARN, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void warn(String msg, Throwable t)
/*     */   {
/* 401 */     this.logger.log(FQCN, Level.WARN, msg, t);
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 411 */     return this.logger.isEnabledFor(Level.ERROR);
/*     */   }
/*     */ 
/*     */   public void error(String msg)
/*     */   {
/* 420 */     this.logger.log(FQCN, Level.ERROR, msg, null);
/*     */   }
/*     */ 
/*     */   public void error(String format, Object arg)
/*     */   {
/* 434 */     if (this.logger.isEnabledFor(Level.ERROR)) {
/* 435 */       String msgStr = MessageFormatter.format(format, arg);
/* 436 */       this.logger.log(FQCN, Level.ERROR, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void error(String format, Object arg1, Object arg2)
/*     */   {
/* 452 */     if (this.logger.isEnabledFor(Level.ERROR)) {
/* 453 */       String msgStr = MessageFormatter.format(format, arg1, arg2);
/* 454 */       this.logger.log(FQCN, Level.ERROR, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void error(String format, Object[] argArray)
/*     */   {
/* 469 */     if (this.logger.isEnabledFor(Level.ERROR)) {
/* 470 */       String msgStr = MessageFormatter.arrayFormat(format, argArray);
/* 471 */       this.logger.log(FQCN, Level.ERROR, msgStr, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void error(String msg, Throwable t)
/*     */   {
/* 485 */     this.logger.log(FQCN, Level.ERROR, msg, t);
/*     */   }
/*     */ 
/*     */   public void log(Marker marker, String callerFQCN, int level, String msg, Throwable t)
/*     */   {
/*     */     Level log4jLevel;
/* 490 */     switch (level) {
/*     */     case 0:
/* 492 */       log4jLevel = Level.TRACE;
/* 493 */       break;
/*     */     case 10:
/* 495 */       log4jLevel = Level.DEBUG;
/* 496 */       break;
/*     */     case 20:
/* 498 */       log4jLevel = Level.INFO;
/* 499 */       break;
/*     */     case 30:
/* 501 */       log4jLevel = Level.WARN;
/* 502 */       break;
/*     */     case 40:
/* 504 */       log4jLevel = Level.ERROR;
/* 505 */       break;
/*     */     default:
/* 507 */       throw new IllegalStateException("Level number " + level + " is not recognized.");
/*     */     }
/* 509 */     this.logger.log(callerFQCN, log4jLevel, msg, t);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.slf4j.impl.Log4jLoggerAdapter
 * JD-Core Version:    0.6.0
 */