/*      */ package org.quartz.xml;
/*      */ 
/*      */ import java.beans.PropertyDescriptor;
/*      */ import java.io.File;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.lang.reflect.Field;
/*      */ import java.net.URL;
/*      */ import java.text.DateFormat;
/*      */ import java.text.ParseException;
/*      */ import java.text.SimpleDateFormat;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.TimeZone;
/*      */ import javax.xml.parsers.ParserConfigurationException;
/*      */ import org.apache.commons.beanutils.ConversionException;
/*      */ import org.apache.commons.beanutils.Converter;
/*      */ import org.apache.commons.beanutils.DynaBean;
/*      */ import org.apache.commons.beanutils.DynaClass;
/*      */ import org.apache.commons.beanutils.DynaProperty;
/*      */ import org.apache.commons.beanutils.PropertyUtils;
/*      */ import org.apache.commons.digester.BeanPropertySetterRule;
/*      */ import org.apache.commons.digester.Digester;
/*      */ import org.apache.commons.digester.RuleSetBase;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.apache.commons.logging.LogFactory;
/*      */ import org.quartz.CronTrigger;
/*      */ import org.quartz.JobDataMap;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.JobListener;
/*      */ import org.quartz.Scheduler;
/*      */ import org.quartz.SchedulerException;
/*      */ import org.quartz.SimpleTrigger;
/*      */ import org.quartz.Trigger;
/*      */ import org.xml.sax.InputSource;
/*      */ import org.xml.sax.SAXException;
/*      */ import org.xml.sax.SAXParseException;
/*      */ import org.xml.sax.helpers.DefaultHandler;
/*      */ 
/*      */ public class JobSchedulingDataProcessor extends DefaultHandler
/*      */ {
/*      */   public static final String QUARTZ_PUBLIC_ID = "-//Quartz Enterprise Job Scheduler//DTD Job Scheduling Data 1.5//EN";
/*      */   public static final String QUARTZ_SYSTEM_ID = "http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.dtd";
/*      */   public static final String QUARTZ_DTD = "/org/quartz/xml/job_scheduling_data_1_5.dtd";
/*      */   public static final String QUARTZ_NS = "http://www.opensymphony.com/quartz/JobSchedulingData";
/*      */   public static final String QUARTZ_SCHEMA = "http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.xsd";
/*      */   public static final String QUARTZ_XSD = "/org/quartz/xml/job_scheduling_data_1_5.xsd";
/*      */   public static final String QUARTZ_SYSTEM_ID_DIR_PROP = "quartz.system.id.dir";
/*      */   public static final String QUARTZ_XML_FILE_NAME = "quartz_jobs.xml";
/*      */   public static final String QUARTZ_SYSTEM_ID_PREFIX = "jar:";
/*      */   protected static final String TAG_QUARTZ = "quartz";
/*      */   protected static final String TAG_OVERWRITE_EXISTING_JOBS = "overwrite-existing-jobs";
/*      */   protected static final String TAG_JOB_LISTENER = "job-listener";
/*      */   protected static final String TAG_CALENDAR = "calendar";
/*      */   protected static final String TAG_CLASS_NAME = "class-name";
/*      */   protected static final String TAG_DESCRIPTION = "description";
/*      */   protected static final String TAG_BASE_CALENDAR = "base-calendar";
/*      */   protected static final String TAG_MISFIRE_INSTRUCTION = "misfire-instruction";
/*      */   protected static final String TAG_CALENDAR_NAME = "calendar-name";
/*      */   protected static final String TAG_JOB = "job";
/*      */   protected static final String TAG_JOB_DETAIL = "job-detail";
/*      */   protected static final String TAG_NAME = "name";
/*      */   protected static final String TAG_GROUP = "group";
/*      */   protected static final String TAG_JOB_CLASS = "job-class";
/*      */   protected static final String TAG_JOB_LISTENER_REF = "job-listener-ref";
/*      */   protected static final String TAG_VOLATILITY = "volatility";
/*      */   protected static final String TAG_DURABILITY = "durability";
/*      */   protected static final String TAG_RECOVER = "recover";
/*      */   protected static final String TAG_JOB_DATA_MAP = "job-data-map";
/*      */   protected static final String TAG_ENTRY = "entry";
/*      */   protected static final String TAG_KEY = "key";
/*      */   protected static final String TAG_ALLOWS_TRANSIENT_DATA = "allows-transient-data";
/*      */   protected static final String TAG_VALUE = "value";
/*      */   protected static final String TAG_TRIGGER = "trigger";
/*      */   protected static final String TAG_SIMPLE = "simple";
/*      */   protected static final String TAG_CRON = "cron";
/*      */   protected static final String TAG_JOB_NAME = "job-name";
/*      */   protected static final String TAG_JOB_GROUP = "job-group";
/*      */   protected static final String TAG_START_TIME = "start-time";
/*      */   protected static final String TAG_END_TIME = "end-time";
/*      */   protected static final String TAG_REPEAT_COUNT = "repeat-count";
/*      */   protected static final String TAG_REPEAT_INTERVAL = "repeat-interval";
/*      */   protected static final String TAG_CRON_EXPRESSION = "cron-expression";
/*      */   protected static final String TAG_TIME_ZONE = "time-zone";
/*      */   protected static final String XSD_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
/*      */   protected static final String DTD_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss a";
/*  204 */   protected Map scheduledJobs = new HashMap();
/*      */ 
/*  206 */   protected List jobsToSchedule = new LinkedList();
/*  207 */   protected List calsToSchedule = new LinkedList();
/*  208 */   protected List listenersToSchedule = new LinkedList();
/*      */ 
/*  210 */   protected Collection validationExceptions = new ArrayList();
/*      */   protected Digester digester;
/*  214 */   private boolean overWriteExistingJobs = true;
/*      */ 
/*  216 */   private ThreadLocal schedLocal = new ThreadLocal();
/*      */ 
/*      */   public JobSchedulingDataProcessor()
/*      */   {
/*  230 */     this(true, true, true);
/*      */   }
/*      */ 
/*      */   public JobSchedulingDataProcessor(boolean useContextClassLoader, boolean validating, boolean validatingSchema)
/*      */   {
/*  241 */     initDigester(useContextClassLoader, validating, validatingSchema);
/*      */   }
/*      */ 
/*      */   protected void initDigester(boolean useContextClassLoader, boolean validating, boolean validatingSchema)
/*      */   {
/*  252 */     this.digester = new Digester();
/*  253 */     this.digester.setNamespaceAware(true);
/*  254 */     this.digester.setUseContextClassLoader(useContextClassLoader);
/*  255 */     this.digester.setValidating(validating);
/*  256 */     initSchemaValidation(validatingSchema);
/*  257 */     this.digester.setEntityResolver(this);
/*  258 */     this.digester.setErrorHandler(this);
/*      */ 
/*  260 */     if (addCustomDigesterRules(this.digester))
/*  261 */       addDefaultDigesterRules(this.digester);
/*      */   }
/*      */ 
/*      */   protected void addDefaultDigesterRules(Digester digester)
/*      */   {
/*  268 */     digester.addSetProperties("quartz", "overwrite-existing-jobs", "overWriteExistingJobs");
/*  269 */     digester.addObjectCreate("quartz/job-listener", "jobListener", "class-name");
/*  270 */     digester.addCallMethod("quartz/job-listener", "setName", 1);
/*  271 */     digester.addCallParam("quartz/job-listener", 0, "name");
/*  272 */     digester.addSetNext("quartz/job-listener", "addListenerToSchedule");
/*  273 */     digester.addRuleSet(new CalendarRuleSet("quartz/calendar", "addCalendarToSchedule"));
/*  274 */     digester.addRuleSet(new CalendarRuleSet("*/base-calendar", "setBaseCalendar"));
/*  275 */     digester.addObjectCreate("quartz/job", JobSchedulingBundle.class);
/*  276 */     digester.addObjectCreate("quartz/job/job-detail", JobDetail.class);
/*  277 */     digester.addBeanPropertySetter("quartz/job/job-detail/name", "name");
/*  278 */     digester.addBeanPropertySetter("quartz/job/job-detail/group", "group");
/*  279 */     digester.addBeanPropertySetter("quartz/job/job-detail/description", "description");
/*  280 */     digester.addBeanPropertySetter("quartz/job/job-detail/job-class", "jobClass");
/*  281 */     digester.addCallMethod("quartz/job/job-detail/job-listener-ref", "addJobListener", 0);
/*  282 */     digester.addBeanPropertySetter("quartz/job/job-detail/volatility", "volatility");
/*  283 */     digester.addBeanPropertySetter("quartz/job/job-detail/durability", "durability");
/*  284 */     digester.addBeanPropertySetter("quartz/job/job-detail/recover", "requestsRecovery");
/*  285 */     digester.addObjectCreate("quartz/job/job-detail/job-data-map", JobDataMap.class);
/*  286 */     digester.addSetProperties("quartz/job/job-detail/job-data-map", "allows-transient-data", "allowsTransientData");
/*  287 */     digester.addCallMethod("quartz/job/job-detail/job-data-map/entry", "put", 2, new Class[] { Object.class, Object.class });
/*  288 */     digester.addCallParam("quartz/job/job-detail/job-data-map/entry/key", 0);
/*  289 */     digester.addCallParam("quartz/job/job-detail/job-data-map/entry/value", 1);
/*  290 */     digester.addSetNext("quartz/job/job-detail/job-data-map", "setJobDataMap");
/*  291 */     digester.addSetNext("quartz/job/job-detail", "setJobDetail");
/*  292 */     digester.addRuleSet(new TriggerRuleSet("quartz/job/trigger/simple", SimpleTrigger.class));
/*  293 */     digester.addBeanPropertySetter("quartz/job/trigger/simple/repeat-count", "repeatCount");
/*  294 */     digester.addBeanPropertySetter("quartz/job/trigger/simple/repeat-interval", "repeatInterval");
/*  295 */     digester.addSetNext("quartz/job/trigger/simple", "addTrigger");
/*  296 */     digester.addRuleSet(new TriggerRuleSet("quartz/job/trigger/cron", CronTrigger.class));
/*  297 */     digester.addBeanPropertySetter("quartz/job/trigger/cron/cron-expression", "cronExpression");
/*  298 */     digester.addRule("quartz/job/trigger/cron/time-zone", new SimpleConverterRule("timeZone", new TimeZoneConverter(), TimeZone.class));
/*  299 */     digester.addSetNext("quartz/job/trigger/cron", "addTrigger");
/*  300 */     digester.addSetNext("quartz/job", "addJobToSchedule");
/*      */   }
/*      */ 
/*      */   protected boolean addCustomDigesterRules(Digester digester)
/*      */   {
/*  315 */     return true;
/*      */   }
/*      */ 
/*      */   protected void initSchemaValidation(boolean validatingSchema)
/*      */   {
/*  324 */     if (validatingSchema) {
/*  325 */       String schemaUri = null;
/*  326 */       URL url = getClass().getResource("/org/quartz/xml/job_scheduling_data_1_5.xsd");
/*  327 */       if (url != null) {
/*  328 */         schemaUri = url.toExternalForm();
/*      */       }
/*      */       else {
/*  331 */         schemaUri = "http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.xsd";
/*      */       }
/*  333 */       this.digester.setSchema(schemaUri);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static Log getLog() {
/*  338 */     return LogFactory.getLog(JobSchedulingDataProcessor.class);
/*      */   }
/*      */ 
/*      */   public boolean getUseContextClassLoader()
/*      */   {
/*  347 */     return this.digester.getUseContextClassLoader();
/*      */   }
/*      */ 
/*      */   public void setUseContextClassLoader(boolean useContextClassLoader)
/*      */   {
/*  356 */     this.digester.setUseContextClassLoader(useContextClassLoader);
/*      */   }
/*      */ 
/*      */   public boolean getOverWriteExistingJobs()
/*      */   {
/*  365 */     return this.overWriteExistingJobs;
/*      */   }
/*      */ 
/*      */   public void setOverWriteExistingJobs(boolean overWriteExistingJobs)
/*      */   {
/*  374 */     this.overWriteExistingJobs = overWriteExistingJobs;
/*      */   }
/*      */ 
/*      */   public void processFile()
/*      */     throws Exception
/*      */   {
/*  391 */     processFile("quartz_jobs.xml");
/*      */   }
/*      */ 
/*      */   public void processFile(String fileName)
/*      */     throws Exception
/*      */   {
/*  401 */     processFile(fileName, fileName);
/*      */   }
/*      */ 
/*      */   public void processFile(String fileName, String systemId)
/*      */     throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException
/*      */   {
/*  417 */     clearValidationExceptions();
/*      */ 
/*  419 */     this.scheduledJobs.clear();
/*  420 */     this.jobsToSchedule.clear();
/*  421 */     this.calsToSchedule.clear();
/*      */ 
/*  423 */     getLog().info("Parsing XML file: " + fileName + " with systemId: " + systemId + " validating: " + this.digester.getValidating() + " validating schema: " + this.digester.getSchema());
/*      */ 
/*  427 */     InputSource is = new InputSource(getInputStream(fileName));
/*  428 */     is.setSystemId(systemId);
/*  429 */     this.digester.push(this);
/*  430 */     this.digester.parse(is);
/*      */ 
/*  432 */     maybeThrowValidationException();
/*      */   }
/*      */ 
/*      */   public void processStream(InputStream stream, String systemId)
/*      */     throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException
/*      */   {
/*  448 */     clearValidationExceptions();
/*      */ 
/*  450 */     this.scheduledJobs.clear();
/*  451 */     this.jobsToSchedule.clear();
/*  452 */     this.calsToSchedule.clear();
/*      */ 
/*  454 */     getLog().info("Parsing XML from stream with systemId: " + systemId + " validating: " + this.digester.getValidating() + " validating schema: " + this.digester.getSchema());
/*      */ 
/*  457 */     InputSource is = new InputSource(stream);
/*  458 */     is.setSystemId(systemId);
/*  459 */     this.digester.push(this);
/*  460 */     this.digester.parse(is);
/*      */ 
/*  462 */     maybeThrowValidationException();
/*      */   }
/*      */ 
/*      */   public void processFileAndScheduleJobs(Scheduler sched, boolean overWriteExistingJobs)
/*      */     throws SchedulerException, Exception
/*      */   {
/*  472 */     processFileAndScheduleJobs("quartz_jobs.xml", sched, overWriteExistingJobs);
/*      */   }
/*      */ 
/*      */   public void processFileAndScheduleJobs(String fileName, Scheduler sched, boolean overWriteExistingJobs)
/*      */     throws Exception
/*      */   {
/*  485 */     processFileAndScheduleJobs(fileName, fileName, sched, overWriteExistingJobs);
/*      */   }
/*      */ 
/*      */   public void processFileAndScheduleJobs(String fileName, String systemId, Scheduler sched, boolean overWriteExistingJobs)
/*      */     throws Exception
/*      */   {
/*  497 */     this.schedLocal.set(sched);
/*      */     try {
/*  499 */       processFile(fileName, systemId);
/*  500 */       scheduleJobs(getScheduledJobs(), sched, overWriteExistingJobs);
/*      */     } finally {
/*  502 */       this.schedLocal.set(null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void scheduleJobs(Map jobBundles, Scheduler sched, boolean overWriteExistingJobs)
/*      */     throws Exception
/*      */   {
/*  517 */     getLog().info("Scheduling " + this.jobsToSchedule.size() + " parsed jobs.");
/*      */ 
/*  519 */     Iterator itr = this.calsToSchedule.iterator();
/*  520 */     while (itr.hasNext()) {
/*  521 */       CalendarBundle bndle = (CalendarBundle)itr.next();
/*  522 */       addCalendar(sched, bndle);
/*      */     }
/*      */ 
/*  525 */     itr = this.jobsToSchedule.iterator();
/*  526 */     while (itr.hasNext()) {
/*  527 */       JobSchedulingBundle bndle = (JobSchedulingBundle)itr.next();
/*  528 */       scheduleJob(bndle, sched, overWriteExistingJobs);
/*      */     }
/*      */ 
/*  531 */     itr = this.listenersToSchedule.iterator();
/*  532 */     while (itr.hasNext()) {
/*  533 */       JobListener listener = (JobListener)itr.next();
/*  534 */       getLog().info("adding listener " + listener.getName() + " of class " + listener.getClass().getName());
/*  535 */       sched.addJobListener(listener);
/*      */     }
/*  537 */     getLog().info(jobBundles.size() + " scheduled jobs.");
/*      */   }
/*      */ 
/*      */   public Map getScheduledJobs()
/*      */   {
/*  549 */     return Collections.unmodifiableMap(this.scheduledJobs);
/*      */   }
/*      */ 
/*      */   public JobSchedulingBundle getScheduledJob(String name)
/*      */   {
/*  560 */     return (JobSchedulingBundle)getScheduledJobs().get(name);
/*      */   }
/*      */ 
/*      */   protected InputStream getInputStream(String fileName)
/*      */   {
/*  571 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*      */ 
/*  573 */     InputStream is = cl.getResourceAsStream(fileName);
/*      */ 
/*  575 */     return is;
/*      */   }
/*      */ 
/*      */   public void scheduleJob(JobSchedulingBundle job)
/*      */     throws SchedulerException
/*      */   {
/*  589 */     scheduleJob(job, (Scheduler)this.schedLocal.get(), getOverWriteExistingJobs());
/*      */   }
/*      */ 
/*      */   public void addJobToSchedule(JobSchedulingBundle job)
/*      */   {
/*  595 */     this.jobsToSchedule.add(job);
/*      */   }
/*      */ 
/*      */   public void addCalendarToSchedule(CalendarBundle cal)
/*      */   {
/*  600 */     this.calsToSchedule.add(cal);
/*      */   }
/*      */ 
/*      */   public void addListenerToSchedule(JobListener listener)
/*      */   {
/*  605 */     this.listenersToSchedule.add(listener);
/*      */   }
/*      */ 
/*      */   public void scheduleJob(JobSchedulingBundle job, Scheduler sched, boolean localOverWriteExistingJobs)
/*      */     throws SchedulerException
/*      */   {
/*  623 */     if ((job != null) && (job.isValid())) {
/*  624 */       JobDetail detail = job.getJobDetail();
/*      */ 
/*  626 */       JobDetail dupeJ = sched.getJobDetail(detail.getName(), detail.getGroup());
/*      */ 
/*  628 */       if ((dupeJ != null) && (!localOverWriteExistingJobs)) {
/*  629 */         getLog().info("Not overwriting existing job: " + dupeJ.getFullName());
/*  630 */         return;
/*      */       }
/*      */ 
/*  633 */       if (dupeJ != null) {
/*  634 */         getLog().info("Replacing job: " + detail.getFullName());
/*      */       }
/*      */       else {
/*  637 */         getLog().info("Adding job: " + detail.getFullName());
/*      */       }
/*      */ 
/*  640 */       if ((job.getTriggers().size() == 0) && (!job.getJobDetail().isDurable())) {
/*  641 */         throw new SchedulerException("A Job defined without any triggers must be durable");
/*      */       }
/*  643 */       sched.addJob(detail, true);
/*      */ 
/*  645 */       for (Iterator iter = job.getTriggers().iterator(); iter.hasNext(); ) {
/*  646 */         Trigger trigger = (Trigger)iter.next();
/*      */ 
/*  648 */         Trigger dupeT = sched.getTrigger(trigger.getName(), trigger.getGroup());
/*      */ 
/*  650 */         trigger.setJobName(detail.getName());
/*  651 */         trigger.setJobGroup(detail.getGroup());
/*      */ 
/*  653 */         if (trigger.getStartTime() == null) {
/*  654 */           trigger.setStartTime(new Date());
/*      */         }
/*  656 */         if (dupeT != null) {
/*  657 */           getLog().debug("Rescheduling job: " + detail.getFullName() + " with updated trigger: " + trigger.getFullName());
/*      */ 
/*  659 */           if ((!dupeT.getJobGroup().equals(trigger.getJobGroup())) || (!dupeT.getJobName().equals(trigger.getJobName())))
/*  660 */             getLog().warn("Possibly duplicately named triggers in jobs xml file!");
/*  661 */           sched.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
/*      */         }
/*      */         else {
/*  664 */           getLog().debug("Scheduling job: " + detail.getFullName() + " with trigger: " + trigger.getFullName());
/*      */ 
/*  666 */           sched.scheduleJob(trigger);
/*      */         }
/*      */       }
/*      */ 
/*  670 */       addScheduledJob(job);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void addScheduledJob(JobSchedulingBundle job)
/*      */   {
/*  681 */     this.scheduledJobs.put(job.getFullName(), job);
/*      */   }
/*      */ 
/*      */   public void addCalendar(Scheduler sched, CalendarBundle calendarBundle)
/*      */     throws SchedulerException
/*      */   {
/*  692 */     sched.addCalendar(calendarBundle.getCalendarName(), calendarBundle.getCalendar(), calendarBundle.getReplace(), true);
/*      */   }
/*      */ 
/*      */   public InputSource resolveEntity(String publicId, String systemId)
/*      */   {
/*  739 */     InputSource inputSource = null;
/*      */ 
/*  741 */     InputStream is = null;
/*      */ 
/*  743 */     URL url = null;
/*      */     try
/*      */     {
/*  746 */       if (publicId == null) {
/*  747 */         if (systemId != null)
/*      */         {
/*  749 */           if ("http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.xsd".equals(systemId)) {
/*  750 */             is = getClass().getResourceAsStream("/org/quartz/xml/job_scheduling_data_1_5.dtd");
/*      */           }
/*      */           else {
/*  753 */             is = getInputStream(systemId);
/*      */ 
/*  755 */             if (is == null) {
/*  756 */               int start = systemId.indexOf("jar:");
/*      */ 
/*  758 */               if (start > -1) {
/*  759 */                 String fileName = systemId.substring("jar:".length());
/*      */ 
/*  761 */                 is = getInputStream(fileName);
/*      */               } else {
/*  763 */                 if (systemId.indexOf(':') == -1) {
/*  764 */                   File file = new File(systemId);
/*  765 */                   url = file.toURL();
/*      */                 } else {
/*  767 */                   url = new URL(systemId);
/*      */                 }
/*      */ 
/*  770 */                 is = url.openStream();
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*  777 */       else if ("-//Quartz Enterprise Job Scheduler//DTD Job Scheduling Data 1.5//EN".equals(publicId)) {
/*  778 */         is = getClass().getResourceAsStream("/org/quartz/xml/job_scheduling_data_1_5.dtd");
/*      */       }
/*      */       else {
/*  781 */         url = new URL(systemId);
/*  782 */         is = url.openStream();
/*      */       }
/*      */     }
/*      */     catch (Exception e) {
/*  786 */       e.printStackTrace();
/*      */     } finally {
/*  788 */       if (is != null) {
/*  789 */         inputSource = new InputSource(is);
/*  790 */         inputSource.setPublicId(publicId);
/*  791 */         inputSource.setSystemId(systemId);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  796 */     return inputSource;
/*      */   }
/*      */ 
/*      */   public void warning(SAXParseException e)
/*      */     throws SAXException
/*      */   {
/*  810 */     addValidationException(e);
/*      */   }
/*      */ 
/*      */   public void error(SAXParseException e)
/*      */     throws SAXException
/*      */   {
/*  824 */     addValidationException(e);
/*      */   }
/*      */ 
/*      */   public void fatalError(SAXParseException e)
/*      */     throws SAXException
/*      */   {
/*  838 */     addValidationException(e);
/*      */   }
/*      */ 
/*      */   protected void addValidationException(SAXException e)
/*      */   {
/*  848 */     this.validationExceptions.add(e);
/*      */   }
/*      */ 
/*      */   protected void clearValidationExceptions()
/*      */   {
/*  855 */     this.validationExceptions.clear();
/*      */   }
/*      */ 
/*      */   protected void maybeThrowValidationException()
/*      */     throws ValidationException
/*      */   {
/*  866 */     if (this.validationExceptions.size() > 0)
/*  867 */       throw new ValidationException(this.validationExceptions);
/*      */   }
/*      */ 
/*      */   public final class TimeZoneConverter
/*      */     implements Converter
/*      */   {
/*      */     public TimeZoneConverter()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Object convert(Class type, Object value)
/*      */     {
/* 1255 */       if (value == null) {
/* 1256 */         return null;
/*      */       }
/*      */ 
/* 1259 */       if ((value instanceof TimeZone)) {
/* 1260 */         return value;
/*      */       }
/*      */       try
/*      */       {
/* 1264 */         if (String.class.equals(value.getClass())) {
/* 1265 */           return TimeZone.getTimeZone((String)value);
/*      */         }
/*      */ 
/* 1268 */         return value.toString();
/*      */       }
/*      */       catch (Exception e) {
/*      */       }
/* 1272 */       throw new ConversionException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final class DateConverter
/*      */     implements Converter
/*      */   {
/*      */     private Object defaultValue;
/*      */     private boolean useDefault;
/*      */     private DateFormat[] dateFormats;
/*      */     private final JobSchedulingDataProcessor this$0;
/*      */ 
/*      */     public DateConverter()
/*      */     {
/* 1110 */       this.this$0 = this$0;
/*      */ 
/* 1141 */       this.defaultValue = null;
/*      */ 
/* 1146 */       this.useDefault = true;
/*      */ 
/* 1111 */       this.defaultValue = null;
/* 1112 */       this.useDefault = false;
/*      */     }
/*      */ 
/*      */     public DateConverter(Object defaultValue)
/*      */     {
/* 1121 */       this.this$0 = this$0;
/*      */ 
/* 1141 */       this.defaultValue = null;
/*      */ 
/* 1146 */       this.useDefault = true;
/*      */ 
/* 1122 */       this.defaultValue = defaultValue;
/* 1123 */       this.useDefault = true;
/*      */     }
/*      */ 
/*      */     public DateConverter(String[] formats) {
/* 1127 */       this();
/*      */ 
/* 1129 */       int len = formats.length;
/* 1130 */       this.dateFormats = new DateFormat[len];
/* 1131 */       for (int i = 0; i < len; i++)
/* 1132 */         this.dateFormats[i] = new SimpleDateFormat(formats[i]);
/*      */     }
/*      */ 
/*      */     public Object convert(Class type, Object value)
/*      */     {
/* 1164 */       if (value == null) {
/* 1165 */         if (this.useDefault) {
/* 1166 */           return this.defaultValue;
/*      */         }
/*      */ 
/* 1169 */         return null;
/*      */       }
/*      */ 
/* 1173 */       if (String.class.equals(type)) {
/* 1174 */         if (((value instanceof Date)) && (this.dateFormats != null)) {
/* 1175 */           return this.dateFormats[0].format((Date)value);
/*      */         }
/*      */ 
/* 1178 */         return value.toString();
/*      */       }
/*      */ 
/* 1182 */       if ((value instanceof Date)) {
/* 1183 */         return value;
/*      */       }
/*      */       try
/*      */       {
/* 1187 */         if ((Date.class.isAssignableFrom(type)) && (this.dateFormats != null)) {
/* 1188 */           return parseDate(value);
/*      */         }
/*      */ 
/* 1191 */         return value.toString();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1195 */         if (this.useDefault) {
/* 1196 */           return this.defaultValue;
/*      */         }
/*      */       }
/* 1199 */       throw new ConversionException(e);
/*      */     }
/*      */ 
/*      */     protected Date parseDate(Object value)
/*      */       throws ParseException
/*      */     {
/* 1205 */       Date date = null;
/*      */ 
/* 1207 */       int len = this.dateFormats.length;
/* 1208 */       for (int i = 0; i < len; i++) {
/*      */         try
/*      */         {
/* 1211 */           date = this.dateFormats[i].parse(value.toString());
/*      */         }
/*      */         catch (ParseException e)
/*      */         {
/* 1216 */           if (i == len - 1) {
/* 1217 */             throw e;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1222 */       return date;
/*      */     }
/*      */   }
/*      */ 
/*      */   public class MisfireInstructionRule extends BeanPropertySetterRule
/*      */   {
/*      */     public MisfireInstructionRule(String propertyName)
/*      */     {
/* 1047 */       this.propertyName = propertyName;
/*      */     }
/*      */ 
/*      */     public void body(String namespace, String name, String text)
/*      */       throws Exception
/*      */     {
/* 1062 */       super.body(namespace, name, text);
/* 1063 */       this.bodyText = getConstantValue(this.bodyText);
/*      */     }
/*      */ 
/*      */     private String getConstantValue(String constantName)
/*      */     {
/* 1075 */       String value = "0";
/*      */ 
/* 1077 */       Object top = this.digester.peek();
/* 1078 */       if (top != null) {
/* 1079 */         Class clazz = top.getClass();
/*      */         try {
/* 1081 */           Field field = clazz.getField(constantName);
/* 1082 */           Object fieldValue = field.get(top);
/* 1083 */           if (fieldValue != null) {
/* 1084 */             value = fieldValue.toString();
/*      */           }
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/* 1092 */       return value;
/*      */     }
/*      */   }
/*      */ 
/*      */   public class SimpleConverterRule extends BeanPropertySetterRule
/*      */   {
/*      */     private Converter converter;
/*      */     private Class clazz;
/*      */ 
/*      */     public SimpleConverterRule(String propertyName, Converter converter, Class clazz)
/*      */     {
/*  963 */       this.propertyName = propertyName;
/*  964 */       if (converter == null) {
/*  965 */         throw new IllegalArgumentException("Converter must not be null");
/*      */       }
/*  967 */       this.converter = converter;
/*  968 */       if (clazz == null) {
/*  969 */         throw new IllegalArgumentException("Class must not be null");
/*      */       }
/*  971 */       this.clazz = clazz;
/*      */     }
/*      */ 
/*      */     public void end(String namespace, String name)
/*      */       throws Exception
/*      */     {
/*  988 */       String property = this.propertyName;
/*      */ 
/*  990 */       if (property == null)
/*      */       {
/*  993 */         property = name;
/*      */       }
/*      */ 
/*  997 */       Object top = this.digester.peek();
/*      */ 
/* 1000 */       if (getDigester().getLogger().isDebugEnabled()) {
/* 1001 */         getDigester().getLogger().debug("[BeanPropertySetterRule]{" + getDigester().getMatch() + "} Set " + top.getClass().getName() + " property " + property + " with text " + this.bodyText);
/*      */       }
/*      */ 
/* 1008 */       if ((top instanceof DynaBean)) {
/* 1009 */         DynaProperty desc = ((DynaBean)top).getDynaClass().getDynaProperty(property);
/*      */ 
/* 1011 */         if (desc == null)
/* 1012 */           throw new NoSuchMethodException("Bean has no property named " + property);
/*      */       }
/*      */       else
/*      */       {
/* 1016 */         PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor(top, property);
/*      */ 
/* 1018 */         if (desc == null) {
/* 1019 */           throw new NoSuchMethodException("Bean has no property named " + property);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1025 */       Object value = this.converter.convert(this.clazz, this.bodyText);
/* 1026 */       PropertyUtils.setProperty(top, property, value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public class TriggerRuleSet extends RuleSetBase
/*      */   {
/*      */     protected String prefix;
/*      */     protected Class clazz;
/*      */ 
/*      */     public TriggerRuleSet(String prefix, Class clazz)
/*      */     {
/*  906 */       this.prefix = prefix;
/*  907 */       if (!Trigger.class.isAssignableFrom(clazz)) {
/*  908 */         throw new IllegalArgumentException("Class must be an instance of Trigger");
/*      */       }
/*  910 */       this.clazz = clazz;
/*      */     }
/*      */ 
/*      */     public void addRuleInstances(Digester digester) {
/*  914 */       digester.addObjectCreate(this.prefix, this.clazz);
/*  915 */       digester.addBeanPropertySetter(this.prefix + "/" + "name", "name");
/*  916 */       digester.addBeanPropertySetter(this.prefix + "/" + "group", "group");
/*  917 */       digester.addBeanPropertySetter(this.prefix + "/" + "description", "description");
/*  918 */       digester.addBeanPropertySetter(this.prefix + "/" + "volatility", "volatility");
/*  919 */       digester.addRule(this.prefix + "/" + "misfire-instruction", new JobSchedulingDataProcessor.MisfireInstructionRule(JobSchedulingDataProcessor.this, "misfireInstruction"));
/*  920 */       digester.addBeanPropertySetter(this.prefix + "/" + "calendar-name", "calendarName");
/*  921 */       digester.addBeanPropertySetter(this.prefix + "/" + "job-name", "jobName");
/*  922 */       digester.addBeanPropertySetter(this.prefix + "/" + "job-group", "jobGroup");
/*  923 */       Converter converter = new JobSchedulingDataProcessor.DateConverter(JobSchedulingDataProcessor.this, new String[] { "yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd hh:mm:ss a" });
/*  924 */       digester.addRule(this.prefix + "/" + "start-time", new JobSchedulingDataProcessor.SimpleConverterRule(JobSchedulingDataProcessor.this, "startTime", converter, Date.class));
/*  925 */       digester.addRule(this.prefix + "/" + "end-time", new JobSchedulingDataProcessor.SimpleConverterRule(JobSchedulingDataProcessor.this, "endTime", converter, Date.class));
/*      */     }
/*      */   }
/*      */ 
/*      */   public class CalendarRuleSet extends RuleSetBase
/*      */   {
/*      */     protected String prefix;
/*      */     protected String setNextMethodName;
/*      */ 
/*      */     public CalendarRuleSet(String prefix, String setNextMethodName)
/*      */     {
/*  882 */       this.prefix = prefix;
/*  883 */       this.setNextMethodName = setNextMethodName;
/*      */     }
/*      */ 
/*      */     public void addRuleInstances(Digester digester) {
/*  887 */       digester.addObjectCreate(this.prefix, CalendarBundle.class);
/*  888 */       digester.addSetProperties(this.prefix, "class-name", "className");
/*  889 */       digester.addBeanPropertySetter(this.prefix + "/" + "name", "calendarName");
/*  890 */       digester.addBeanPropertySetter(this.prefix + "/" + "description", "description");
/*  891 */       digester.addSetNext(this.prefix, this.setNextMethodName);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.xml.JobSchedulingDataProcessor
 * JD-Core Version:    0.6.0
 */