/*     */ package org.quartz.xml;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import java.util.TimeZone;
/*     */ import org.quartz.CronTrigger;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.Trigger;
/*     */ 
/*     */ public class JobSchedulingBundle
/*     */ {
/*     */   protected JobDetail jobDetail;
/*  49 */   protected List triggers = new ArrayList();
/*     */ 
/*     */   public JobDetail getJobDetail()
/*     */   {
/*  71 */     return this.jobDetail;
/*     */   }
/*     */ 
/*     */   public void setJobDetail(JobDetail jobDetail) {
/*  75 */     this.jobDetail = jobDetail;
/*     */   }
/*     */ 
/*     */   public List getTriggers() {
/*  79 */     return this.triggers;
/*     */   }
/*     */ 
/*     */   public void setTriggers(List triggers) {
/*  83 */     this.triggers = triggers;
/*     */   }
/*     */ 
/*     */   public void addTrigger(Trigger trigger) {
/*  87 */     if (trigger.getStartTime() == null) {
/*  88 */       trigger.setStartTime(new Date());
/*     */     }
/*     */ 
/*  91 */     if ((trigger instanceof CronTrigger)) {
/*  92 */       CronTrigger ct = (CronTrigger)trigger;
/*  93 */       if (ct.getTimeZone() == null) {
/*  94 */         ct.setTimeZone(TimeZone.getDefault());
/*     */       }
/*     */     }
/*     */ 
/*  98 */     this.triggers.add(trigger);
/*     */   }
/*     */ 
/*     */   public void removeTrigger(Trigger trigger) {
/* 102 */     this.triggers.remove(trigger);
/*     */   }
/*     */ 
/*     */   public String getName() {
/* 106 */     if (getJobDetail() != null) {
/* 107 */       return getJobDetail().getName();
/*     */     }
/* 109 */     return null;
/*     */   }
/*     */ 
/*     */   public String getFullName() {
/* 113 */     if (getJobDetail() != null) {
/* 114 */       return getJobDetail().getFullName();
/*     */     }
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/* 122 */     return (getJobDetail() != null) && (getTriggers() != null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.xml.JobSchedulingBundle
 * JD-Core Version:    0.6.0
 */