/*     */ package org.quartz.utils;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class PropertiesParser
/*     */ {
/*  46 */   Properties props = null;
/*     */ 
/*     */   public PropertiesParser(Properties props)
/*     */   {
/*  57 */     this.props = props;
/*     */   }
/*     */ 
/*     */   public Properties getUnderlyingProperties()
/*     */   {
/*  69 */     return this.props;
/*     */   }
/*     */ 
/*     */   public String getStringProperty(String name) {
/*  73 */     String val = this.props.getProperty(name);
/*  74 */     if (val == null) return null;
/*  75 */     return val.trim();
/*     */   }
/*     */ 
/*     */   public String getStringProperty(String name, String def) {
/*  79 */     String val = this.props.getProperty(name, def);
/*  80 */     if (val == null) return def;
/*  81 */     val = val.trim();
/*  82 */     if (val.length() == 0) return def;
/*  83 */     return val;
/*     */   }
/*     */ 
/*     */   public String[] getStringArrayProperty(String name) {
/*  87 */     return getStringArrayProperty(name, null);
/*     */   }
/*     */ 
/*     */   public String[] getStringArrayProperty(String name, String[] def) {
/*  91 */     String vals = getStringProperty(name);
/*  92 */     if (vals == null) return def;
/*     */ 
/*  94 */     if ((vals != null) && (!vals.trim().equals(""))) {
/*  95 */       StringTokenizer stok = new StringTokenizer(vals, ",");
/*  96 */       Vector strs = new Vector();
/*     */       try {
/*  98 */         while (stok.hasMoreTokens()) {
/*  99 */           strs.addElement(stok.nextToken());
/*     */         }
/* 101 */         String[] outStrs = new String[strs.size()];
/* 102 */         for (int i = 0; i < strs.size(); i++)
/* 103 */           outStrs[i] = ((String)strs.elementAt(i));
/* 104 */         return outStrs;
/*     */       } catch (Exception e) {
/* 106 */         return def;
/*     */       }
/*     */     }
/*     */ 
/* 110 */     return def;
/*     */   }
/*     */ 
/*     */   public boolean getBooleanProperty(String name) {
/* 114 */     String val = getStringProperty(name);
/* 115 */     if (val == null) return false;
/*     */ 
/* 117 */     return new Boolean(val).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean getBooleanProperty(String name, boolean def) {
/* 121 */     String val = getStringProperty(name);
/* 122 */     if (val == null) return def;
/*     */ 
/* 124 */     return new Boolean(val).booleanValue();
/*     */   }
/*     */ 
/*     */   public byte getByteProperty(String name) throws NumberFormatException {
/* 128 */     String val = getStringProperty(name);
/* 129 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 132 */       return Byte.parseByte(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 134 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public byte getByteProperty(String name, byte def)
/*     */     throws NumberFormatException
/*     */   {
/* 140 */     String val = getStringProperty(name);
/* 141 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 144 */       return Byte.parseByte(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 146 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public char getCharProperty(String name)
/*     */   {
/* 151 */     String param = getStringProperty(name);
/* 152 */     if (param == null) return '\000';
/*     */ 
/* 154 */     if (param.length() == 0) return '\000';
/*     */ 
/* 156 */     return param.charAt(0);
/*     */   }
/*     */ 
/*     */   public char getCharProperty(String name, char def) {
/* 160 */     String param = getStringProperty(name);
/* 161 */     if (param == null) return def;
/*     */ 
/* 163 */     if (param.length() == 0) return def;
/*     */ 
/* 165 */     return param.charAt(0);
/*     */   }
/*     */ 
/*     */   public double getDoubleProperty(String name) throws NumberFormatException {
/* 169 */     String val = getStringProperty(name);
/* 170 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 173 */       return Double.parseDouble(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 175 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public double getDoubleProperty(String name, double def)
/*     */     throws NumberFormatException
/*     */   {
/* 181 */     String val = getStringProperty(name);
/* 182 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 185 */       return Double.parseDouble(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 187 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public float getFloatProperty(String name) throws NumberFormatException
/*     */   {
/* 192 */     String val = getStringProperty(name);
/* 193 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 196 */       return Float.parseFloat(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 198 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public float getFloatProperty(String name, float def)
/*     */     throws NumberFormatException
/*     */   {
/* 204 */     String val = getStringProperty(name);
/* 205 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 208 */       return Float.parseFloat(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 210 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public int getIntProperty(String name) throws NumberFormatException
/*     */   {
/* 215 */     String val = getStringProperty(name);
/* 216 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 219 */       return Integer.parseInt(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 221 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public int getIntProperty(String name, int def)
/*     */     throws NumberFormatException
/*     */   {
/* 227 */     String val = getStringProperty(name);
/* 228 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 231 */       return Integer.parseInt(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 233 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public int[] getIntArrayProperty(String name) throws NumberFormatException
/*     */   {
/* 238 */     return getIntArrayProperty(name, null);
/*     */   }
/*     */ 
/*     */   public int[] getIntArrayProperty(String name, int[] def) throws NumberFormatException
/*     */   {
/* 243 */     String vals = getStringProperty(name);
/* 244 */     if (vals == null) return def;
/*     */ 
/* 246 */     if ((vals != null) && (!vals.trim().equals(""))) {
/* 247 */       StringTokenizer stok = new StringTokenizer(vals, ",");
/* 248 */       Vector ints = new Vector();
/*     */       try {
/* 250 */         while (stok.hasMoreTokens()) {
/*     */           try {
/* 252 */             ints.addElement(new Integer(stok.nextToken()));
/*     */           } catch (NumberFormatException nfe) {
/* 254 */             throw new NumberFormatException(" '" + vals + "'");
/*     */           }
/*     */         }
/* 257 */         int[] outInts = new int[ints.size()];
/* 258 */         for (int i = 0; i < ints.size(); i++)
/* 259 */           outInts[i] = ((Integer)ints.elementAt(i)).intValue();
/* 260 */         return outInts;
/*     */       } catch (Exception e) {
/* 262 */         return def;
/*     */       }
/*     */     }
/*     */ 
/* 266 */     return def;
/*     */   }
/*     */ 
/*     */   public long getLongProperty(String name) throws NumberFormatException {
/* 270 */     String val = getStringProperty(name);
/* 271 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 274 */       return Long.parseLong(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 276 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public long getLongProperty(String name, long def)
/*     */     throws NumberFormatException
/*     */   {
/* 282 */     String val = getStringProperty(name);
/* 283 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 286 */       return Long.parseLong(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 288 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public short getShortProperty(String name) throws NumberFormatException
/*     */   {
/* 293 */     String val = getStringProperty(name);
/* 294 */     if (val == null) throw new NumberFormatException(" null string");
/*     */     try
/*     */     {
/* 297 */       return Short.parseShort(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 299 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public short getShortProperty(String name, short def)
/*     */     throws NumberFormatException
/*     */   {
/* 305 */     String val = getStringProperty(name);
/* 306 */     if (val == null) return def;
/*     */     try
/*     */     {
/* 309 */       return Short.parseShort(val); } catch (NumberFormatException nfe) {
/*     */     }
/* 311 */     throw new NumberFormatException(" '" + val + "'");
/*     */   }
/*     */ 
/*     */   public String[] getPropertyGroups(String prefix)
/*     */   {
/* 316 */     Enumeration keys = this.props.propertyNames();
/* 317 */     HashMap groups = new HashMap(10);
/*     */ 
/* 319 */     if (!prefix.endsWith(".")) prefix = prefix + ".";
/*     */ 
/* 321 */     while (keys.hasMoreElements()) {
/* 322 */       String key = (String)keys.nextElement();
/* 323 */       if (key.startsWith(prefix)) {
/* 324 */         String groupName = key.substring(prefix.length(), key.indexOf('.', prefix.length()));
/*     */ 
/* 326 */         groups.put(groupName, groupName);
/*     */       }
/*     */     }
/*     */ 
/* 330 */     return (String[])groups.values().toArray(new String[groups.size()]);
/*     */   }
/*     */ 
/*     */   public Properties getPropertyGroup(String prefix) {
/* 334 */     return getPropertyGroup(prefix, false);
/*     */   }
/*     */ 
/*     */   public Properties getPropertyGroup(String prefix, boolean stripPrefix) {
/* 338 */     Enumeration keys = this.props.propertyNames();
/* 339 */     Properties group = new Properties();
/*     */ 
/* 341 */     if (!prefix.endsWith(".")) prefix = prefix + ".";
/*     */ 
/* 343 */     while (keys.hasMoreElements()) {
/* 344 */       String key = (String)keys.nextElement();
/* 345 */       if (key.startsWith(prefix)) {
/* 346 */         if (stripPrefix) group.put(key.substring(prefix.length()), this.props.getProperty(key));
/*     */         else
/*     */         {
/* 349 */           group.put(key, this.props.getProperty(key));
/*     */         }
/*     */       }
/*     */     }
/* 353 */     return group;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.utils.PropertiesParser
 * JD-Core Version:    0.6.0
 */