/*     */ package org.quartz.utils;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import org.apache.commons.dbcp.BasicDataSource;
/*     */ 
/*     */ public class PoolingConnectionProvider
/*     */   implements ConnectionProvider
/*     */ {
/*     */   public static final String DB_PROPS_PREFIX = "org.quartz.db.";
/*     */   public static final String DB_JNDI_DATASOURCE_URL = "jndiURL";
/*     */   public static final String DB_DRIVER = "driver";
/*     */   public static final String DB_URL = "URL";
/*     */   public static final String DB_USER = "user";
/*     */   public static final String DB_PASSWORD = "password";
/*     */   public static final String DB_MAX_CONNECTIONS = "maxConnections";
/*     */   public static final String DB_VALIDATION_QUERY = "validationQuery";
/*     */   private BasicDataSource datasource;
/*     */ 
/*     */   public PoolingConnectionProvider(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery)
/*     */     throws SQLException
/*     */   {
/*  99 */     initialize(dbDriver, dbURL, dbUser, dbPassword, maxConnections, dbValidationQuery);
/*     */   }
/*     */ 
/*     */   private void initialize(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery)
/*     */     throws SQLException
/*     */   {
/* 115 */     if (dbDriver == null)
/* 116 */       throw new SQLException("DB driver class name cannot be null!");
/* 117 */     if (dbURL == null) throw new SQLException("DB URL cannot be null!");
/* 118 */     if (maxConnections < 0) {
/* 119 */       throw new SQLException("Max connections must be greater than zero!");
/*     */     }
/*     */ 
/* 122 */     this.datasource = new BasicDataSource();
/* 123 */     this.datasource.setDriverClassName(dbDriver);
/* 124 */     this.datasource.setUrl(dbURL);
/* 125 */     this.datasource.setUsername(dbUser);
/* 126 */     this.datasource.setPassword(dbPassword);
/* 127 */     this.datasource.setMaxActive(maxConnections);
/* 128 */     if (dbValidationQuery != null)
/* 129 */       this.datasource.setValidationQuery(dbValidationQuery);
/*     */   }
/*     */ 
/*     */   public PoolingConnectionProvider(Properties config)
/*     */     throws SQLException
/*     */   {
/* 158 */     PropertiesParser cfg = new PropertiesParser(config);
/* 159 */     String url = config.getProperty("URL");
/*     */     try {
/* 161 */       initialize(config.getProperty("driver"), url, config.getProperty("user"), config.getProperty("password"), cfg.getIntProperty("maxConnections", 3), cfg.getStringProperty("validationQuery"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 166 */       throw new SQLException("DBPool '" + url + "' could not be created: " + e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Connection getConnection() throws SQLException
/*     */   {
/* 172 */     return this.datasource.getConnection();
/*     */   }
/*     */ 
/*     */   public void shutdown() throws SQLException {
/* 176 */     this.datasource.close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.utils.PoolingConnectionProvider
 * JD-Core Version:    0.6.0
 */