package org.quartz.spi;

import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;

public abstract interface JobStore
{
  public abstract void initialize(ClassLoadHelper paramClassLoadHelper, SchedulerSignaler paramSchedulerSignaler)
    throws SchedulerConfigException;

  public abstract void schedulerStarted()
    throws SchedulerException;

  public abstract void shutdown();

  public abstract boolean supportsPersistence();

  public abstract void storeJobAndTrigger(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, Trigger paramTrigger)
    throws ObjectAlreadyExistsException, JobPersistenceException;

  public abstract void storeJob(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, boolean paramBoolean)
    throws ObjectAlreadyExistsException, JobPersistenceException;

  public abstract boolean removeJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract JobDetail retrieveJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void storeTrigger(SchedulingContext paramSchedulingContext, Trigger paramTrigger, boolean paramBoolean)
    throws ObjectAlreadyExistsException, JobPersistenceException;

  public abstract boolean removeTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract boolean replaceTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, Trigger paramTrigger)
    throws JobPersistenceException;

  public abstract Trigger retrieveTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void storeCalendar(SchedulingContext paramSchedulingContext, String paramString, Calendar paramCalendar, boolean paramBoolean1, boolean paramBoolean2)
    throws ObjectAlreadyExistsException, JobPersistenceException;

  public abstract boolean removeCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract Calendar retrieveCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract int getNumberOfJobs(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract int getNumberOfTriggers(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract int getNumberOfCalendars(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract String[] getJobNames(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract String[] getTriggerNames(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract String[] getJobGroupNames(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract String[] getTriggerGroupNames(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract String[] getCalendarNames(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract Trigger[] getTriggersForJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract int getTriggerState(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void pauseTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void pauseTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract void pauseJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void pauseJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract void resumeTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void resumeTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract Set getPausedTriggerGroups(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract void resumeJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws JobPersistenceException;

  public abstract void resumeJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws JobPersistenceException;

  public abstract void pauseAll(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract void resumeAll(SchedulingContext paramSchedulingContext)
    throws JobPersistenceException;

  public abstract Trigger acquireNextTrigger(SchedulingContext paramSchedulingContext, long paramLong)
    throws JobPersistenceException;

  public abstract void releaseAcquiredTrigger(SchedulingContext paramSchedulingContext, Trigger paramTrigger)
    throws JobPersistenceException;

  public abstract TriggerFiredBundle triggerFired(SchedulingContext paramSchedulingContext, Trigger paramTrigger)
    throws JobPersistenceException;

  public abstract void triggeredJobComplete(SchedulingContext paramSchedulingContext, Trigger paramTrigger, JobDetail paramJobDetail, int paramInt)
    throws JobPersistenceException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.spi.JobStore
 * JD-Core Version:    0.6.0
 */