/*    */ package org.quartz.simpl;
/*    */ 
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.quartz.Job;
/*    */ import org.quartz.JobDetail;
/*    */ import org.quartz.SchedulerException;
/*    */ import org.quartz.spi.JobFactory;
/*    */ import org.quartz.spi.TriggerFiredBundle;
/*    */ 
/*    */ public class SimpleJobFactory
/*    */   implements JobFactory
/*    */ {
/* 38 */   private Log log = LogFactory.getLog(SimpleJobFactory.class);
/*    */ 
/* 42 */   public Job newJob(TriggerFiredBundle bundle) throws SchedulerException { JobDetail jobDetail = bundle.getJobDetail();
/* 43 */     Class jobClass = jobDetail.getJobClass();
/*    */     SchedulerException se;
/*    */     try { if (this.log.isDebugEnabled()) {
/* 46 */         this.log.debug("Producing instance of Job '" + jobDetail.getFullName() + "', class=" + jobClass.getName());
/*    */       }
/*    */ 
/* 50 */       return (Job)jobClass.newInstance();
/*    */     } catch (Exception e) {
/* 52 */       se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", e);
/*    */     }
/*    */ 
/* 55 */     throw se;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.SimpleJobFactory
 * JD-Core Version:    0.6.0
 */