/*     */ package org.quartz.simpl;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Iterator;
/*     */ import java.util.Locale;
/*     */ import java.util.Set;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.spi.TriggerFiredBundle;
/*     */ 
/*     */ public class PropertySettingJobFactory extends SimpleJobFactory
/*     */ {
/*  51 */   private Log log = LogFactory.getLog(SimpleJobFactory.class);
/*     */ 
/*  53 */   private boolean warnIfNotFound = true;
/*  54 */   private boolean throwIfNotFound = false;
/*     */ 
/*     */   public Job newJob(TriggerFiredBundle bundle) throws SchedulerException
/*     */   {
/*  58 */     Job job = super.newJob(bundle);
/*     */ 
/*  60 */     JobDataMap jobDataMap = new JobDataMap();
/*  61 */     jobDataMap.putAll(bundle.getJobDetail().getJobDataMap());
/*  62 */     jobDataMap.putAll(bundle.getTrigger().getJobDataMap());
/*     */ 
/*  64 */     setBeanProps(job, jobDataMap);
/*     */ 
/*  66 */     return job;
/*     */   }
/*     */ 
/*     */   protected void setBeanProps(Object obj, JobDataMap data) throws SchedulerException
/*     */   {
/*  71 */     BeanInfo bi = null;
/*     */     try {
/*  73 */       bi = Introspector.getBeanInfo(obj.getClass());
/*     */     } catch (IntrospectionException e1) {
/*  75 */       if (isThrowIfPropertyNotFound()) {
/*  76 */         throw new SchedulerException("Unable to introspect Job class.", e1);
/*     */       }
/*  78 */       if (isWarnIfPropertyNotFound()) {
/*  79 */         this.log.warn("Unable to introspect Job class.", e1);
/*     */       }
/*     */     }
/*     */ 
/*  83 */     PropertyDescriptor[] propDescs = bi.getPropertyDescriptors();
/*     */ 
/*  85 */     Iterator keys = data.keySet().iterator();
/*  86 */     while (keys.hasNext()) {
/*  87 */       String name = (String)keys.next();
/*  88 */       String c = name.substring(0, 1).toUpperCase(Locale.US);
/*  89 */       String methName = "set" + c + name.substring(1);
/*     */ 
/*  91 */       Method setMeth = getSetMethod(methName, propDescs);
/*     */ 
/*  93 */       Class paramType = null;
/*  94 */       Object o = null;
/*     */       try
/*     */       {
/*  97 */         if (setMeth == null) {
/*  98 */           if (isThrowIfPropertyNotFound()) {
/*  99 */             throw new SchedulerException("No setter on Job class " + obj.getClass() + " for property '" + name + "'");
/*     */           }
/*     */ 
/* 103 */           if (isWarnIfPropertyNotFound()) {
/* 104 */             this.log.warn("No setter on Job class " + obj.getClass() + " for property '" + name + "'");
/*     */           }
/*     */ 
/* 108 */           continue;
/*     */         }
/*     */ 
/* 111 */         paramType = setMeth.getParameterTypes()[0];
/* 112 */         o = data.get(name);
/*     */ 
/* 114 */         if (paramType.equals(Integer.TYPE)) {
/* 115 */           if ((o instanceof Integer)) {
/* 116 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/* 118 */           else if ((o instanceof String))
/* 119 */             setMeth.invoke(obj, new Object[] { data.getIntegerFromString(name) });
/*     */         }
/* 121 */         else if (paramType.equals(Long.TYPE)) {
/* 122 */           if ((o instanceof Long)) {
/* 123 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/* 125 */           else if ((o instanceof String))
/* 126 */             setMeth.invoke(obj, new Object[] { data.getLongFromString(name) });
/*     */         }
/* 128 */         else if (paramType.equals(Float.TYPE)) {
/* 129 */           if ((o instanceof Float)) {
/* 130 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/* 132 */           else if ((o instanceof String))
/* 133 */             setMeth.invoke(obj, new Object[] { data.getFloatFromString(name) });
/*     */         }
/* 135 */         else if (paramType.equals(Double.TYPE)) {
/* 136 */           if ((o instanceof Double)) {
/* 137 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/* 139 */           else if ((o instanceof String))
/* 140 */             setMeth.invoke(obj, new Object[] { data.getDoubleFromString(name) });
/*     */         }
/* 142 */         else if (paramType.equals(Boolean.TYPE)) {
/* 143 */           if ((o instanceof Boolean)) {
/* 144 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/* 146 */           else if ((o instanceof String))
/* 147 */             setMeth.invoke(obj, new Object[] { data.getBooleanFromString(name) });
/*     */         }
/* 149 */         else if (paramType.equals(String.class)) {
/* 150 */           if ((o instanceof String)) {
/* 151 */             setMeth.invoke(obj, new Object[] { o });
/*     */           }
/*     */         }
/* 154 */         else if (paramType.isAssignableFrom(o.getClass())) {
/* 155 */           setMeth.invoke(obj, new Object[] { o });
/*     */         }
/*     */         else
/*     */         {
/* 159 */           throw new NoSuchMethodException();
/*     */         }
/*     */       } catch (NumberFormatException nfe) {
/* 162 */         if (isThrowIfPropertyNotFound()) {
/* 163 */           throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o, nfe);
/*     */         }
/*     */ 
/* 169 */         if (isWarnIfPropertyNotFound()) {
/* 170 */           this.log.warn("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o, nfe);
/*     */         }
/*     */ 
/* 176 */         continue;
/*     */       } catch (NoSuchMethodException e) {
/* 178 */         if (isThrowIfPropertyNotFound()) {
/* 179 */           throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o.getClass());
/*     */         }
/*     */ 
/* 185 */         if (isWarnIfPropertyNotFound()) {
/* 186 */           this.log.warn("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given a " + o.getClass());
/*     */         }
/*     */ 
/* 192 */         continue;
/*     */       } catch (IllegalArgumentException e) {
/* 194 */         if (isThrowIfPropertyNotFound()) {
/* 195 */           throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o.getClass(), e);
/*     */         }
/*     */ 
/* 201 */         if (isWarnIfPropertyNotFound()) {
/* 202 */           this.log.warn("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given a " + o.getClass(), e);
/*     */         }
/*     */ 
/* 208 */         continue;
/*     */       } catch (IllegalAccessException e) {
/* 210 */         if (isThrowIfPropertyNotFound()) {
/* 211 */           throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' could not be accessed.", e);
/*     */         }
/*     */ 
/* 216 */         if (isWarnIfPropertyNotFound()) {
/* 217 */           this.log.warn("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + "' could not be accessed.", e);
/*     */         }
/*     */ 
/* 223 */         continue;
/*     */       } catch (InvocationTargetException e) {
/* 225 */         if (isThrowIfPropertyNotFound()) {
/* 226 */           throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' could not be accessed.", e);
/*     */         }
/*     */ 
/* 231 */         if (isWarnIfPropertyNotFound()) {
/* 232 */           this.log.warn("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + "' could not be accessed.", e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 238 */       continue;
/*     */     }
/*     */   }
/*     */ 
/*     */   private Method getSetMethod(String name, PropertyDescriptor[] props)
/*     */   {
/* 245 */     for (int i = 0; i < props.length; i++) {
/* 246 */       Method wMeth = props[i].getWriteMethod();
/*     */ 
/* 248 */       if (wMeth == null) {
/*     */         continue;
/*     */       }
/* 251 */       if (wMeth.getParameterTypes().length != 1) {
/*     */         continue;
/*     */       }
/* 254 */       if (wMeth.getName().equals(name)) return wMeth;
/*     */     }
/*     */ 
/* 257 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isThrowIfPropertyNotFound()
/*     */   {
/* 268 */     return this.throwIfNotFound;
/*     */   }
/*     */ 
/*     */   public void setThrowIfPropertyNotFound(boolean throwIfNotFound)
/*     */   {
/* 279 */     this.throwIfNotFound = throwIfNotFound;
/*     */   }
/*     */ 
/*     */   public boolean isWarnIfPropertyNotFound()
/*     */   {
/* 290 */     return this.warnIfNotFound;
/*     */   }
/*     */ 
/*     */   public void setWarnIfPropertyNotFound(boolean warnIfNotFound)
/*     */   {
/* 301 */     this.warnIfNotFound = warnIfNotFound;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.PropertySettingJobFactory
 * JD-Core Version:    0.6.0
 */