/*     */ package org.quartz.simpl;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import org.quartz.spi.ClassLoadHelper;
/*     */ 
/*     */ public class CascadingClassLoadHelper
/*     */   implements ClassLoadHelper
/*     */ {
/*     */   private LinkedList loadHelpers;
/*     */   private ClassLoadHelper bestCandidate;
/*     */ 
/*     */   public void initialize()
/*     */   {
/*  82 */     this.loadHelpers = new LinkedList();
/*     */ 
/*  84 */     this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
/*  85 */     this.loadHelpers.add(new SimpleClassLoadHelper());
/*  86 */     this.loadHelpers.add(new ThreadContextClassLoadHelper());
/*  87 */     this.loadHelpers.add(new InitThreadContextClassLoadHelper());
/*     */ 
/*  89 */     Iterator iter = this.loadHelpers.iterator();
/*  90 */     while (iter.hasNext()) {
/*  91 */       ClassLoadHelper loadHelper = (ClassLoadHelper)iter.next();
/*  92 */       loadHelper.initialize();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class loadClass(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 101 */     if (this.bestCandidate != null) {
/*     */       try {
/* 103 */         return this.bestCandidate.loadClass(name);
/*     */       } catch (Exception e) {
/* 105 */         this.bestCandidate = null;
/*     */       }
/*     */     }
/*     */ 
/* 109 */     ClassNotFoundException cnfe = null;
/* 110 */     Class clazz = null;
/* 111 */     ClassLoadHelper loadHelper = null;
/*     */ 
/* 113 */     Iterator iter = this.loadHelpers.iterator();
/* 114 */     while (iter.hasNext()) {
/* 115 */       loadHelper = (ClassLoadHelper)iter.next();
/*     */       try
/*     */       {
/* 118 */         clazz = loadHelper.loadClass(name);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/* 121 */         cnfe = e;
/*     */       }
/*     */     }
/*     */ 
/* 125 */     if (clazz == null) throw cnfe;
/*     */ 
/* 127 */     this.bestCandidate = loadHelper;
/*     */ 
/* 129 */     return clazz;
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/* 140 */     if (this.bestCandidate != null) {
/*     */       try {
/* 142 */         return this.bestCandidate.getResource(name);
/*     */       } catch (Exception e) {
/* 144 */         this.bestCandidate = null;
/*     */       }
/*     */     }
/*     */ 
/* 148 */     URL result = null;
/* 149 */     ClassLoadHelper loadHelper = null;
/*     */ 
/* 151 */     Iterator iter = this.loadHelpers.iterator();
/* 152 */     while (iter.hasNext()) {
/* 153 */       loadHelper = (ClassLoadHelper)iter.next();
/*     */ 
/* 155 */       result = loadHelper.getResource(name);
/* 156 */       if (result != null) {
/* 157 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 161 */     this.bestCandidate = loadHelper;
/* 162 */     return result;
/*     */   }
/*     */ 
/*     */   public InputStream getResourceAsStream(String name)
/*     */   {
/* 174 */     if (this.bestCandidate != null) {
/*     */       try {
/* 176 */         return this.bestCandidate.getResourceAsStream(name);
/*     */       } catch (Exception e) {
/* 178 */         this.bestCandidate = null;
/*     */       }
/*     */     }
/*     */ 
/* 182 */     InputStream result = null;
/* 183 */     ClassLoadHelper loadHelper = null;
/*     */ 
/* 185 */     Iterator iter = this.loadHelpers.iterator();
/* 186 */     while (iter.hasNext()) {
/* 187 */       loadHelper = (ClassLoadHelper)iter.next();
/*     */ 
/* 189 */       result = loadHelper.getResourceAsStream(name);
/* 190 */       if (result != null) {
/* 191 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 195 */     this.bestCandidate = loadHelper;
/* 196 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.CascadingClassLoadHelper
 * JD-Core Version:    0.6.0
 */