/*     */ package org.quartz.plugins.management;
/*     */ 
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.spi.SchedulerPlugin;
/*     */ 
/*     */ public class ShutdownHookPlugin
/*     */   implements SchedulerPlugin
/*     */ {
/*     */   private String name;
/*     */   private Scheduler scheduler;
/*  51 */   private boolean cleanShutdown = true;
/*     */ 
/*     */   public boolean isCleanShutdown()
/*     */   {
/*  83 */     return this.cleanShutdown;
/*     */   }
/*     */ 
/*     */   public void setCleanShutdown(boolean b)
/*     */   {
/*  97 */     this.cleanShutdown = b;
/*     */   }
/*     */ 
/*     */   protected static Log getLog() {
/* 101 */     return LogFactory.getLog(ShutdownHookPlugin.class);
/*     */   }
/*     */ 
/*     */   public void initialize(String name, Scheduler scheduler)
/*     */     throws SchedulerException
/*     */   {
/* 123 */     this.name = name;
/* 124 */     this.scheduler = scheduler;
/*     */ 
/* 126 */     getLog().info("Registering Quartz shutdown hook.");
/*     */ 
/* 128 */     Thread t = new Thread("Quartz Shutdown-Hook " + scheduler.getSchedulerName(), scheduler) { private final Scheduler val$scheduler;
/*     */ 
/* 131 */       public void run() { ShutdownHookPlugin.getLog().info("Shutting down Quartz...");
/*     */         try {
/* 133 */           this.val$scheduler.shutdown(ShutdownHookPlugin.this.isCleanShutdown());
/*     */         } catch (SchedulerException e) {
/* 135 */           ShutdownHookPlugin.getLog().info("Error shutting down Quartz: " + e.getMessage(), e);
/*     */         }
/*     */       }
/*     */     };
/* 141 */     Runtime.getRuntime().addShutdownHook(t);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.plugins.management.ShutdownHookPlugin
 * JD-Core Version:    0.6.0
 */