/*     */ package org.quartz.plugins.history;
/*     */ 
/*     */ import java.text.MessageFormat;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.TriggerListener;
/*     */ import org.quartz.spi.SchedulerPlugin;
/*     */ 
/*     */ public class LoggingTriggerHistoryPlugin
/*     */   implements SchedulerPlugin, TriggerListener
/*     */ {
/*     */   private String name;
/* 225 */   private String triggerFiredMessage = "Trigger {1}.{0} fired job {6}.{5} at: {4, date, HH:mm:ss MM/dd/yyyy}";
/*     */ 
/* 227 */   private String triggerMisfiredMessage = "Trigger {1}.{0} misfired job {6}.{5}  at: {4, date, HH:mm:ss MM/dd/yyyy}.  Should have fired at: {3, date, HH:mm:ss MM/dd/yyyy}";
/*     */ 
/* 229 */   private String triggerCompleteMessage = "Trigger {1}.{0} completed firing job {6}.{5} at {4, date, HH:mm:ss MM/dd/yyyy} with resulting trigger instruction code: {9}";
/*     */ 
/*     */   protected Log getLog()
/*     */   {
/* 251 */     return LogFactory.getLog(LoggingTriggerHistoryPlugin.class);
/*     */   }
/*     */ 
/*     */   public String getTriggerCompleteMessage()
/*     */   {
/* 261 */     return this.triggerCompleteMessage;
/*     */   }
/*     */ 
/*     */   public String getTriggerFiredMessage()
/*     */   {
/* 270 */     return this.triggerFiredMessage;
/*     */   }
/*     */ 
/*     */   public String getTriggerMisfiredMessage()
/*     */   {
/* 279 */     return this.triggerMisfiredMessage;
/*     */   }
/*     */ 
/*     */   public void setTriggerCompleteMessage(String triggerCompleteMessage)
/*     */   {
/* 290 */     this.triggerCompleteMessage = triggerCompleteMessage;
/*     */   }
/*     */ 
/*     */   public void setTriggerFiredMessage(String triggerFiredMessage)
/*     */   {
/* 300 */     this.triggerFiredMessage = triggerFiredMessage;
/*     */   }
/*     */ 
/*     */   public void setTriggerMisfiredMessage(String triggerMisfiredMessage)
/*     */   {
/* 310 */     this.triggerMisfiredMessage = triggerMisfiredMessage;
/*     */   }
/*     */ 
/*     */   public void initialize(String name, Scheduler scheduler)
/*     */     throws SchedulerException
/*     */   {
/* 332 */     this.name = name;
/*     */ 
/* 334 */     scheduler.addGlobalTriggerListener(this);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 369 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void triggerFired(Trigger trigger, JobExecutionContext context) {
/* 373 */     if (!getLog().isInfoEnabled()) {
/* 374 */       return;
/*     */     }
/*     */ 
/* 377 */     Object[] args = { trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Integer(context.getRefireCount()) };
/*     */ 
/* 383 */     getLog().info(MessageFormat.format(getTriggerFiredMessage(), args));
/*     */   }
/*     */ 
/*     */   public void triggerMisfired(Trigger trigger) {
/* 387 */     if (!getLog().isInfoEnabled()) {
/* 388 */       return;
/*     */     }
/*     */ 
/* 391 */     Object[] args = { trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), trigger.getJobGroup(), trigger.getJobGroup() };
/*     */ 
/* 396 */     getLog().info(MessageFormat.format(getTriggerMisfiredMessage(), args));
/*     */   }
/*     */ 
/*     */   public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode)
/*     */   {
/* 401 */     if (!getLog().isInfoEnabled()) {
/* 402 */       return;
/*     */     }
/*     */ 
/* 405 */     String instrCode = "UNKNOWN";
/* 406 */     if (triggerInstructionCode == 3) instrCode = "DELETE TRIGGER";
/* 407 */     else if (triggerInstructionCode == 0) instrCode = "DO NOTHING";
/* 408 */     else if (triggerInstructionCode == 1) instrCode = "RE-EXECUTE JOB";
/* 409 */     else if (triggerInstructionCode == 4) instrCode = "SET ALL OF JOB'S TRIGGERS COMPLETE";
/* 410 */     else if (triggerInstructionCode == 2) {
/* 411 */       instrCode = "SET THIS TRIGGER COMPLETE";
/*     */     }
/* 413 */     Object[] args = { trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Integer(context.getRefireCount()), new Integer(triggerInstructionCode), instrCode };
/*     */ 
/* 420 */     getLog().info(MessageFormat.format(getTriggerCompleteMessage(), args));
/*     */   }
/*     */ 
/*     */   public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
/* 424 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.plugins.history.LoggingTriggerHistoryPlugin
 * JD-Core Version:    0.6.0
 */