/*     */ package org.quartz.plugins.history;
/*     */ 
/*     */ import java.text.MessageFormat;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ import org.quartz.JobListener;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.spi.SchedulerPlugin;
/*     */ 
/*     */ public class LoggingJobHistoryPlugin
/*     */   implements SchedulerPlugin, JobListener
/*     */ {
/*     */   private String name;
/* 287 */   private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
/*     */ 
/* 289 */   private String jobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
/*     */ 
/* 291 */   private String jobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
/*     */ 
/* 293 */   private String jobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
/*     */ 
/*     */   protected Log getLog()
/*     */   {
/* 315 */     return LogFactory.getLog(LoggingJobHistoryPlugin.class);
/*     */   }
/*     */ 
/*     */   public String getJobSuccessMessage()
/*     */   {
/* 325 */     return this.jobSuccessMessage;
/*     */   }
/*     */ 
/*     */   public String getJobFailedMessage()
/*     */   {
/* 335 */     return this.jobFailedMessage;
/*     */   }
/*     */ 
/*     */   public String getJobToBeFiredMessage()
/*     */   {
/* 344 */     return this.jobToBeFiredMessage;
/*     */   }
/*     */ 
/*     */   public void setJobSuccessMessage(String jobSuccessMessage)
/*     */   {
/* 355 */     this.jobSuccessMessage = jobSuccessMessage;
/*     */   }
/*     */ 
/*     */   public void setJobFailedMessage(String jobFailedMessage)
/*     */   {
/* 366 */     this.jobFailedMessage = jobFailedMessage;
/*     */   }
/*     */ 
/*     */   public void setJobToBeFiredMessage(String jobToBeFiredMessage)
/*     */   {
/* 376 */     this.jobToBeFiredMessage = jobToBeFiredMessage;
/*     */   }
/*     */ 
/*     */   public String getJobWasVetoedMessage()
/*     */   {
/* 386 */     return this.jobWasVetoedMessage;
/*     */   }
/*     */ 
/*     */   public void setJobWasVetoedMessage(String jobWasVetoedMessage)
/*     */   {
/* 397 */     this.jobWasVetoedMessage = jobWasVetoedMessage;
/*     */   }
/*     */ 
/*     */   public void initialize(String name, Scheduler scheduler)
/*     */     throws SchedulerException
/*     */   {
/* 419 */     this.name = name;
/* 420 */     scheduler.addGlobalJobListener(this);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 455 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void jobToBeExecuted(JobExecutionContext context)
/*     */   {
/* 462 */     if (!getLog().isInfoEnabled()) {
/* 463 */       return;
/*     */     }
/*     */ 
/* 466 */     Trigger trigger = context.getTrigger();
/*     */ 
/* 468 */     Object[] args = { context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()) };
/*     */ 
/* 474 */     getLog().info(MessageFormat.format(getJobToBeFiredMessage(), args));
/*     */   }
/*     */ 
/*     */   public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException)
/*     */   {
/* 483 */     Trigger trigger = context.getTrigger();
/*     */ 
/* 485 */     Object[] args = null;
/*     */ 
/* 487 */     if (jobException != null) {
/* 488 */       if (!getLog().isWarnEnabled()) {
/* 489 */         return;
/*     */       }
/*     */ 
/* 492 */       String errMsg = jobException.getMessage();
/* 493 */       args = new Object[] { context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()), errMsg };
/*     */ 
/* 499 */       getLog().warn(MessageFormat.format(getJobFailedMessage(), args), jobException);
/*     */     }
/*     */     else {
/* 502 */       if (!getLog().isInfoEnabled()) {
/* 503 */         return;
/*     */       }
/*     */ 
/* 506 */       String result = String.valueOf(context.getResult());
/* 507 */       args = new Object[] { context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()), result };
/*     */ 
/* 513 */       getLog().info(MessageFormat.format(getJobSuccessMessage(), args));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void jobExecutionVetoed(JobExecutionContext context)
/*     */   {
/* 522 */     if (!getLog().isInfoEnabled()) {
/* 523 */       return;
/*     */     }
/*     */ 
/* 526 */     Trigger trigger = context.getTrigger();
/*     */ 
/* 528 */     Object[] args = { context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()) };
/*     */ 
/* 534 */     getLog().info(MessageFormat.format(getJobWasVetoedMessage(), args));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.plugins.history.LoggingJobHistoryPlugin
 * JD-Core Version:    0.6.0
 */