/*     */ package org.quartz.jobs.ee.mail;
/*     */ 
/*     */ import java.util.Date;
/*     */ import java.util.Properties;
/*     */ import javax.mail.Address;
/*     */ import javax.mail.Message.RecipientType;
/*     */ import javax.mail.MessagingException;
/*     */ import javax.mail.Session;
/*     */ import javax.mail.Transport;
/*     */ import javax.mail.internet.InternetAddress;
/*     */ import javax.mail.internet.MimeMessage;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ 
/*     */ public class SendMailJob
/*     */   implements Job
/*     */ {
/*     */   public static final String PROP_SMTP_HOST = "smtp_host";
/*     */   public static final String PROP_RECIPIENT = "recipient";
/*     */   public static final String PROP_CC_RECIPIENT = "cc_recipient";
/*     */   public static final String PROP_SENDER = "sender";
/*     */   public static final String PROP_REPLY_TO = "reply_to";
/*     */   public static final String PROP_SUBJECT = "subject";
/*     */   public static final String PROP_MESSAGE = "message";
/*     */ 
/*     */   public void execute(JobExecutionContext context)
/*     */     throws JobExecutionException
/*     */   {
/* 108 */     JobDataMap data = context.getJobDetail().getJobDataMap();
/*     */ 
/* 110 */     String smtpHost = data.getString("smtp_host");
/* 111 */     String to = data.getString("recipient");
/* 112 */     String cc = data.getString("cc_recipient");
/* 113 */     String from = data.getString("sender");
/* 114 */     String replyTo = data.getString("reply_to");
/* 115 */     String subject = data.getString("subject");
/* 116 */     String message = data.getString("message");
/*     */ 
/* 118 */     if ((smtpHost == null) || (smtpHost.trim().length() == 0)) {
/* 119 */       throw new IllegalArgumentException("PROP_SMTP_HOST not specified.");
/*     */     }
/* 121 */     if ((to == null) || (to.trim().length() == 0)) {
/* 122 */       throw new IllegalArgumentException("PROP_RECIPIENT not specified.");
/*     */     }
/* 124 */     if ((from == null) || (from.trim().length() == 0))
/* 125 */       throw new IllegalArgumentException("PROP_SENDER not specified.");
/* 126 */     if ((subject == null) || (subject.trim().length() == 0)) {
/* 127 */       throw new IllegalArgumentException("PROP_SUBJECT not specified.");
/*     */     }
/* 129 */     if ((message == null) || (message.trim().length() == 0)) {
/* 130 */       throw new IllegalArgumentException("PROP_MESSAGE not specified.");
/*     */     }
/*     */ 
/* 133 */     if ((cc != null) && (cc.trim().length() == 0)) cc = null;
/*     */ 
/* 135 */     if ((replyTo != null) && (replyTo.trim().length() == 0)) replyTo = null;
/*     */ 
/* 137 */     String mailDesc = "'" + subject + "' to: " + to;
/*     */ 
/* 139 */     getLog().info("Sending message " + mailDesc);
/*     */     try
/*     */     {
/* 142 */       sendMail(smtpHost, to, cc, from, replyTo, subject, message);
/*     */     } catch (MessagingException e) {
/* 144 */       throw new JobExecutionException("Unable to send mail: " + mailDesc, e, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Log getLog()
/*     */   {
/* 151 */     return LogFactory.getLog(SendMailJob.class);
/*     */   }
/*     */ 
/*     */   private void sendMail(String smtpHost, String to, String cc, String from, String replyTo, String subject, String message)
/*     */     throws MessagingException
/*     */   {
/* 157 */     MimeMessage mimeMessage = prepareMimeMessage(smtpHost, to, cc, from, replyTo, subject);
/*     */ 
/* 159 */     mimeMessage.setText(message);
/* 160 */     Transport.send(mimeMessage);
/*     */   }
/*     */ 
/*     */   private MimeMessage prepareMimeMessage(String smtpHost, String to, String cc, String from, String replyTo, String subject)
/*     */     throws MessagingException
/*     */   {
/* 167 */     Properties properties = new Properties();
/* 168 */     properties.put("mail.smtp.host", smtpHost);
/* 169 */     Session session = Session.getDefaultInstance(properties, null);
/*     */ 
/* 171 */     MimeMessage mimeMessage = new MimeMessage(session);
/*     */ 
/* 173 */     Address[] toAddresses = InternetAddress.parse(to);
/* 174 */     mimeMessage.setRecipients(Message.RecipientType.TO, toAddresses);
/*     */ 
/* 176 */     if (cc != null) {
/* 177 */       Address[] ccAddresses = InternetAddress.parse(cc);
/* 178 */       mimeMessage.setRecipients(Message.RecipientType.CC, ccAddresses);
/*     */     }
/*     */ 
/* 181 */     mimeMessage.setFrom(new InternetAddress(from));
/* 182 */     if (replyTo != null) {
/* 183 */       mimeMessage.setReplyTo(new InternetAddress[] { new InternetAddress(replyTo) });
/*     */     }
/*     */ 
/* 186 */     mimeMessage.setSubject(subject);
/* 187 */     mimeMessage.setSentDate(new Date());
/*     */ 
/* 189 */     return mimeMessage;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.jobs.ee.mail.SendMailJob
 * JD-Core Version:    0.6.0
 */