/*     */ package org.quartz.jobs.ee.jmx;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.LinkedList;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ 
/*     */ public class JMXInvokerJob
/*     */   implements Job
/*     */ {
/*     */   public void execute(JobExecutionContext context)
/*     */     throws JobExecutionException
/*     */   {
/*     */     try
/*     */     {
/*  73 */       Object[] params = null;
/*  74 */       String[] types = null;
/*  75 */       String objName = null;
/*  76 */       String objMethod = null;
/*  77 */       String[] keys = context.getJobDetail().getJobDataMap().getKeys();
/*  78 */       for (int i = 0; i < keys.length; i++) {
/*  79 */         String value = context.getJobDetail().getJobDataMap().getString(keys[i]);
/*  80 */         if ("JMX_OBJECTNAME".equalsIgnoreCase(keys[i])) {
/*  81 */           objName = value;
/*  82 */         } else if ("JMX_METHOD".equalsIgnoreCase(keys[i])) {
/*  83 */           objMethod = value;
/*  84 */         } else if ("JMX_PARAMDEFS".equalsIgnoreCase(keys[i])) {
/*  85 */           String[] paramdefs = split(value, ",");
/*  86 */           params = new Object[paramdefs.length];
/*  87 */           types = new String[paramdefs.length];
/*  88 */           for (int k = 0; k < paramdefs.length; k++) {
/*  89 */             String[] parts = split(paramdefs[k], ":");
/*  90 */             if (parts.length < 2)
/*  91 */               throw new Exception("Invalid parameter definition: required parts missing " + paramdefs[k]);
/*  92 */             switch (parts[0].charAt(0)) {
/*     */             case 'i':
/*  94 */               params[k] = new Integer(context.getJobDetail().getJobDataMap().getString(parts[1]));
/*  95 */               types[k] = Integer.TYPE.getName();
/*  96 */               break;
/*     */             case 'I':
/*  98 */               params[k] = new Integer(context.getJobDetail().getJobDataMap().getString(parts[1]));
/*  99 */               types[k] = Integer.class.getName();
/* 100 */               break;
/*     */             case 'l':
/* 102 */               params[k] = new Long(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 103 */               types[k] = Long.TYPE.getName();
/* 104 */               break;
/*     */             case 'L':
/* 106 */               params[k] = new Long(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 107 */               types[k] = Long.class.getName();
/* 108 */               break;
/*     */             case 'f':
/* 110 */               params[k] = new Float(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 111 */               types[k] = Float.TYPE.getName();
/* 112 */               break;
/*     */             case 'F':
/* 114 */               params[k] = new Float(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 115 */               types[k] = Float.class.getName();
/* 116 */               break;
/*     */             case 'd':
/* 118 */               params[k] = new Double(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 119 */               types[k] = Double.TYPE.getName();
/* 120 */               break;
/*     */             case 'D':
/* 122 */               params[k] = new Double(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 123 */               types[k] = Double.class.getName();
/* 124 */               break;
/*     */             case 's':
/* 126 */               params[k] = new String(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 127 */               types[k] = String.class.getName();
/* 128 */               break;
/*     */             case 'b':
/* 130 */               params[k] = new Boolean(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 131 */               types[k] = Boolean.TYPE.getName();
/* 132 */               break;
/*     */             case 'B':
/* 134 */               params[k] = new Boolean(context.getJobDetail().getJobDataMap().getString(parts[1]));
/* 135 */               types[k] = Boolean.class.getName();
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 142 */       if ((objName == null) || (objMethod == null)) {
/* 143 */         throw new Exception("Required parameters missing");
/*     */       }
/* 145 */       invoke(objName, objMethod, params, types);
/*     */     } catch (Exception e) {
/* 147 */       String m = "Caught a " + e.getClass().getName() + " exception : " + e.getMessage();
/* 148 */       getLog().error(m, e);
/* 149 */       throw new JobExecutionException(m, e, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String[] split(String str, String splitStr)
/*     */   {
/* 155 */     LinkedList l = new LinkedList();
/*     */ 
/* 157 */     StringTokenizer strTok = new StringTokenizer(str, splitStr);
/* 158 */     while (strTok.hasMoreTokens()) {
/* 159 */       String tok = strTok.nextToken();
/* 160 */       l.add(tok);
/*     */     }
/*     */ 
/* 163 */     return (String[])l.toArray(new String[l.size()]);
/*     */   }
/*     */ 
/*     */   private void invoke(String objectName, String method, Object[] params, String[] types) throws Exception {
/* 167 */     MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0);
/* 168 */     ObjectName mbean = new ObjectName(objectName);
/*     */ 
/* 170 */     if (server == null) {
/* 171 */       throw new Exception("Can't find mbean server");
/*     */     }
/* 173 */     getLog().info("invoking " + method);
/* 174 */     server.invoke(mbean, method, params, types);
/*     */   }
/*     */ 
/*     */   private static Log getLog() {
/* 178 */     return LogFactory.getLog(JMXInvokerJob.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.jobs.ee.jmx.JMXInvokerJob
 * JD-Core Version:    0.6.0
 */