/*     */ package org.quartz.jobs;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ 
/*     */ public class NativeJob
/*     */   implements Job
/*     */ {
/*     */   public static final String PROP_COMMAND = "command";
/*     */   public static final String PROP_PARAMETERS = "parameters";
/*     */   public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
/*     */   public static final String PROP_CONSUME_STREAMS = "consumeStreams";
/*     */ 
/*     */   public void execute(JobExecutionContext context)
/*     */     throws JobExecutionException
/*     */   {
/* 104 */     JobDataMap data = context.getJobDetail().getJobDataMap();
/*     */ 
/* 106 */     String command = data.getString("command");
/*     */ 
/* 108 */     String parameters = data.getString("parameters");
/*     */ 
/* 110 */     if (parameters == null) {
/* 111 */       parameters = "";
/*     */     }
/*     */ 
/* 114 */     boolean wait = true;
/* 115 */     if (data.containsKey("waitForProcess")) {
/* 116 */       wait = data.getBooleanValue("waitForProcess");
/*     */     }
/* 118 */     boolean consumeStreams = false;
/* 119 */     if (data.containsKey("consumeStreams")) {
/* 120 */       consumeStreams = data.getBooleanValue("consumeStreams");
/*     */     }
/*     */ 
/* 123 */     runNativeCommand(command, parameters, wait, consumeStreams);
/*     */   }
/*     */ 
/*     */   private static Log getLog()
/*     */   {
/* 128 */     return LogFactory.getLog(NativeJob.class);
/*     */   }
/*     */ 
/*     */   private void runNativeCommand(String command, String parameters, boolean wait, boolean consumeStreams) throws JobExecutionException
/*     */   {
/* 133 */     String[] cmd = null;
/* 134 */     String[] args = new String[2];
/* 135 */     args[0] = command;
/* 136 */     args[1] = parameters;
/*     */     try
/*     */     {
/* 140 */       String osName = System.getProperty("os.name");
/*     */ 
/* 143 */       if (osName.equals("Windows NT")) {
/* 144 */         if (cmd == null) cmd = new String[args.length + 2];
/* 145 */         cmd[0] = "cmd.exe";
/* 146 */         cmd[1] = "/C";
/* 147 */         for (int i = 0; i < args.length; i++) {
/* 148 */           cmd[(i + 2)] = args[i];
/*     */         }
/*     */       }
/* 151 */       else if (osName.equals("Windows 95")) {
/* 152 */         if (cmd == null) cmd = new String[args.length + 2];
/* 153 */         cmd[0] = "command.com";
/* 154 */         cmd[1] = "/C";
/* 155 */         for (int i = 0; i < args.length; i++) {
/* 156 */           cmd[(i + 2)] = args[i];
/*     */         }
/*     */       }
/* 159 */       else if (osName.equals("Windows 2003")) {
/* 160 */         if (cmd == null) cmd = new String[args.length + 2];
/* 161 */         cmd[0] = "cmd.exe";
/* 162 */         cmd[1] = "/C";
/*     */ 
/* 164 */         for (int i = 0; i < args.length; i++) {
/* 165 */           cmd[(i + 2)] = args[i];
/*     */         }
/*     */       }
/* 168 */       else if (osName.equals("Windows 2000")) {
/* 169 */         if (cmd == null) cmd = new String[args.length + 2];
/* 170 */         cmd[0] = "cmd.exe";
/* 171 */         cmd[1] = "/C";
/*     */ 
/* 173 */         for (int i = 0; i < args.length; i++) {
/* 174 */           cmd[(i + 2)] = args[i];
/*     */         }
/*     */       }
/* 177 */       else if (osName.equals("Windows XP")) {
/* 178 */         if (cmd == null) cmd = new String[args.length + 2];
/* 179 */         cmd[0] = "cmd.exe";
/* 180 */         cmd[1] = "/C";
/*     */ 
/* 182 */         for (int i = 0; i < args.length; i++) {
/* 183 */           cmd[(i + 2)] = args[i];
/*     */         }
/*     */       }
/* 186 */       else if (osName.equals("Linux")) {
/* 187 */         if (cmd == null) cmd = new String[args.length];
/* 188 */         cmd = args;
/*     */       }
/*     */       else
/*     */       {
/* 192 */         if (cmd == null) cmd = new String[args.length];
/* 193 */         cmd = args;
/*     */       }
/*     */ 
/* 196 */       Runtime rt = Runtime.getRuntime();
/*     */ 
/* 198 */       getLog().info("About to run" + cmd[0] + cmd[1]);
/* 199 */       Process proc = rt.exec(cmd);
/*     */ 
/* 201 */       StreamConsumer stdoutConsumer = new StreamConsumer(proc.getInputStream(), "stdout");
/*     */ 
/* 204 */       if (consumeStreams) {
/* 205 */         StreamConsumer stderrConsumer = new StreamConsumer(proc.getErrorStream(), "stderr");
/* 206 */         stdoutConsumer.start();
/* 207 */         stderrConsumer.start();
/*     */       }
/*     */ 
/* 210 */       if (wait)
/* 211 */         proc.waitFor();
/*     */     }
/*     */     catch (Exception x)
/*     */     {
/* 215 */       throw new JobExecutionException("Error launching native command: ", x, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   class StreamConsumer extends Thread
/*     */   {
/*     */     InputStream is;
/*     */     String type;
/*     */ 
/*     */     public StreamConsumer(InputStream inputStream, String type)
/*     */     {
/* 233 */       this.is = inputStream;
/* 234 */       this.type = type;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 242 */       BufferedReader br = null;
/*     */       try {
/* 244 */         br = new BufferedReader(new InputStreamReader(this.is));
/* 245 */         String line = null;
/*     */ 
/* 247 */         while ((line = br.readLine()) != null) {
/* 248 */           if (this.type.equalsIgnoreCase("stderr")) {
/* 249 */             NativeJob.access$000().warn(this.type + ">" + line); continue;
/*     */           }
/* 251 */           NativeJob.access$000().info(this.type + ">" + line);
/*     */         }
/*     */       } catch (IOException ioe) {
/* 254 */         NativeJob.access$000().error("Error consuming " + this.type + " stream of spawned process.", ioe);
/*     */       }
/*     */       finally {
/* 257 */         if (br != null) try {
/* 258 */             br.close();
/*     */           }
/*     */           catch (Exception ignore)
/*     */           {
/*     */           }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.jobs.NativeJob
 * JD-Core Version:    0.6.0
 */