/*      */ package org.quartz.impl.jdbcjobstore;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.Set;
/*      */ import java.util.TimeZone;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.quartz.Calendar;
/*      */ import org.quartz.CronTrigger;
/*      */ import org.quartz.JobDataMap;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.SimpleTrigger;
/*      */ import org.quartz.Trigger;
/*      */ import org.quartz.spi.ClassLoadHelper;
/*      */ import org.quartz.utils.Key;
/*      */ import org.quartz.utils.TriggerStatus;
/*      */ 
/*      */ public class StdJDBCDelegate
/*      */   implements DriverDelegate, StdJDBCConstants
/*      */ {
/*   79 */   protected Log logger = null;
/*      */ 
/*   81 */   protected String tablePrefix = "QRTZ_";
/*      */   protected String instanceId;
/*      */   protected boolean useProperties;
/*      */ 
/*      */   public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId)
/*      */   {
/*  106 */     this.logger = logger;
/*  107 */     this.tablePrefix = tablePrefix;
/*  108 */     this.instanceId = instanceId;
/*      */   }
/*      */ 
/*      */   public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties)
/*      */   {
/*  123 */     this.logger = logger;
/*  124 */     this.tablePrefix = tablePrefix;
/*  125 */     this.instanceId = instanceId;
/*  126 */     this.useProperties = useProperties.booleanValue();
/*      */   }
/*      */ 
/*      */   protected boolean canUseProperties()
/*      */   {
/*  138 */     return this.useProperties;
/*      */   }
/*      */ 
/*      */   public int updateTriggerStatesFromOtherStates(Connection conn, String newState, String oldState1, String oldState2)
/*      */     throws SQLException
/*      */   {
/*  163 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  166 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_STATE = ? OR TRIGGER_STATE = ?"));
/*      */ 
/*  168 */       ps.setString(1, newState);
/*  169 */       ps.setString(2, oldState1);
/*  170 */       ps.setString(3, oldState2);
/*  171 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  173 */       if (null != ps)
/*      */         try {
/*  175 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key[] selectMisfiredTriggers(Connection conn, long ts)
/*      */     throws SQLException
/*      */   {
/*  194 */     PreparedStatement ps = null;
/*  195 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  198 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? ORDER BY START_TIME ASC"));
/*  199 */       ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
/*  200 */       rs = ps.executeQuery();
/*      */ 
/*  202 */       ArrayList list = new ArrayList();
/*  203 */       while (rs.next()) {
/*  204 */         String triggerName = rs.getString("TRIGGER_NAME");
/*  205 */         String groupName = rs.getString("TRIGGER_GROUP");
/*  206 */         list.add(new Key(triggerName, groupName));
/*      */       }
/*  208 */       Object[] oArr = list.toArray();
/*  209 */       Key[] kArr = new Key[oArr.length];
/*  210 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/*  211 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/*  213 */       if (null != rs)
/*      */         try {
/*  215 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  219 */       if (null != ps)
/*      */         try {
/*  221 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key[] selectTriggersInState(Connection conn, String state)
/*      */     throws SQLException
/*      */   {
/*  241 */     PreparedStatement ps = null;
/*  242 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  245 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ?"));
/*  246 */       ps.setString(1, state);
/*  247 */       rs = ps.executeQuery();
/*      */ 
/*  249 */       ArrayList list = new ArrayList();
/*  250 */       while (rs.next()) {
/*  251 */         list.add(new Key(rs.getString(1), rs.getString(2)));
/*      */       }
/*      */ 
/*  254 */       Key[] sArr = (Key[])list.toArray(new Key[list.size()]);
/*  255 */       arrayOfKey1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/*  257 */       if (null != rs)
/*      */         try {
/*  259 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  263 */       if (null != ps)
/*      */         try {
/*  265 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key[] selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
/*  274 */     PreparedStatement ps = null;
/*  275 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  278 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ?"));
/*  279 */       ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
/*  280 */       ps.setString(2, state);
/*  281 */       rs = ps.executeQuery();
/*      */ 
/*  283 */       ArrayList list = new ArrayList();
/*  284 */       while (rs.next()) {
/*  285 */         String triggerName = rs.getString("TRIGGER_NAME");
/*  286 */         String groupName = rs.getString("TRIGGER_GROUP");
/*  287 */         list.add(new Key(triggerName, groupName));
/*      */       }
/*  289 */       Object[] oArr = list.toArray();
/*  290 */       Key[] kArr = new Key[oArr.length];
/*  291 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/*  292 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/*  294 */       if (null != rs)
/*      */         try {
/*  296 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  300 */       if (null != ps)
/*      */         try {
/*  302 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key[] selectMisfiredTriggersInGroupInState(Connection conn, String groupName, String state, long ts)
/*      */     throws SQLException
/*      */   {
/*  322 */     PreparedStatement ps = null;
/*  323 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  326 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
/*      */ 
/*  328 */       ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
/*  329 */       ps.setString(2, groupName);
/*  330 */       ps.setString(3, state);
/*  331 */       rs = ps.executeQuery();
/*      */ 
/*  333 */       ArrayList list = new ArrayList();
/*  334 */       while (rs.next()) {
/*  335 */         String triggerName = rs.getString("TRIGGER_NAME");
/*  336 */         list.add(new Key(triggerName, groupName));
/*      */       }
/*  338 */       Object[] oArr = list.toArray();
/*  339 */       Key[] kArr = new Key[oArr.length];
/*  340 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/*  341 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/*  343 */       if (null != rs)
/*      */         try {
/*  345 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  349 */       if (null != ps)
/*      */         try {
/*  351 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger[] selectTriggersForRecoveringJobs(Connection conn)
/*      */     throws SQLException, IOException, ClassNotFoundException
/*      */   {
/*  381 */     PreparedStatement ps = null;
/*  382 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  385 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
/*      */ 
/*  387 */       ps.setString(1, this.instanceId);
/*  388 */       ps.setBoolean(2, true);
/*  389 */       rs = ps.executeQuery();
/*      */ 
/*  391 */       long dumId = System.currentTimeMillis();
/*  392 */       ArrayList list = new ArrayList();
/*  393 */       while (rs.next()) {
/*  394 */         String jobName = rs.getString("JOB_NAME");
/*  395 */         String jobGroup = rs.getString("JOB_GROUP");
/*  396 */         trigName = rs.getString("TRIGGER_NAME");
/*  397 */         String trigGroup = rs.getString("TRIGGER_GROUP");
/*  398 */         long firedTime = rs.getLong("FIRED_TIME");
/*  399 */         SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
/*      */ 
/*  402 */         rcvryTrig.setJobName(jobName);
/*  403 */         rcvryTrig.setJobGroup(jobGroup);
/*  404 */         rcvryTrig.setMisfireInstruction(1);
/*      */ 
/*  407 */         JobDataMap jd = selectTriggerJobDataMap(conn, trigName, trigGroup);
/*  408 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", trigName);
/*  409 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", trigGroup);
/*  410 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTime));
/*  411 */         rcvryTrig.setJobDataMap(jd);
/*      */ 
/*  413 */         list.add(rcvryTrig);
/*      */       }
/*  415 */       Object[] oArr = list.toArray();
/*  416 */       Trigger[] tArr = new Trigger[oArr.length];
/*  417 */       System.arraycopy(oArr, 0, tArr, 0, oArr.length);
/*  418 */       trigName = tArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String trigName;
/*  420 */       if (null != rs)
/*      */         try {
/*  422 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  426 */       if (null != ps)
/*      */         try {
/*  428 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteFiredTriggers(Connection conn)
/*      */     throws SQLException
/*      */   {
/*  445 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  448 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS"));
/*      */ 
/*  450 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  452 */       if (null != ps)
/*      */         try {
/*  454 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteFiredTriggers(Connection conn, String instanceId) throws SQLException {
/*  463 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  466 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
/*  467 */       ps.setString(1, instanceId);
/*      */ 
/*  469 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  471 */       if (null != ps)
/*      */         try {
/*  473 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertJobDetail(Connection conn, JobDetail job)
/*      */     throws IOException, SQLException
/*      */   {
/*  499 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*      */ 
/*  501 */     PreparedStatement ps = null;
/*      */ 
/*  503 */     int insertResult = 0;
/*      */     try
/*      */     {
/*  506 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/*  507 */       ps.setString(1, job.getName());
/*  508 */       ps.setString(2, job.getGroup());
/*  509 */       ps.setString(3, job.getDescription());
/*  510 */       ps.setString(4, job.getJobClass().getName());
/*  511 */       ps.setBoolean(5, job.isDurable());
/*  512 */       ps.setBoolean(6, job.isVolatile());
/*  513 */       ps.setBoolean(7, job.isStateful());
/*  514 */       ps.setBoolean(8, job.requestsRecovery());
/*  515 */       ps.setBytes(9, baos.toByteArray());
/*      */ 
/*  517 */       insertResult = ps.executeUpdate();
/*      */     } finally {
/*  519 */       if (null != ps)
/*      */         try {
/*  521 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*  527 */     if (insertResult > 0) {
/*  528 */       String[] jobListeners = job.getJobListenerNames();
/*  529 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/*  530 */         insertJobListener(conn, job, jobListeners[i]);
/*      */       }
/*      */     }
/*  533 */     return insertResult;
/*      */   }
/*      */ 
/*      */   public int updateJobDetail(Connection conn, JobDetail job)
/*      */     throws IOException, SQLException
/*      */   {
/*  551 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*      */ 
/*  553 */     PreparedStatement ps = null;
/*      */ 
/*  555 */     int insertResult = 0;
/*      */     try
/*      */     {
/*  558 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  559 */       ps.setString(1, job.getDescription());
/*  560 */       ps.setString(2, job.getJobClass().getName());
/*  561 */       ps.setBoolean(3, job.isDurable());
/*  562 */       ps.setBoolean(4, job.isVolatile());
/*  563 */       ps.setBoolean(5, job.isStateful());
/*  564 */       ps.setBoolean(6, job.requestsRecovery());
/*  565 */       ps.setBytes(7, baos.toByteArray());
/*  566 */       ps.setString(8, job.getName());
/*  567 */       ps.setString(9, job.getGroup());
/*      */ 
/*  569 */       insertResult = ps.executeUpdate();
/*      */     } finally {
/*  571 */       if (null != ps)
/*      */         try {
/*  573 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*  579 */     if (insertResult > 0) {
/*  580 */       deleteJobListeners(conn, job.getName(), job.getGroup());
/*      */ 
/*  582 */       String[] jobListeners = job.getJobListenerNames();
/*  583 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/*  584 */         insertJobListener(conn, job, jobListeners[i]);
/*      */       }
/*      */     }
/*  587 */     return insertResult;
/*      */   }
/*      */ 
/*      */   public Key[] selectTriggerNamesForJob(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  606 */     PreparedStatement ps = null;
/*  607 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  610 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  611 */       ps.setString(1, jobName);
/*  612 */       ps.setString(2, groupName);
/*  613 */       rs = ps.executeQuery();
/*      */ 
/*  615 */       ArrayList list = new ArrayList(10);
/*  616 */       while (rs.next()) {
/*  617 */         String trigName = rs.getString("TRIGGER_NAME");
/*  618 */         String trigGroup = rs.getString("TRIGGER_GROUP");
/*  619 */         list.add(new Key(trigName, trigGroup));
/*      */       }
/*  621 */       Object[] oArr = list.toArray();
/*  622 */       Key[] kArr = new Key[oArr.length];
/*  623 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/*  624 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/*  626 */       if (null != rs)
/*      */         try {
/*  628 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  632 */       if (null != ps)
/*      */         try {
/*  634 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteJobListeners(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  656 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  659 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  660 */       ps.setString(1, jobName);
/*  661 */       ps.setString(2, groupName);
/*  662 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  664 */       if (null != ps)
/*      */         try {
/*  666 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteJobDetail(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  688 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  691 */       this.logger.debug("Deleting job: " + groupName + "." + jobName);
/*  692 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  693 */       ps.setString(1, jobName);
/*  694 */       ps.setString(2, groupName);
/*  695 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  697 */       if (null != ps)
/*      */         try {
/*  699 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isJobStateful(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  721 */     PreparedStatement ps = null;
/*  722 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  725 */       ps = conn.prepareStatement(rtp("SELECT IS_STATEFUL FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  726 */       ps.setString(1, jobName);
/*  727 */       ps.setString(2, groupName);
/*  728 */       rs = ps.executeQuery();
/*  729 */       if (!rs.next()) { bool = false; jsr 31; }
/*  730 */       bool = rs.getBoolean("IS_STATEFUL");
/*      */     }
/*      */     finally
/*      */     {
/*      */       boolean bool;
/*  732 */       if (null != rs)
/*      */         try {
/*  734 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  738 */       if (null != ps)
/*      */         try {
/*  740 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean jobExists(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  762 */     PreparedStatement ps = null;
/*  763 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  766 */       ps = conn.prepareStatement(rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  767 */       ps.setString(1, jobName);
/*  768 */       ps.setString(2, groupName);
/*  769 */       rs = ps.executeQuery();
/*  770 */       if (rs.next()) {
/*  771 */         i = 1; jsr 23;
/*      */       }
/*  773 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  776 */       if (null != rs)
/*      */         try {
/*  778 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  782 */       if (null != ps)
/*      */         try {
/*  784 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateJobData(Connection conn, JobDetail job)
/*      */     throws IOException, SQLException
/*      */   {
/*  805 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*      */ 
/*  807 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  810 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  811 */       ps.setBytes(1, baos.toByteArray());
/*  812 */       ps.setString(2, job.getName());
/*  813 */       ps.setString(3, job.getGroup());
/*      */ 
/*  815 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  817 */       if (null != ps)
/*      */         try {
/*  819 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertJobListener(Connection conn, JobDetail job, String listener)
/*      */     throws SQLException
/*      */   {
/*  841 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/*  844 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}JOB_LISTENERS (JOB_NAME, JOB_GROUP, JOB_LISTENER) VALUES(?, ?, ?)"));
/*  845 */       ps.setString(1, job.getName());
/*  846 */       ps.setString(2, job.getGroup());
/*  847 */       ps.setString(3, listener);
/*      */ 
/*  849 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/*  851 */       if (null != ps)
/*      */         try {
/*  853 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectJobListeners(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/*  875 */     PreparedStatement ps = null;
/*  876 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  879 */       ArrayList list = new ArrayList();
/*  880 */       ps = conn.prepareStatement(rtp("SELECT JOB_LISTENER FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  881 */       ps.setString(1, jobName);
/*  882 */       ps.setString(2, groupName);
/*  883 */       rs = ps.executeQuery();
/*      */ 
/*  885 */       while (rs.next()) {
/*  886 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/*  889 */       Object[] oArr = list.toArray();
/*  890 */       String[] sArr = new String[oArr.length];
/*  891 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/*  892 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/*  894 */       if (null != rs)
/*      */         try {
/*  896 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  900 */       if (null != ps)
/*      */         try {
/*  902 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JobDetail selectJobDetail(Connection conn, String jobName, String groupName, ClassLoadHelper loadHelper)
/*      */     throws ClassNotFoundException, IOException, SQLException
/*      */   {
/*  930 */     PreparedStatement ps = null;
/*  931 */     ResultSet rs = null;
/*      */     try
/*      */     {
/*  934 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  935 */       ps.setString(1, jobName);
/*  936 */       ps.setString(2, groupName);
/*  937 */       rs = ps.executeQuery();
/*      */ 
/*  939 */       JobDetail job = null;
/*      */ 
/*  941 */       if (rs.next()) {
/*  942 */         job = new JobDetail();
/*      */ 
/*  944 */         job.setName(rs.getString("JOB_NAME"));
/*  945 */         job.setGroup(rs.getString("JOB_GROUP"));
/*  946 */         job.setDescription(rs.getString("DESCRIPTION"));
/*  947 */         job.setJobClass(loadHelper.loadClass(rs.getString("JOB_CLASS_NAME")));
/*      */ 
/*  949 */         job.setDurability(rs.getBoolean("IS_DURABLE"));
/*  950 */         job.setVolatility(rs.getBoolean("IS_VOLATILE"));
/*  951 */         job.setRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
/*      */ 
/*  953 */         map = null;
/*  954 */         if (canUseProperties()) map = getMapFromProperties(rs);
/*      */         else {
/*  956 */           map = (Map)getObjectFromBlob(rs, "JOB_DATA");
/*      */         }
/*  958 */         if (null != map) {
/*  959 */           job.setJobDataMap(new JobDataMap(map));
/*      */         }
/*      */       }
/*      */ 
/*  963 */       map = job;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Map map;
/*  965 */       if (null != rs)
/*      */         try {
/*  967 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*  971 */       if (null != ps)
/*      */         try {
/*  973 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Map getMapFromProperties(ResultSet rs)
/*      */     throws ClassNotFoundException, IOException, SQLException
/*      */   {
/*  986 */     InputStream is = (InputStream)getJobDetailFromBlob(rs, "JOB_DATA");
/*  987 */     if (is == null)
/*  988 */       return null;
/*  989 */     Properties properties = new Properties();
/*  990 */     if (is != null) properties.load(is);
/*  991 */     Map map = convertFromProperty(properties);
/*  992 */     return map;
/*      */   }
/*      */ 
/*      */   public int selectNumJobs(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 1005 */     PreparedStatement ps = null;
/* 1006 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1009 */       int count = 0;
/* 1010 */       ps = conn.prepareStatement(rtp("SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS"));
/* 1011 */       rs = ps.executeQuery();
/*      */ 
/* 1013 */       if (rs.next()) {
/* 1014 */         count = rs.getInt(1);
/*      */       }
/*      */ 
/* 1017 */       i = count;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1019 */       if (null != rs)
/*      */         try {
/* 1021 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1025 */       if (null != ps)
/*      */         try {
/* 1027 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectJobGroups(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 1044 */     PreparedStatement ps = null;
/* 1045 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1048 */       ps = conn.prepareStatement(rtp("SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS"));
/* 1049 */       rs = ps.executeQuery();
/*      */ 
/* 1051 */       ArrayList list = new ArrayList();
/* 1052 */       while (rs.next()) {
/* 1053 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/* 1056 */       Object[] oArr = list.toArray();
/* 1057 */       String[] sArr = new String[oArr.length];
/* 1058 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 1059 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 1061 */       if (null != rs)
/*      */         try {
/* 1063 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1067 */       if (null != ps)
/*      */         try {
/* 1069 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectJobsInGroup(Connection conn, String groupName)
/*      */     throws SQLException
/*      */   {
/* 1089 */     PreparedStatement ps = null;
/* 1090 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1093 */       ps = conn.prepareStatement(rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_GROUP = ?"));
/* 1094 */       ps.setString(1, groupName);
/* 1095 */       rs = ps.executeQuery();
/*      */ 
/* 1097 */       ArrayList list = new ArrayList();
/* 1098 */       while (rs.next()) {
/* 1099 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/* 1102 */       Object[] oArr = list.toArray();
/* 1103 */       String[] sArr = new String[oArr.length];
/* 1104 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 1105 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 1107 */       if (null != rs)
/*      */         try {
/* 1109 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1113 */       if (null != ps)
/*      */         try {
/* 1115 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail)
/*      */     throws SQLException, IOException
/*      */   {
/* 1142 */     ByteArrayOutputStream baos = null;
/* 1143 */     if (trigger.getJobDataMap().size() > 0) {
/* 1144 */       baos = serializeJobData(trigger.getJobDataMap());
/*      */     }
/* 1146 */     PreparedStatement ps = null;
/*      */ 
/* 1148 */     int insertResult = 0;
/*      */     try
/*      */     {
/* 1151 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 1152 */       ps.setString(1, trigger.getName());
/* 1153 */       ps.setString(2, trigger.getGroup());
/* 1154 */       ps.setString(3, trigger.getJobName());
/* 1155 */       ps.setString(4, trigger.getJobGroup());
/* 1156 */       ps.setBoolean(5, trigger.isVolatile());
/* 1157 */       ps.setString(6, trigger.getDescription());
/* 1158 */       ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*      */ 
/* 1160 */       long prevFireTime = -1L;
/* 1161 */       if (trigger.getPreviousFireTime() != null) {
/* 1162 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*      */       }
/* 1164 */       ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
/* 1165 */       ps.setString(9, state);
/* 1166 */       if ((trigger instanceof SimpleTrigger))
/* 1167 */         ps.setString(10, "SIMPLE");
/* 1168 */       else if ((trigger instanceof CronTrigger))
/* 1169 */         ps.setString(10, "CRON");
/*      */       else {
/* 1171 */         ps.setString(10, "BLOB");
/*      */       }
/* 1173 */       ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*      */ 
/* 1175 */       long endTime = 0L;
/* 1176 */       if (trigger.getEndTime() != null) {
/* 1177 */         endTime = trigger.getEndTime().getTime();
/*      */       }
/* 1179 */       ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
/* 1180 */       ps.setString(13, trigger.getCalendarName());
/* 1181 */       ps.setInt(14, trigger.getMisfireInstruction());
/* 1182 */       if (baos != null)
/* 1183 */         ps.setBytes(15, baos.toByteArray());
/*      */       else {
/* 1185 */         ps.setBytes(15, null);
/*      */       }
/* 1187 */       insertResult = ps.executeUpdate();
/*      */     } finally {
/* 1189 */       if (null != ps)
/*      */         try {
/* 1191 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 1197 */     if (insertResult > 0) {
/* 1198 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 1199 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 1200 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*      */       }
/*      */     }
/* 1203 */     return insertResult;
/*      */   }
/*      */ 
/*      */   public int insertSimpleTrigger(Connection conn, SimpleTrigger trigger)
/*      */     throws SQLException
/*      */   {
/* 1219 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1222 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}SIMPLE_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES(?, ?, ?, ?, ?)"));
/* 1223 */       ps.setString(1, trigger.getName());
/* 1224 */       ps.setString(2, trigger.getGroup());
/* 1225 */       ps.setInt(3, trigger.getRepeatCount());
/* 1226 */       ps.setBigDecimal(4, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
/*      */ 
/* 1228 */       ps.setInt(5, trigger.getTimesTriggered());
/*      */ 
/* 1230 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1232 */       if (null != ps)
/*      */         try {
/* 1234 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertCronTrigger(Connection conn, CronTrigger trigger)
/*      */     throws SQLException
/*      */   {
/* 1254 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1257 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}CRON_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES(?, ?, ?, ?)"));
/* 1258 */       ps.setString(1, trigger.getName());
/* 1259 */       ps.setString(2, trigger.getGroup());
/* 1260 */       ps.setString(3, trigger.getCronExpression());
/* 1261 */       ps.setString(4, trigger.getTimeZone().getID());
/*      */ 
/* 1263 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1265 */       if (null != ps)
/*      */         try {
/* 1267 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertBlobTrigger(Connection conn, Trigger trigger)
/*      */     throws SQLException, IOException
/*      */   {
/* 1287 */     PreparedStatement ps = null;
/* 1288 */     ByteArrayOutputStream os = null;
/*      */     try
/*      */     {
/* 1292 */       os = new ByteArrayOutputStream();
/* 1293 */       ObjectOutputStream oos = new ObjectOutputStream(os);
/* 1294 */       oos.writeObject(trigger);
/* 1295 */       oos.close();
/*      */ 
/* 1297 */       byte[] buf = os.toByteArray();
/* 1298 */       ByteArrayInputStream is = new ByteArrayInputStream(buf);
/*      */ 
/* 1300 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}BLOB_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES(?, ?, ?)"));
/* 1301 */       ps.setString(1, trigger.getName());
/* 1302 */       ps.setString(2, trigger.getGroup());
/* 1303 */       ps.setBinaryStream(3, is, buf.length);
/*      */ 
/* 1305 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1307 */       if (null != ps)
/*      */         try {
/* 1309 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail)
/*      */     throws SQLException, IOException
/*      */   {
/* 1333 */     boolean updateJobData = trigger.getJobDataMap().isDirty();
/* 1334 */     ByteArrayOutputStream baos = null;
/* 1335 */     if ((updateJobData) && (trigger.getJobDataMap().size() > 0)) {
/* 1336 */       baos = serializeJobData(trigger.getJobDataMap());
/*      */     }
/* 1338 */     PreparedStatement ps = null;
/*      */ 
/* 1340 */     int insertResult = 0;
/*      */     try
/*      */     {
/* 1344 */       if (updateJobData)
/* 1345 */         ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/*      */       else {
/* 1347 */         ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/*      */       }
/* 1349 */       ps.setString(1, trigger.getJobName());
/* 1350 */       ps.setString(2, trigger.getJobGroup());
/* 1351 */       ps.setBoolean(3, trigger.isVolatile());
/* 1352 */       ps.setString(4, trigger.getDescription());
/* 1353 */       long nextFireTime = -1L;
/* 1354 */       if (trigger.getNextFireTime() != null) {
/* 1355 */         nextFireTime = trigger.getNextFireTime().getTime();
/*      */       }
/* 1357 */       ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
/* 1358 */       long prevFireTime = -1L;
/* 1359 */       if (trigger.getPreviousFireTime() != null) {
/* 1360 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*      */       }
/* 1362 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
/* 1363 */       ps.setString(7, state);
/* 1364 */       if ((trigger instanceof SimpleTrigger))
/*      */       {
/* 1366 */         ps.setString(8, "SIMPLE");
/* 1367 */       } else if ((trigger instanceof CronTrigger))
/*      */       {
/* 1369 */         ps.setString(8, "CRON");
/*      */       }
/*      */       else {
/* 1372 */         ps.setString(8, "BLOB");
/*      */       }
/* 1374 */       ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*      */ 
/* 1376 */       long endTime = 0L;
/* 1377 */       if (trigger.getEndTime() != null) {
/* 1378 */         endTime = trigger.getEndTime().getTime();
/*      */       }
/* 1380 */       ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
/* 1381 */       ps.setString(11, trigger.getCalendarName());
/* 1382 */       ps.setInt(12, trigger.getMisfireInstruction());
/* 1383 */       if (updateJobData) {
/* 1384 */         ps.setBytes(13, baos.toByteArray());
/*      */ 
/* 1386 */         ps.setString(14, trigger.getName());
/* 1387 */         ps.setString(15, trigger.getGroup());
/*      */       }
/*      */       else {
/* 1390 */         ps.setString(13, trigger.getName());
/* 1391 */         ps.setString(14, trigger.getGroup());
/*      */       }
/*      */ 
/* 1394 */       insertResult = ps.executeUpdate();
/*      */     } finally {
/* 1396 */       if (null != ps)
/*      */         try {
/* 1398 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 1404 */     if (insertResult > 0) {
/* 1405 */       deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
/*      */ 
/* 1407 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 1408 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 1409 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*      */       }
/*      */     }
/* 1412 */     return insertResult;
/*      */   }
/*      */ 
/*      */   public int updateSimpleTrigger(Connection conn, SimpleTrigger trigger)
/*      */     throws SQLException
/*      */   {
/* 1428 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1431 */       ps = conn.prepareStatement(rtp("UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/*      */ 
/* 1433 */       ps.setInt(1, trigger.getRepeatCount());
/* 1434 */       ps.setBigDecimal(2, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
/*      */ 
/* 1436 */       ps.setInt(3, trigger.getTimesTriggered());
/* 1437 */       ps.setString(4, trigger.getName());
/* 1438 */       ps.setString(5, trigger.getGroup());
/*      */ 
/* 1440 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1442 */       if (null != ps)
/*      */         try {
/* 1444 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateCronTrigger(Connection conn, CronTrigger trigger)
/*      */     throws SQLException
/*      */   {
/* 1464 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1467 */       ps = conn.prepareStatement(rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1468 */       ps.setString(1, trigger.getCronExpression());
/* 1469 */       ps.setString(2, trigger.getName());
/* 1470 */       ps.setString(3, trigger.getGroup());
/*      */ 
/* 1472 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1474 */       if (null != ps)
/*      */         try {
/* 1476 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateBlobTrigger(Connection conn, Trigger trigger)
/*      */     throws SQLException, IOException
/*      */   {
/* 1496 */     PreparedStatement ps = null;
/* 1497 */     ByteArrayOutputStream os = null;
/*      */     try
/*      */     {
/* 1501 */       os = new ByteArrayOutputStream();
/* 1502 */       ObjectOutputStream oos = new ObjectOutputStream(os);
/* 1503 */       oos.writeObject(trigger);
/* 1504 */       oos.close();
/*      */ 
/* 1506 */       byte[] buf = os.toByteArray();
/* 1507 */       ByteArrayInputStream is = new ByteArrayInputStream(buf);
/*      */ 
/* 1509 */       ps = conn.prepareStatement(rtp("UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1510 */       ps.setBinaryStream(1, is, buf.length);
/* 1511 */       ps.setString(2, trigger.getName());
/* 1512 */       ps.setString(3, trigger.getGroup());
/*      */ 
/* 1514 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1516 */       if (null != ps)
/*      */         try {
/* 1518 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1522 */       if (os != null) os.close();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean triggerExists(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 1541 */     PreparedStatement ps = null;
/* 1542 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1545 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1546 */       ps.setString(1, triggerName);
/* 1547 */       ps.setString(2, groupName);
/* 1548 */       rs = ps.executeQuery();
/*      */ 
/* 1550 */       if (rs.next()) {
/* 1551 */         i = 1; jsr 23;
/*      */       }
/* 1553 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1556 */       if (null != rs)
/*      */         try {
/* 1558 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1562 */       if (null != ps)
/*      */         try {
/* 1564 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerState(Connection conn, String triggerName, String groupName, String state)
/*      */     throws SQLException
/*      */   {
/* 1588 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1591 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1592 */       ps.setString(1, state);
/* 1593 */       ps.setString(2, triggerName);
/* 1594 */       ps.setString(3, groupName);
/*      */ 
/* 1596 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1598 */       if (null != ps)
/*      */         try {
/* 1600 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerStateFromOtherStates(Connection conn, String triggerName, String groupName, String newState, String oldState1, String oldState2, String oldState3)
/*      */     throws SQLException
/*      */   {
/* 1634 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1637 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
/* 1638 */       ps.setString(1, newState);
/* 1639 */       ps.setString(2, triggerName);
/* 1640 */       ps.setString(3, groupName);
/* 1641 */       ps.setString(4, oldState1);
/* 1642 */       ps.setString(5, oldState2);
/* 1643 */       ps.setString(6, oldState3);
/*      */ 
/* 1645 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1647 */       if (null != ps)
/*      */         try {
/* 1649 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerStateFromOtherStatesBeforeTime(Connection conn, String newState, String oldState1, String oldState2, long time) throws SQLException
/*      */   {
/* 1659 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1662 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE (TRIGGER_STATE = ? OR TRIGGER_STATE = ?) AND NEXT_FIRE_TIME < ?"));
/*      */ 
/* 1664 */       ps.setString(1, newState);
/* 1665 */       ps.setString(2, oldState1);
/* 1666 */       ps.setString(3, oldState2);
/* 1667 */       ps.setLong(4, time);
/*      */ 
/* 1669 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1671 */       if (null != ps)
/*      */         try {
/* 1673 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerGroupStateFromOtherStates(Connection conn, String groupName, String newState, String oldState1, String oldState2, String oldState3)
/*      */     throws SQLException
/*      */   {
/* 1704 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1707 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
/*      */ 
/* 1709 */       ps.setString(1, newState);
/* 1710 */       ps.setString(2, groupName);
/* 1711 */       ps.setString(3, oldState1);
/* 1712 */       ps.setString(4, oldState2);
/* 1713 */       ps.setString(5, oldState3);
/*      */ 
/* 1715 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1717 */       if (null != ps)
/*      */         try {
/* 1719 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerStateFromOtherState(Connection conn, String triggerName, String groupName, String newState, String oldState)
/*      */     throws SQLException
/*      */   {
/* 1748 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1751 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
/* 1752 */       ps.setString(1, newState);
/* 1753 */       ps.setString(2, triggerName);
/* 1754 */       ps.setString(3, groupName);
/* 1755 */       ps.setString(4, oldState);
/*      */ 
/* 1757 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1759 */       if (null != ps)
/*      */         try {
/* 1761 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerGroupStateFromOtherState(Connection conn, String groupName, String newState, String oldState)
/*      */     throws SQLException
/*      */   {
/* 1788 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1791 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
/*      */ 
/* 1793 */       ps.setString(1, newState);
/* 1794 */       ps.setString(2, groupName);
/* 1795 */       ps.setString(3, oldState);
/*      */ 
/* 1797 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1799 */       if (null != ps)
/*      */         try {
/* 1801 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerStatesForJob(Connection conn, String jobName, String groupName, String state)
/*      */     throws SQLException
/*      */   {
/* 1825 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1828 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 1829 */       ps.setString(1, state);
/* 1830 */       ps.setString(2, jobName);
/* 1831 */       ps.setString(3, groupName);
/*      */ 
/* 1833 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1835 */       if (null != ps)
/*      */         try {
/* 1837 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateTriggerStatesForJobFromOtherState(Connection conn, String jobName, String groupName, String state, String oldState) throws SQLException
/*      */   {
/* 1847 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1850 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?"));
/*      */ 
/* 1852 */       ps.setString(1, state);
/* 1853 */       ps.setString(2, jobName);
/* 1854 */       ps.setString(3, groupName);
/* 1855 */       ps.setString(4, oldState);
/*      */ 
/* 1857 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1859 */       if (null != ps)
/*      */         try {
/* 1861 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteTriggerListeners(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 1883 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1886 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1887 */       ps.setString(1, triggerName);
/* 1888 */       ps.setString(2, groupName);
/* 1889 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1891 */       if (null != ps)
/*      */         try {
/* 1893 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertTriggerListener(Connection conn, Trigger trigger, String listener)
/*      */     throws SQLException
/*      */   {
/* 1915 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1918 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}TRIGGER_LISTENERS (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER) VALUES(?, ?, ?)"));
/* 1919 */       ps.setString(1, trigger.getName());
/* 1920 */       ps.setString(2, trigger.getGroup());
/* 1921 */       ps.setString(3, listener);
/*      */ 
/* 1923 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 1925 */       if (null != ps)
/*      */         try {
/* 1927 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectTriggerListeners(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 1949 */     PreparedStatement ps = null;
/* 1950 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1953 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_LISTENER FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 1954 */       ps.setString(1, triggerName);
/* 1955 */       ps.setString(2, groupName);
/* 1956 */       rs = ps.executeQuery();
/*      */ 
/* 1958 */       ArrayList list = new ArrayList();
/* 1959 */       while (rs.next()) {
/* 1960 */         list.add(rs.getString(1));
/*      */       }
/* 1962 */       Object[] oArr = list.toArray();
/* 1963 */       String[] sArr = new String[oArr.length];
/* 1964 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 1965 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 1967 */       if (null != rs)
/*      */         try {
/* 1969 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 1973 */       if (null != ps)
/*      */         try {
/* 1975 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteSimpleTrigger(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 1997 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2000 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2001 */       ps.setString(1, triggerName);
/* 2002 */       ps.setString(2, groupName);
/*      */ 
/* 2004 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2006 */       if (null != ps)
/*      */         try {
/* 2008 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteCronTrigger(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2030 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2033 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2034 */       ps.setString(1, triggerName);
/* 2035 */       ps.setString(2, groupName);
/*      */ 
/* 2037 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2039 */       if (null != ps)
/*      */         try {
/* 2041 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteBlobTrigger(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2063 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2066 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2067 */       ps.setString(1, triggerName);
/* 2068 */       ps.setString(2, groupName);
/*      */ 
/* 2070 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2072 */       if (null != ps)
/*      */         try {
/* 2074 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteTrigger(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2096 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2099 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2100 */       ps.setString(1, triggerName);
/* 2101 */       ps.setString(2, groupName);
/*      */ 
/* 2103 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2105 */       if (null != ps)
/*      */         try {
/* 2107 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int selectNumTriggersForJob(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2129 */     PreparedStatement ps = null;
/* 2130 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2133 */       ps = conn.prepareStatement(rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 2134 */       ps.setString(1, jobName);
/* 2135 */       ps.setString(2, groupName);
/* 2136 */       rs = ps.executeQuery();
/*      */ 
/* 2138 */       if (rs.next()) {
/* 2139 */         i = rs.getInt(1); jsr 23;
/*      */       }
/* 2141 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2144 */       if (null != rs)
/*      */         try {
/* 2146 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2150 */       if (null != ps)
/*      */         try {
/* 2152 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JobDetail selectJobForTrigger(Connection conn, String triggerName, String groupName, ClassLoadHelper loadHelper)
/*      */     throws ClassNotFoundException, SQLException
/*      */   {
/* 2177 */     PreparedStatement ps = null;
/* 2178 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2181 */       ps = conn.prepareStatement(rtp("SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.JOB_CLASS_NAME, J.REQUESTS_RECOVERY FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP"));
/* 2182 */       ps.setString(1, triggerName);
/* 2183 */       ps.setString(2, groupName);
/* 2184 */       rs = ps.executeQuery();
/*      */       JobDetail localJobDetail1;
/* 2186 */       if (rs.next()) {
/* 2187 */         job = new JobDetail();
/* 2188 */         job.setName(rs.getString(1));
/* 2189 */         job.setGroup(rs.getString(2));
/* 2190 */         job.setDurability(rs.getBoolean(3));
/* 2191 */         job.setJobClass(loadHelper.loadClass(rs.getString(4)));
/*      */ 
/* 2193 */         job.setRequestsRecovery(rs.getBoolean(5));
/*      */ 
/* 2195 */         localJobDetail1 = job; jsr 65;
/*      */       }
/* 2197 */       this.logger.debug("No job for trigger '" + groupName + "." + triggerName + "'.");
/*      */ 
/* 2199 */       job = null;
/*      */     }
/*      */     finally
/*      */     {
/*      */       JobDetail job;
/* 2202 */       if (null != rs)
/*      */         try {
/* 2204 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2208 */       if (null != ps)
/*      */         try {
/* 2210 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger[] selectTriggersForJob(Connection conn, String jobName, String groupName)
/*      */     throws SQLException, ClassNotFoundException, IOException
/*      */   {
/* 2236 */     ArrayList trigList = new ArrayList();
/* 2237 */     PreparedStatement ps = null;
/* 2238 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2241 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 2242 */       ps.setString(1, jobName);
/* 2243 */       ps.setString(2, groupName);
/* 2244 */       rs = ps.executeQuery();
/*      */ 
/* 2246 */       while (rs.next()) {
/* 2247 */         Trigger t = selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP"));
/*      */ 
/* 2250 */         if (t != null)
/* 2251 */           trigList.add(t);
/*      */       }
/*      */     } finally {
/* 2254 */       if (null != rs)
/*      */         try {
/* 2256 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2260 */       if (null != ps)
/*      */         try {
/* 2262 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 2268 */     return (Trigger[])trigList.toArray(new Trigger[trigList.size()]);
/*      */   }
/*      */ 
/*      */   public Trigger[] selectTriggersForCalendar(Connection conn, String calName)
/*      */     throws SQLException, ClassNotFoundException, IOException
/*      */   {
/* 2274 */     ArrayList trigList = new ArrayList();
/* 2275 */     PreparedStatement ps = null;
/* 2276 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2279 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
/* 2280 */       ps.setString(1, calName);
/* 2281 */       rs = ps.executeQuery();
/*      */ 
/* 2283 */       while (rs.next()) {
/* 2284 */         trigList.add(selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/* 2289 */       if (null != rs)
/*      */         try {
/* 2291 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2295 */       if (null != ps)
/*      */         try {
/* 2297 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 2303 */     return (Trigger[])trigList.toArray(new Trigger[trigList.size()]);
/*      */   }
/*      */ 
/*      */   public List selectStatefulJobsOfTriggerGroup(Connection conn, String groupName) throws SQLException
/*      */   {
/* 2308 */     ArrayList jobList = new ArrayList();
/* 2309 */     PreparedStatement ps = null;
/* 2310 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2313 */       ps = conn.prepareStatement(rtp("SELECT DISTINCT J.JOB_NAME, J.JOB_GROUP FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP AND J.IS_STATEFUL = ?"));
/*      */ 
/* 2315 */       ps.setString(1, groupName);
/* 2316 */       ps.setBoolean(2, true);
/* 2317 */       rs = ps.executeQuery();
/*      */ 
/* 2319 */       while (rs.next())
/* 2320 */         jobList.add(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
/*      */     }
/*      */     finally
/*      */     {
/* 2324 */       if (null != rs)
/*      */         try {
/* 2326 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2330 */       if (null != ps)
/*      */         try {
/* 2332 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 2338 */     return jobList;
/*      */   }
/*      */ 
/*      */   public Trigger selectTrigger(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException, ClassNotFoundException, IOException
/*      */   {
/* 2357 */     PreparedStatement ps = null;
/* 2358 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2361 */       Trigger trigger = null;
/*      */ 
/* 2363 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2364 */       ps.setString(1, triggerName);
/* 2365 */       ps.setString(2, groupName);
/* 2366 */       rs = ps.executeQuery();
/*      */ 
/* 2368 */       if (rs.next()) {
/* 2369 */         jobName = rs.getString("JOB_NAME");
/* 2370 */         String jobGroup = rs.getString("JOB_GROUP");
/* 2371 */         boolean volatility = rs.getBoolean("IS_VOLATILE");
/* 2372 */         String description = rs.getString("DESCRIPTION");
/* 2373 */         long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
/* 2374 */         long prevFireTime = rs.getLong("PREV_FIRE_TIME");
/* 2375 */         String triggerType = rs.getString("TRIGGER_TYPE");
/* 2376 */         long startTime = rs.getLong("START_TIME");
/* 2377 */         long endTime = rs.getLong("END_TIME");
/* 2378 */         String calendarName = rs.getString("CALENDAR_NAME");
/* 2379 */         int misFireInstr = rs.getInt("MISFIRE_INSTR");
/*      */ 
/* 2381 */         Map map = null;
/* 2382 */         if (canUseProperties()) map = getMapFromProperties(rs);
/*      */         else {
/* 2384 */           map = (Map)getObjectFromBlob(rs, "JOB_DATA");
/*      */         }
/* 2386 */         Date nft = null;
/* 2387 */         if (nextFireTime > 0L) {
/* 2388 */           nft = new Date(nextFireTime);
/*      */         }
/* 2390 */         Date pft = null;
/* 2391 */         if (prevFireTime > 0L) {
/* 2392 */           pft = new Date(prevFireTime);
/*      */         }
/* 2394 */         Date startTimeD = new Date(startTime);
/* 2395 */         Date endTimeD = null;
/* 2396 */         if (endTime > 0L) {
/* 2397 */           endTimeD = new Date(endTime);
/*      */         }
/*      */ 
/* 2400 */         rs.close();
/* 2401 */         ps.close();
/*      */ 
/* 2403 */         if (triggerType.equals("SIMPLE")) {
/* 2404 */           ps = conn.prepareStatement(rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2405 */           ps.setString(1, triggerName);
/* 2406 */           ps.setString(2, groupName);
/* 2407 */           rs = ps.executeQuery();
/*      */ 
/* 2409 */           if (rs.next()) {
/* 2410 */             int repeatCount = rs.getInt("REPEAT_COUNT");
/* 2411 */             long repeatInterval = rs.getLong("REPEAT_INTERVAL");
/* 2412 */             int timesTriggered = rs.getInt("TIMES_TRIGGERED");
/*      */ 
/* 2414 */             SimpleTrigger st = new SimpleTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, repeatCount, repeatInterval);
/*      */ 
/* 2417 */             st.setCalendarName(calendarName);
/* 2418 */             st.setMisfireInstruction(misFireInstr);
/* 2419 */             st.setTimesTriggered(timesTriggered);
/* 2420 */             st.setVolatility(volatility);
/* 2421 */             st.setNextFireTime(nft);
/* 2422 */             st.setPreviousFireTime(pft);
/* 2423 */             st.setDescription(description);
/* 2424 */             if (null != map) {
/* 2425 */               st.setJobDataMap(new JobDataMap(map));
/*      */             }
/* 2427 */             trigger = st;
/*      */           }
/* 2429 */         } else if (triggerType.equals("CRON")) {
/* 2430 */           ps = conn.prepareStatement(rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2431 */           ps.setString(1, triggerName);
/* 2432 */           ps.setString(2, groupName);
/* 2433 */           rs = ps.executeQuery();
/*      */ 
/* 2435 */           if (rs.next()) {
/* 2436 */             String cronExpr = rs.getString("CRON_EXPRESSION");
/* 2437 */             String timeZoneId = rs.getString("TIME_ZONE_ID");
/*      */ 
/* 2439 */             CronTrigger ct = null;
/*      */             try {
/* 2441 */               TimeZone timeZone = null;
/* 2442 */               if (timeZoneId != null) {
/* 2443 */                 timeZone = TimeZone.getTimeZone(timeZoneId);
/*      */               }
/* 2445 */               ct = new CronTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, cronExpr, timeZone);
/*      */             }
/*      */             catch (Exception neverHappens)
/*      */             {
/*      */             }
/*      */ 
/* 2452 */             if (null != ct) {
/* 2453 */               ct.setCalendarName(calendarName);
/* 2454 */               ct.setMisfireInstruction(misFireInstr);
/* 2455 */               ct.setVolatility(volatility);
/* 2456 */               ct.setNextFireTime(nft);
/* 2457 */               ct.setPreviousFireTime(pft);
/* 2458 */               ct.setDescription(description);
/* 2459 */               if (null != map) {
/* 2460 */                 ct.setJobDataMap(new JobDataMap(map));
/*      */               }
/* 2462 */               trigger = ct;
/*      */             }
/*      */           }
/* 2465 */         } else if (triggerType.equals("BLOB")) {
/* 2466 */           ps = conn.prepareStatement(rtp("SELECT * FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2467 */           ps.setString(1, triggerName);
/* 2468 */           ps.setString(2, groupName);
/* 2469 */           rs = ps.executeQuery();
/*      */ 
/* 2471 */           if (rs.next())
/* 2472 */             trigger = (Trigger)getObjectFromBlob(rs, "BLOB_DATA");
/*      */         }
/*      */         else {
/* 2475 */           throw new ClassNotFoundException("class for trigger type '" + triggerType + "' not found.");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2480 */       jobName = trigger;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String jobName;
/* 2482 */       if (null != rs)
/*      */         try {
/* 2484 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2488 */       if (null != ps)
/*      */         try {
/* 2490 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JobDataMap selectTriggerJobDataMap(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException, ClassNotFoundException, IOException
/*      */   {
/* 2515 */     PreparedStatement ps = null;
/* 2516 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2519 */       Trigger trigger = null;
/*      */ 
/* 2521 */       ps = conn.prepareStatement(rtp("SELECT JOB_DATA FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2522 */       ps.setString(1, triggerName);
/* 2523 */       ps.setString(2, groupName);
/* 2524 */       rs = ps.executeQuery();
/*      */ 
/* 2526 */       if (rs.next())
/*      */       {
/* 2528 */         Map map = null;
/* 2529 */         if (canUseProperties())
/* 2530 */           map = getMapFromProperties(rs);
/*      */         else {
/* 2532 */           map = (Map)getObjectFromBlob(rs, "JOB_DATA");
/*      */         }
/* 2534 */         rs.close();
/* 2535 */         ps.close();
/*      */ 
/* 2537 */         if (null != map) {
/* 2538 */           localJobDataMap = new JobDataMap(map); jsr 20;
/*      */         }
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*      */       JobDataMap localJobDataMap;
/* 2542 */       if (null != rs)
/*      */         try {
/* 2544 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2548 */       if (null != ps)
/*      */         try {
/* 2550 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/* 2556 */     return new JobDataMap();
/*      */   }
/*      */ 
/*      */   public String selectTriggerState(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2575 */     PreparedStatement ps = null;
/* 2576 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2579 */       String state = null;
/*      */ 
/* 2581 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2582 */       ps.setString(1, triggerName);
/* 2583 */       ps.setString(2, groupName);
/* 2584 */       rs = ps.executeQuery();
/*      */ 
/* 2586 */       if (rs.next())
/* 2587 */         state = rs.getString("TRIGGER_STATE");
/*      */       else {
/* 2589 */         state = "DELETED";
/*      */       }
/* 2591 */       str1 = state.intern();
/*      */     }
/*      */     finally
/*      */     {
/*      */       String str1;
/* 2593 */       if (null != rs)
/*      */         try {
/* 2595 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2599 */       if (null != ps)
/*      */         try {
/* 2601 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public TriggerStatus selectTriggerStatus(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2624 */     PreparedStatement ps = null;
/* 2625 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2628 */       TriggerStatus status = null;
/*      */ 
/* 2630 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 2631 */       ps.setString(1, triggerName);
/* 2632 */       ps.setString(2, groupName);
/* 2633 */       rs = ps.executeQuery();
/*      */ 
/* 2635 */       if (rs.next()) {
/* 2636 */         state = rs.getString("TRIGGER_STATE");
/* 2637 */         long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
/* 2638 */         String jobName = rs.getString("JOB_NAME");
/* 2639 */         String jobGroup = rs.getString("JOB_GROUP");
/*      */ 
/* 2641 */         Date nft = null;
/* 2642 */         if (nextFireTime > 0L) {
/* 2643 */           nft = new Date(nextFireTime);
/*      */         }
/*      */ 
/* 2646 */         status = new TriggerStatus(state, nft);
/* 2647 */         status.setKey(new Key(triggerName, groupName));
/* 2648 */         status.setJobKey(new Key(jobName, jobGroup));
/*      */       }
/*      */ 
/* 2651 */       state = status;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String state;
/* 2653 */       if (null != rs)
/*      */         try {
/* 2655 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2659 */       if (null != ps)
/*      */         try {
/* 2661 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int selectNumTriggers(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 2679 */     PreparedStatement ps = null;
/* 2680 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2683 */       int count = 0;
/* 2684 */       ps = conn.prepareStatement(rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS"));
/* 2685 */       rs = ps.executeQuery();
/*      */ 
/* 2687 */       if (rs.next()) {
/* 2688 */         count = rs.getInt(1);
/*      */       }
/*      */ 
/* 2691 */       i = count;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2693 */       if (null != rs)
/*      */         try {
/* 2695 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2699 */       if (null != ps)
/*      */         try {
/* 2701 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectTriggerGroups(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 2718 */     PreparedStatement ps = null;
/* 2719 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2722 */       ps = conn.prepareStatement(rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS"));
/* 2723 */       rs = ps.executeQuery();
/*      */ 
/* 2725 */       ArrayList list = new ArrayList();
/* 2726 */       while (rs.next()) {
/* 2727 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/* 2730 */       Object[] oArr = list.toArray();
/* 2731 */       String[] sArr = new String[oArr.length];
/* 2732 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 2733 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 2735 */       if (null != rs)
/*      */         try {
/* 2737 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2741 */       if (null != ps)
/*      */         try {
/* 2743 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectTriggersInGroup(Connection conn, String groupName)
/*      */     throws SQLException
/*      */   {
/* 2763 */     PreparedStatement ps = null;
/* 2764 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2767 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
/* 2768 */       ps.setString(1, groupName);
/* 2769 */       rs = ps.executeQuery();
/*      */ 
/* 2771 */       ArrayList list = new ArrayList();
/* 2772 */       while (rs.next()) {
/* 2773 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/* 2776 */       Object[] oArr = list.toArray();
/* 2777 */       String[] sArr = new String[oArr.length];
/* 2778 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 2779 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 2781 */       if (null != rs)
/*      */         try {
/* 2783 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2787 */       if (null != ps)
/*      */         try {
/* 2789 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertPausedTriggerGroup(Connection conn, String groupName) throws SQLException {
/* 2798 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2801 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}PAUSED_TRIGGER_GRPS (TRIGGER_GROUP) VALUES(?)"));
/* 2802 */       ps.setString(1, groupName);
/* 2803 */       int rows = ps.executeUpdate();
/*      */ 
/* 2805 */       i = rows;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2807 */       if (null != ps)
/*      */         try {
/* 2809 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deletePausedTriggerGroup(Connection conn, String groupName) throws SQLException {
/* 2818 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2821 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
/* 2822 */       ps.setString(1, groupName);
/* 2823 */       int rows = ps.executeUpdate();
/*      */ 
/* 2825 */       i = rows;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2827 */       if (null != ps)
/*      */         try {
/* 2829 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteAllPausedTriggerGroups(Connection conn) throws SQLException {
/* 2838 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2841 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS"));
/* 2842 */       int rows = ps.executeUpdate();
/*      */ 
/* 2844 */       i = rows;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2846 */       if (null != ps)
/*      */         try {
/* 2848 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isTriggerGroupPaused(Connection conn, String groupName) throws SQLException {
/* 2857 */     PreparedStatement ps = null;
/* 2858 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2861 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
/* 2862 */       ps.setString(1, groupName);
/* 2863 */       rs = ps.executeQuery();
/*      */ 
/* 2865 */       bool = rs.next();
/*      */     }
/*      */     finally
/*      */     {
/*      */       boolean bool;
/* 2867 */       if (null != rs)
/*      */         try {
/* 2869 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2873 */       if (null != ps)
/*      */         try {
/* 2875 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isExistingTriggerGroup(Connection conn, String groupName) throws SQLException {
/* 2884 */     PreparedStatement ps = null;
/* 2885 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 2888 */       ps = conn.prepareStatement(rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
/* 2889 */       ps.setString(1, groupName);
/* 2890 */       rs = ps.executeQuery();
/*      */ 
/* 2892 */       if (!rs.next()) { i = 0; jsr 38;
/*      */       }
/* 2894 */       i = rs.getInt(1) > 0 ? 1 : 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2896 */       if (null != rs)
/*      */         try {
/* 2898 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 2902 */       if (null != ps)
/*      */         try {
/* 2904 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertCalendar(Connection conn, String calendarName, Calendar calendar)
/*      */     throws IOException, SQLException
/*      */   {
/* 2932 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*      */ 
/* 2934 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2937 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
/* 2938 */       ps.setString(1, calendarName);
/* 2939 */       ps.setBytes(2, baos.toByteArray());
/*      */ 
/* 2941 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2943 */       if (null != ps)
/*      */         try {
/* 2945 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateCalendar(Connection conn, String calendarName, Calendar calendar)
/*      */     throws IOException, SQLException
/*      */   {
/* 2969 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*      */ 
/* 2971 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 2974 */       ps = conn.prepareStatement(rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
/* 2975 */       ps.setBytes(1, baos.toByteArray());
/* 2976 */       ps.setString(2, calendarName);
/*      */ 
/* 2978 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 2980 */       if (null != ps)
/*      */         try {
/* 2982 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean calendarExists(Connection conn, String calendarName)
/*      */     throws SQLException
/*      */   {
/* 3002 */     PreparedStatement ps = null;
/* 3003 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3006 */       ps = conn.prepareStatement(rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
/* 3007 */       ps.setString(1, calendarName);
/* 3008 */       rs = ps.executeQuery();
/*      */ 
/* 3010 */       if (rs.next()) {
/* 3011 */         i = 1; jsr 23;
/*      */       }
/* 3013 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3016 */       if (null != rs)
/*      */         try {
/* 3018 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3022 */       if (null != ps)
/*      */         try {
/* 3024 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Calendar selectCalendar(Connection conn, String calendarName)
/*      */     throws ClassNotFoundException, IOException, SQLException
/*      */   {
/* 3049 */     PreparedStatement ps = null;
/* 3050 */     ResultSet rs = null;
/*      */     try {
/* 3052 */       String selCal = rtp("SELECT * FROM {0}CALENDARS WHERE CALENDAR_NAME = ?");
/* 3053 */       ps = conn.prepareStatement(selCal);
/* 3054 */       ps.setString(1, calendarName);
/* 3055 */       rs = ps.executeQuery();
/*      */ 
/* 3057 */       Calendar cal = null;
/* 3058 */       if (rs.next()) {
/* 3059 */         cal = (Calendar)getObjectFromBlob(rs, "CALENDAR");
/*      */       }
/* 3061 */       if (null == cal) {
/* 3062 */         this.logger.warn("Couldn't find calendar with name '" + calendarName + "'.");
/*      */       }
/*      */ 
/* 3065 */       localCalendar1 = cal;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Calendar localCalendar1;
/* 3067 */       if (null != rs)
/*      */         try {
/* 3069 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3073 */       if (null != ps)
/*      */         try {
/* 3075 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean calendarIsReferenced(Connection conn, String calendarName)
/*      */     throws SQLException
/*      */   {
/* 3095 */     PreparedStatement ps = null;
/* 3096 */     ResultSet rs = null;
/*      */     try {
/* 3098 */       ps = conn.prepareStatement(rtp("SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
/* 3099 */       ps.setString(1, calendarName);
/* 3100 */       rs = ps.executeQuery();
/*      */ 
/* 3102 */       if (rs.next()) {
/* 3103 */         i = 1; jsr 23;
/*      */       }
/* 3105 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3108 */       if (null != rs)
/*      */         try {
/* 3110 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3114 */       if (null != ps)
/*      */         try {
/* 3116 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteCalendar(Connection conn, String calendarName)
/*      */     throws SQLException
/*      */   {
/* 3136 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 3139 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
/* 3140 */       ps.setString(1, calendarName);
/*      */ 
/* 3142 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3144 */       if (null != ps)
/*      */         try {
/* 3146 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int selectNumCalendars(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 3163 */     PreparedStatement ps = null;
/* 3164 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3167 */       int count = 0;
/* 3168 */       ps = conn.prepareStatement(rtp("SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS"));
/*      */ 
/* 3170 */       rs = ps.executeQuery();
/*      */ 
/* 3172 */       if (rs.next()) {
/* 3173 */         count = rs.getInt(1);
/*      */       }
/*      */ 
/* 3176 */       i = count;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3178 */       if (null != rs)
/*      */         try {
/* 3180 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3184 */       if (null != ps)
/*      */         try {
/* 3186 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] selectCalendars(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 3203 */     PreparedStatement ps = null;
/* 3204 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3207 */       ps = conn.prepareStatement(rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS"));
/* 3208 */       rs = ps.executeQuery();
/*      */ 
/* 3210 */       ArrayList list = new ArrayList();
/* 3211 */       while (rs.next()) {
/* 3212 */         list.add(rs.getString(1));
/*      */       }
/*      */ 
/* 3215 */       Object[] oArr = list.toArray();
/* 3216 */       String[] sArr = new String[oArr.length];
/* 3217 */       System.arraycopy(oArr, 0, sArr, 0, oArr.length);
/* 3218 */       arrayOfString1 = sArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String[] arrayOfString1;
/* 3220 */       if (null != rs)
/*      */         try {
/* 3222 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3226 */       if (null != ps)
/*      */         try {
/* 3228 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public long selectNextFireTime(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 3249 */     PreparedStatement ps = null;
/* 3250 */     ResultSet rs = null;
/*      */     try {
/* 3252 */       ps = conn.prepareStatement(rtp("SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0"));
/* 3253 */       ps.setString(1, "WAITING");
/* 3254 */       rs = ps.executeQuery();
/*      */ 
/* 3256 */       if (rs.next()) {
/* 3257 */         l = rs.getLong("ALIAS_NXT_FR_TM"); jsr 23;
/*      */       }
/* 3259 */       l = 0L;
/*      */     }
/*      */     finally
/*      */     {
/*      */       long l;
/* 3262 */       if (null != rs)
/*      */         try {
/* 3264 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3268 */       if (null != ps)
/*      */         try {
/* 3270 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key selectTriggerForFireTime(Connection conn, long fireTime)
/*      */     throws SQLException
/*      */   {
/* 3292 */     PreparedStatement ps = null;
/* 3293 */     ResultSet rs = null;
/*      */     try {
/* 3295 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?"));
/* 3296 */       ps.setString(1, "WAITING");
/* 3297 */       ps.setBigDecimal(2, new BigDecimal(String.valueOf(fireTime)));
/* 3298 */       rs = ps.executeQuery();
/*      */ 
/* 3300 */       if (rs.next()) {
/* 3301 */         localKey = new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")); jsr 23;
/*      */       }
/*      */ 
/* 3304 */       localKey = null;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key localKey;
/* 3307 */       if (null != rs)
/*      */         try {
/* 3309 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3313 */       if (null != ps)
/*      */         try {
/* 3315 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job)
/*      */     throws SQLException
/*      */   {
/* 3337 */     PreparedStatement ps = null;
/*      */     try {
/* 3339 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 3340 */       ps.setString(1, trigger.getFireInstanceId());
/* 3341 */       ps.setString(2, trigger.getName());
/* 3342 */       ps.setString(3, trigger.getGroup());
/* 3343 */       ps.setBoolean(4, trigger.isVolatile());
/* 3344 */       ps.setString(5, this.instanceId);
/* 3345 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*      */ 
/* 3347 */       ps.setString(7, state);
/* 3348 */       if (job != null) {
/* 3349 */         ps.setString(8, trigger.getJobName());
/* 3350 */         ps.setString(9, trigger.getJobGroup());
/* 3351 */         ps.setBoolean(10, job.isStateful());
/* 3352 */         ps.setBoolean(11, job.requestsRecovery());
/*      */       } else {
/* 3354 */         ps.setString(8, null);
/* 3355 */         ps.setString(9, null);
/* 3356 */         ps.setBoolean(10, false);
/* 3357 */         ps.setBoolean(11, false);
/*      */       }
/*      */ 
/* 3360 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3362 */       if (null != ps)
/*      */         try {
/* 3364 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public List selectFiredTriggerRecords(Connection conn, String triggerName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 3381 */     PreparedStatement ps = null;
/* 3382 */     ResultSet rs = null;
/*      */     try {
/* 3384 */       List lst = new LinkedList();
/*      */ 
/* 3386 */       if (triggerName != null) {
/* 3387 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 3388 */         ps.setString(1, triggerName);
/* 3389 */         ps.setString(2, groupName);
/*      */       } else {
/* 3391 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_GROUP = ?"));
/* 3392 */         ps.setString(1, groupName);
/*      */       }
/* 3394 */       rs = ps.executeQuery();
/*      */ 
/* 3396 */       while (rs.next()) {
/* 3397 */         rec = new FiredTriggerRecord();
/*      */ 
/* 3399 */         rec.setFireInstanceId(rs.getString("ENTRY_ID"));
/* 3400 */         rec.setFireInstanceState(rs.getString("STATE"));
/* 3401 */         rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
/* 3402 */         rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
/* 3403 */         rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
/* 3404 */         rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
/*      */ 
/* 3406 */         if (!rec.getFireInstanceState().equals("ACQUIRED")) {
/* 3407 */           rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
/* 3408 */           rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
/*      */ 
/* 3410 */           rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
/*      */         }
/*      */ 
/* 3413 */         lst.add(rec);
/*      */       }
/*      */ 
/* 3416 */       rec = lst;
/*      */     }
/*      */     finally
/*      */     {
/*      */       FiredTriggerRecord rec;
/* 3418 */       if (null != rs)
/*      */         try {
/* 3420 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3424 */       if (null != ps)
/*      */         try {
/* 3426 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public List selectFiredTriggerRecordsByJob(Connection conn, String jobName, String groupName)
/*      */     throws SQLException
/*      */   {
/* 3443 */     PreparedStatement ps = null;
/* 3444 */     ResultSet rs = null;
/*      */     try {
/* 3446 */       List lst = new LinkedList();
/*      */ 
/* 3448 */       if (jobName != null) {
/* 3449 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 3450 */         ps.setString(1, jobName);
/* 3451 */         ps.setString(2, groupName);
/*      */       } else {
/* 3453 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_GROUP = ?"));
/*      */ 
/* 3455 */         ps.setString(1, groupName);
/*      */       }
/* 3457 */       rs = ps.executeQuery();
/*      */ 
/* 3459 */       while (rs.next()) {
/* 3460 */         rec = new FiredTriggerRecord();
/*      */ 
/* 3462 */         rec.setFireInstanceId(rs.getString("ENTRY_ID"));
/* 3463 */         rec.setFireInstanceState(rs.getString("STATE"));
/* 3464 */         rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
/* 3465 */         rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
/* 3466 */         rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
/* 3467 */         rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
/*      */ 
/* 3469 */         if (!rec.getFireInstanceState().equals("ACQUIRED")) {
/* 3470 */           rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
/* 3471 */           rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
/*      */ 
/* 3473 */           rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
/*      */         }
/*      */ 
/* 3476 */         lst.add(rec);
/*      */       }
/*      */ 
/* 3479 */       rec = lst;
/*      */     }
/*      */     finally
/*      */     {
/*      */       FiredTriggerRecord rec;
/* 3481 */       if (null != rs)
/*      */         try {
/* 3483 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3487 */       if (null != ps)
/*      */         try {
/* 3489 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public List selectInstancesFiredTriggerRecords(Connection conn, String instanceName) throws SQLException
/*      */   {
/* 3499 */     PreparedStatement ps = null;
/* 3500 */     ResultSet rs = null;
/*      */     try {
/* 3502 */       List lst = new LinkedList();
/*      */ 
/* 3504 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
/* 3505 */       ps.setString(1, instanceName);
/* 3506 */       rs = ps.executeQuery();
/*      */ 
/* 3508 */       while (rs.next()) {
/* 3509 */         rec = new FiredTriggerRecord();
/*      */ 
/* 3511 */         rec.setFireInstanceId(rs.getString("ENTRY_ID"));
/* 3512 */         rec.setFireInstanceState(rs.getString("STATE"));
/* 3513 */         rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
/* 3514 */         rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
/* 3515 */         rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
/* 3516 */         rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
/*      */ 
/* 3518 */         if (!rec.getFireInstanceState().equals("ACQUIRED")) {
/* 3519 */           rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
/* 3520 */           rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
/*      */ 
/* 3522 */           rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
/*      */         }
/*      */ 
/* 3525 */         lst.add(rec);
/*      */       }
/*      */ 
/* 3528 */       rec = lst;
/*      */     }
/*      */     finally
/*      */     {
/*      */       FiredTriggerRecord rec;
/* 3530 */       if (null != rs)
/*      */         try {
/* 3532 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3536 */       if (null != ps)
/*      */         try {
/* 3538 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteFiredTrigger(Connection conn, String entryId)
/*      */     throws SQLException
/*      */   {
/* 3558 */     PreparedStatement ps = null;
/*      */     try {
/* 3560 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE ENTRY_ID = ?"));
/* 3561 */       ps.setString(1, entryId);
/*      */ 
/* 3563 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3565 */       if (null != ps)
/*      */         try {
/* 3567 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int selectJobExecutionCount(Connection conn, String jobName, String jobGroup) throws SQLException {
/* 3576 */     PreparedStatement ps = null;
/* 3577 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3580 */       ps = conn.prepareStatement(rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 3581 */       ps.setString(1, jobName);
/* 3582 */       ps.setString(2, jobGroup);
/*      */ 
/* 3584 */       rs = ps.executeQuery();
/*      */ 
/* 3586 */       if (rs.next()) { i = rs.getInt(1); jsr 23;
/*      */       }
/* 3588 */       i = 0;
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3591 */       if (null != rs)
/*      */         try {
/* 3593 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3597 */       if (null != ps)
/*      */         try {
/* 3599 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
/* 3607 */     PreparedStatement ps = null;
/*      */     try {
/* 3609 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
/* 3610 */       ps.setBoolean(1, true);
/*      */ 
/* 3612 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3614 */       if (null != ps)
/*      */         try {
/* 3616 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int insertSchedulerState(Connection conn, String instanceId, long checkInTime, long interval, String recoverer) throws SQLException
/*      */   {
/* 3626 */     PreparedStatement ps = null;
/*      */     try {
/* 3628 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}SCHEDULER_STATE (INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL, RECOVERER) VALUES(?, ?, ?, ?)"));
/* 3629 */       ps.setString(1, instanceId);
/* 3630 */       ps.setLong(2, checkInTime);
/* 3631 */       ps.setLong(3, interval);
/* 3632 */       ps.setString(4, recoverer);
/*      */ 
/* 3634 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3636 */       if (null != ps)
/*      */         try {
/* 3638 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int deleteSchedulerState(Connection conn, String instanceId) throws SQLException {
/* 3647 */     PreparedStatement ps = null;
/*      */     try {
/* 3649 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
/* 3650 */       ps.setString(1, instanceId);
/*      */ 
/* 3652 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3654 */       if (null != ps)
/*      */         try {
/* 3656 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int updateSchedulerState(Connection conn, String instanceId, long checkInTime, String recoverer) throws SQLException {
/* 3665 */     PreparedStatement ps = null;
/*      */     try {
/* 3667 */       ps = conn.prepareStatement(rtp("UPDATE {0}SCHEDULER_STATE SET LAST_CHECKIN_TIME = ?, RECOVERER = ? WHERE INSTANCE_NAME = ?"));
/* 3668 */       ps.setLong(1, checkInTime);
/* 3669 */       ps.setString(2, recoverer);
/* 3670 */       ps.setString(3, instanceId);
/*      */ 
/* 3672 */       i = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       int i;
/* 3674 */       if (null != ps)
/*      */         try {
/* 3676 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public List selectSchedulerStateRecords(Connection conn, String instanceId) throws SQLException {
/* 3685 */     PreparedStatement ps = null;
/* 3686 */     ResultSet rs = null;
/*      */     try {
/* 3688 */       List lst = new LinkedList();
/*      */ 
/* 3690 */       if (instanceId != null) {
/* 3691 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
/* 3692 */         ps.setString(1, instanceId);
/*      */       } else {
/* 3694 */         ps = conn.prepareStatement(rtp("SELECT * FROM {0}SCHEDULER_STATE"));
/*      */       }
/* 3696 */       rs = ps.executeQuery();
/*      */ 
/* 3698 */       while (rs.next()) {
/* 3699 */         rec = new SchedulerStateRecord();
/*      */ 
/* 3701 */         rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
/* 3702 */         rec.setCheckinTimestamp(rs.getLong("LAST_CHECKIN_TIME"));
/* 3703 */         rec.setCheckinInterval(rs.getLong("CHECKIN_INTERVAL"));
/* 3704 */         rec.setRecoverer(rs.getString("RECOVERER"));
/*      */ 
/* 3706 */         lst.add(rec);
/*      */       }
/*      */ 
/* 3709 */       rec = lst;
/*      */     }
/*      */     finally
/*      */     {
/*      */       SchedulerStateRecord rec;
/* 3711 */       if (null != rs)
/*      */         try {
/* 3713 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3717 */       if (null != ps)
/*      */         try {
/* 3719 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected final String rtp(String query)
/*      */   {
/* 3742 */     return Util.rtp(query, this.tablePrefix);
/*      */   }
/*      */ 
/*      */   protected ByteArrayOutputStream serializeObject(Object obj)
/*      */     throws IOException
/*      */   {
/* 3759 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 3760 */     if (null != obj) {
/* 3761 */       ObjectOutputStream out = new ObjectOutputStream(baos);
/* 3762 */       out.writeObject(obj);
/* 3763 */       out.flush();
/*      */     }
/* 3765 */     return baos;
/*      */   }
/*      */ 
/*      */   protected ByteArrayOutputStream serializeJobData(JobDataMap data)
/*      */     throws IOException
/*      */   {
/* 3782 */     if (canUseProperties()) return serializeProperties(data);
/*      */ 
/* 3784 */     if (null != data) {
/* 3785 */       data.removeTransientData();
/* 3786 */       return serializeObject(data);
/*      */     }
/* 3788 */     return serializeObject(null);
/*      */   }
/*      */ 
/*      */   private ByteArrayOutputStream serializeProperties(JobDataMap data)
/*      */     throws IOException
/*      */   {
/* 3797 */     ByteArrayOutputStream ba = new ByteArrayOutputStream();
/* 3798 */     if (null != data) {
/* 3799 */       Properties properties = convertToProperty(data.getWrappedMap());
/* 3800 */       properties.store(ba, "");
/*      */     }
/*      */ 
/* 3803 */     return ba;
/*      */   }
/*      */ 
/*      */   protected Map convertFromProperty(Properties properties)
/*      */     throws IOException
/*      */   {
/* 3810 */     Map data = new HashMap();
/* 3811 */     Set keys = properties.keySet();
/* 3812 */     Iterator it = keys.iterator();
/* 3813 */     while (it.hasNext()) {
/* 3814 */       Object key = it.next();
/* 3815 */       Object val = properties.get(key);
/* 3816 */       data.put(key, val);
/*      */     }
/*      */ 
/* 3819 */     return data;
/*      */   }
/*      */ 
/*      */   protected Properties convertToProperty(Map data)
/*      */     throws IOException
/*      */   {
/* 3826 */     Properties properties = new Properties();
/* 3827 */     Set keys = data.keySet();
/* 3828 */     Iterator it = keys.iterator();
/* 3829 */     while (it.hasNext()) {
/* 3830 */       Object key = it.next();
/* 3831 */       Object val = data.get(key);
/* 3832 */       if (!(key instanceof String)) {
/* 3833 */         throw new IOException("JobDataMap keys/values must be Strings when the 'useProperties' property is set.  offending Key: " + key);
/*      */       }
/*      */ 
/* 3836 */       if (!(val instanceof String)) {
/* 3837 */         throw new IOException("JobDataMap values must be Strings when the 'useProperties' property is set.  Key of offending value: " + key);
/*      */       }
/*      */ 
/* 3840 */       if (val == null) val = "";
/* 3841 */       properties.put(key, val);
/*      */     }
/* 3843 */     return properties;
/*      */   }
/*      */ 
/*      */   protected Object getObjectFromBlob(ResultSet rs, String colName)
/*      */     throws ClassNotFoundException, IOException, SQLException
/*      */   {
/* 3865 */     Object obj = null;
/*      */ 
/* 3867 */     Blob blobLocator = rs.getBlob(colName);
/* 3868 */     if (blobLocator != null) {
/* 3869 */       InputStream binaryInput = blobLocator.getBinaryStream();
/*      */ 
/* 3871 */       if (null != binaryInput) {
/* 3872 */         ObjectInputStream in = new ObjectInputStream(binaryInput);
/* 3873 */         obj = in.readObject();
/* 3874 */         in.close();
/*      */       }
/*      */     }
/* 3877 */     return obj;
/*      */   }
/*      */ 
/*      */   public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
/* 3881 */     PreparedStatement ps = null;
/* 3882 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3885 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
/* 3886 */       ps.setBoolean(1, true);
/* 3887 */       rs = ps.executeQuery();
/*      */ 
/* 3889 */       ArrayList list = new ArrayList();
/* 3890 */       while (rs.next()) {
/* 3891 */         String triggerName = rs.getString("TRIGGER_NAME");
/* 3892 */         String groupName = rs.getString("TRIGGER_GROUP");
/* 3893 */         list.add(new Key(triggerName, groupName));
/*      */       }
/* 3895 */       Object[] oArr = list.toArray();
/* 3896 */       Key[] kArr = new Key[oArr.length];
/* 3897 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 3898 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/* 3900 */       if (null != rs)
/*      */         try {
/* 3902 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3906 */       if (null != ps)
/*      */         try {
/* 3908 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Key[] selectVolatileJobs(Connection conn) throws SQLException {
/* 3916 */     PreparedStatement ps = null;
/* 3917 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 3920 */       ps = conn.prepareStatement(rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
/* 3921 */       ps.setBoolean(1, true);
/* 3922 */       rs = ps.executeQuery();
/*      */ 
/* 3924 */       ArrayList list = new ArrayList();
/* 3925 */       while (rs.next()) {
/* 3926 */         String triggerName = rs.getString("JOB_NAME");
/* 3927 */         String groupName = rs.getString("JOB_GROUP");
/* 3928 */         list.add(new Key(triggerName, groupName));
/*      */       }
/* 3930 */       Object[] oArr = list.toArray();
/* 3931 */       Key[] kArr = new Key[oArr.length];
/* 3932 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 3933 */       arrayOfKey1 = kArr;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Key[] arrayOfKey1;
/* 3935 */       if (null != rs)
/*      */         try {
/* 3937 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 3941 */       if (null != ps)
/*      */         try {
/* 3943 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Object getJobDetailFromBlob(ResultSet rs, String colName)
/*      */     throws ClassNotFoundException, IOException, SQLException
/*      */   {
/* 3969 */     if (canUseProperties()) {
/* 3970 */       Blob blobLocator = rs.getBlob(colName);
/* 3971 */       if (blobLocator != null) {
/* 3972 */         InputStream binaryInput = blobLocator.getBinaryStream();
/* 3973 */         return binaryInput;
/*      */       }
/* 3975 */       return null;
/*      */     }
/*      */ 
/* 3979 */     return getObjectFromBlob(rs, colName);
/*      */   }
/*      */ 
/*      */   public Set selectPausedTriggerGroups(Connection conn)
/*      */     throws SQLException
/*      */   {
/* 3986 */     PreparedStatement ps = null;
/* 3987 */     ResultSet rs = null;
/*      */ 
/* 3989 */     HashSet set = new HashSet();
/*      */     try {
/* 3991 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS"));
/* 3992 */       rs = ps.executeQuery();
/*      */ 
/* 3994 */       while (rs.next()) {
/* 3995 */         groupName = rs.getString("TRIGGER_GROUP");
/* 3996 */         set.add(groupName);
/*      */       }
/* 3998 */       groupName = set;
/*      */     }
/*      */     finally
/*      */     {
/*      */       String groupName;
/* 4000 */       if (null != rs)
/*      */         try {
/* 4002 */           rs.close();
/*      */         }
/*      */         catch (SQLException ignore) {
/*      */         }
/* 4006 */       if (null != ps)
/*      */         try {
/* 4008 */           ps.close();
/*      */         }
/*      */         catch (SQLException ignore)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.StdJDBCDelegate
 * JD-Core Version:    0.6.0
 */