/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ public class SimpleSemaphore
/*     */   implements Semaphore
/*     */ {
/*  46 */   ThreadLocal lockOwners = new ThreadLocal();
/*     */ 
/*  48 */   HashSet locks = new HashSet();
/*     */ 
/*     */   Log getLog()
/*     */   {
/*  59 */     return LogFactory.getLog(getClass());
/*     */   }
/*     */ 
/*     */   private HashSet getThreadLocks()
/*     */   {
/*  64 */     HashSet threadLocks = (HashSet)this.lockOwners.get();
/*  65 */     if (threadLocks == null) {
/*  66 */       threadLocks = new HashSet();
/*  67 */       this.lockOwners.set(threadLocks);
/*     */     }
/*  69 */     return threadLocks;
/*     */   }
/*     */ 
/*     */   public synchronized boolean obtainLock(Connection conn, String lockName)
/*     */   {
/*  80 */     lockName = lockName.intern();
/*     */ 
/*  82 */     Log log = getLog();
/*     */ 
/*  84 */     if (log.isDebugEnabled()) {
/*  85 */       log.debug("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName());
/*     */     }
/*     */ 
/*  89 */     if (!isLockOwner(conn, lockName)) {
/*  90 */       if (log.isDebugEnabled()) {
/*  91 */         log.debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
/*     */       }
/*     */ 
/*  94 */       while (this.locks.contains(lockName)) {
/*     */         try {
/*  96 */           wait();
/*     */         } catch (InterruptedException ie) {
/*  98 */           if (log.isDebugEnabled()) {
/*  99 */             log.debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 105 */       if (log.isDebugEnabled()) {
/* 106 */         log.debug("Lock '" + lockName + "' given to: " + Thread.currentThread().getName());
/*     */       }
/*     */ 
/* 109 */       getThreadLocks().add(lockName);
/* 110 */       this.locks.add(lockName);
/*     */     }
/* 112 */     else if (log.isDebugEnabled()) {
/* 113 */       log.debug("Lock '" + lockName + "' already owned by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
/*     */     }
/*     */ 
/* 119 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized void releaseLock(Connection conn, String lockName)
/*     */   {
/* 128 */     lockName = lockName.intern();
/*     */ 
/* 130 */     if (isLockOwner(conn, lockName)) {
/* 131 */       if (getLog().isDebugEnabled()) {
/* 132 */         getLog().debug("Lock '" + lockName + "' retuned by: " + Thread.currentThread().getName());
/*     */       }
/*     */ 
/* 135 */       getThreadLocks().remove(lockName);
/* 136 */       this.locks.remove(lockName);
/* 137 */       notify();
/*     */     }
/* 139 */     else if (getLog().isDebugEnabled()) {
/* 140 */       getLog().debug("Lock '" + lockName + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized boolean isLockOwner(Connection conn, String lockName)
/*     */   {
/* 153 */     lockName = lockName.intern();
/*     */ 
/* 155 */     return getThreadLocks().contains(lockName);
/*     */   }
/*     */ 
/*     */   public void init(Connection conn, List listOfLocks)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.SimpleSemaphore
 * JD-Core Version:    0.6.0
 */