/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class PostgreSQLDelegate extends StdJDBCDelegate
/*     */ {
/*     */   public PostgreSQLDelegate(Log log, String tablePrefix, String instanceId)
/*     */   {
/*  51 */     super(log, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public PostgreSQLDelegate(Log log, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  68 */     super(log, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   protected Object getObjectFromBlob(ResultSet rs, String colName)
/*     */     throws ClassNotFoundException, IOException, SQLException
/*     */   {
/*  94 */     InputStream binaryInput = null;
/*  95 */     byte[] bytes = rs.getBytes(colName);
/*     */ 
/*  97 */     Object obj = null;
/*     */ 
/*  99 */     if (bytes != null) {
/* 100 */       binaryInput = new ByteArrayInputStream(bytes);
/*     */ 
/* 102 */       ObjectInputStream in = new ObjectInputStream(binaryInput);
/* 103 */       obj = in.readObject();
/* 104 */       in.close();
/*     */     }
/*     */ 
/* 107 */     return obj;
/*     */   }
/*     */ 
/*     */   protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException
/*     */   {
/* 112 */     if (canUseProperties()) {
/* 113 */       InputStream binaryInput = null;
/* 114 */       byte[] bytes = rs.getBytes(colName);
/* 115 */       if ((bytes == null) || (bytes.length == 0))
/* 116 */         return null;
/* 117 */       binaryInput = new ByteArrayInputStream(bytes);
/* 118 */       return binaryInput;
/*     */     }
/* 120 */     return getObjectFromBlob(rs, colName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.PostgreSQLDelegate
 * JD-Core Version:    0.6.0
 */