/*    */ package org.quartz.impl.jdbcjobstore;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import org.apache.commons.logging.Log;
/*    */ 
/*    */ public class MSSQLDelegate extends StdJDBCDelegate
/*    */ {
/*    */   public MSSQLDelegate(Log log, String tablePrefix, String instanceId)
/*    */   {
/* 50 */     super(log, tablePrefix, instanceId);
/*    */   }
/*    */ 
/*    */   public MSSQLDelegate(Log log, String tablePrefix, String instanceId, Boolean useProperties) {
/* 54 */     super(log, tablePrefix, instanceId, useProperties);
/*    */   }
/*    */ 
/*    */   protected Object getObjectFromBlob(ResultSet rs, String colName)
/*    */     throws ClassNotFoundException, IOException, SQLException
/*    */   {
/* 80 */     InputStream binaryInput = rs.getBinaryStream(colName);
/*    */ 
/* 82 */     if (binaryInput == null) {
/* 83 */       return null;
/*    */     }
/* 85 */     ObjectInputStream in = new ObjectInputStream(binaryInput);
/* 86 */     Object obj = in.readObject();
/* 87 */     in.close();
/*    */ 
/* 89 */     return obj;
/*    */   }
/*    */ 
/*    */   protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException
/*    */   {
/* 94 */     if (canUseProperties()) {
/* 95 */       InputStream binaryInput = rs.getBinaryStream(colName);
/* 96 */       return binaryInput;
/*    */     }
/* 98 */     return getObjectFromBlob(rs, colName);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.MSSQLDelegate
 * JD-Core Version:    0.6.0
 */