/*      */ package org.quartz.impl.jdbcjobstore;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.quartz.Calendar;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.JobPersistenceException;
/*      */ import org.quartz.ObjectAlreadyExistsException;
/*      */ import org.quartz.SchedulerConfigException;
/*      */ import org.quartz.Trigger;
/*      */ import org.quartz.core.SchedulingContext;
/*      */ import org.quartz.spi.ClassLoadHelper;
/*      */ import org.quartz.spi.SchedulerSignaler;
/*      */ import org.quartz.spi.TriggerFiredBundle;
/*      */ 
/*      */ public class JobStoreTX extends JobStoreSupport
/*      */ {
/*      */   public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler)
/*      */     throws SchedulerConfigException
/*      */   {
/*   68 */     super.initialize(loadHelper, signaler);
/*      */ 
/*   70 */     getLog().info("JobStoreTX initialized.");
/*      */   }
/*      */ 
/*      */   protected void recoverJobs()
/*      */     throws JobPersistenceException
/*      */   {
/*   87 */     Connection conn = getConnection();
/*   88 */     boolean transOwner = false;
/*      */     try {
/*   90 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*   91 */       transOwner = true;
/*      */ 
/*   94 */       recoverJobs(conn);
/*   95 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*   97 */       rollbackConnection(conn);
/*   98 */       throw e;
/*      */     } finally {
/*      */       try {
/*  101 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  103 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
/*  109 */     Connection conn = getConnection();
/*  110 */     boolean transOwner = false;
/*      */     try {
/*  112 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  113 */       transOwner = true;
/*      */ 
/*  116 */       cleanVolatileTriggerAndJobs(conn);
/*  117 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  119 */       rollbackConnection(conn);
/*  120 */       throw e;
/*      */     } finally {
/*      */       try {
/*  123 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  125 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  150 */     Connection conn = getConnection();
/*  151 */     boolean transOwner = false;
/*      */     try {
/*  153 */       if (isLockOnInsert()) {
/*  154 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  155 */         transOwner = true;
/*      */       }
/*      */ 
/*  159 */       if ((newJob.isVolatile()) && (!newTrigger.isVolatile())) {
/*  160 */         JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
/*      */ 
/*  163 */         jpe.setErrorCode(100);
/*  164 */         throw jpe;
/*      */       }
/*      */ 
/*  167 */       storeJob(conn, ctxt, newJob, false);
/*  168 */       storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
/*      */ 
/*  170 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  172 */       rollbackConnection(conn);
/*  173 */       throw e;
/*      */     } finally {
/*      */       try {
/*  176 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  178 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  201 */     Connection conn = getConnection();
/*  202 */     boolean transOwner = false;
/*      */     try {
/*  204 */       if ((isLockOnInsert()) || (replaceExisting)) {
/*  205 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  206 */         transOwner = true;
/*      */       }
/*      */ 
/*  210 */       storeJob(conn, ctxt, newJob, replaceExisting);
/*  211 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  213 */       rollbackConnection(conn);
/*  214 */       throw e;
/*      */     } finally {
/*      */       try {
/*  217 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  219 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  246 */     Connection conn = getConnection();
/*  247 */     boolean transOwner = false;
/*      */     try {
/*  249 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  250 */       transOwner = true;
/*      */ 
/*  253 */       boolean removed = removeJob(conn, ctxt, jobName, groupName, true);
/*  254 */       commitConnection(conn);
/*  255 */       bool1 = removed;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       boolean bool1;
/*  257 */       rollbackConnection(conn);
/*  258 */       throw e;
/*      */     } finally {
/*      */       try {
/*  261 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  263 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  282 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  285 */       JobDetail job = retrieveJob(conn, ctxt, jobName, groupName);
/*  286 */       commitConnection(conn);
/*  287 */       JobDetail localJobDetail1 = job;
/*      */       return localJobDetail1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  292 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  314 */     Connection conn = getConnection();
/*  315 */     boolean transOwner = false;
/*      */     try {
/*  317 */       if ((isLockOnInsert()) || (replaceExisting)) {
/*  318 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  319 */         transOwner = true;
/*      */       }
/*      */ 
/*  323 */       storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
/*      */ 
/*  325 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  327 */       rollbackConnection(conn);
/*  328 */       throw e;
/*      */     } finally {
/*      */       try {
/*  331 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  333 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  365 */     Connection conn = getConnection();
/*  366 */     boolean transOwner = false;
/*      */     try {
/*  368 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  369 */       transOwner = true;
/*      */ 
/*  372 */       boolean removed = removeTrigger(conn, ctxt, triggerName, groupName);
/*  373 */       commitConnection(conn);
/*  374 */       bool1 = removed;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       boolean bool1;
/*  376 */       rollbackConnection(conn);
/*  377 */       throw e;
/*      */     } finally {
/*      */       try {
/*  380 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  382 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger)
/*      */     throws JobPersistenceException
/*      */   {
/*  391 */     Connection conn = getConnection();
/*  392 */     boolean transOwner = false;
/*      */     try {
/*  394 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  395 */       transOwner = true;
/*      */ 
/*  398 */       boolean removed = replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
/*  399 */       commitConnection(conn);
/*  400 */       bool1 = removed;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       boolean bool1;
/*  402 */       rollbackConnection(conn);
/*  403 */       throw e;
/*      */     } finally {
/*      */       try {
/*  406 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  408 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  429 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  432 */       Trigger trigger = retrieveTrigger(conn, ctxt, triggerName, groupName);
/*      */ 
/*  434 */       commitConnection(conn);
/*  435 */       Trigger localTrigger1 = trigger;
/*      */       return localTrigger1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  440 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  464 */     Connection conn = getConnection();
/*  465 */     boolean lockOwner = false;
/*      */     try {
/*  467 */       if ((isLockOnInsert()) || (updateTriggers)) {
/*  468 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  469 */         lockOwner = true;
/*      */       }
/*      */ 
/*  472 */       storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
/*  473 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  475 */       rollbackConnection(conn);
/*  476 */       throw e;
/*      */     } finally {
/*      */       try {
/*  479 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
/*      */       } finally {
/*  481 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeCalendar(SchedulingContext ctxt, String calName)
/*      */     throws JobPersistenceException
/*      */   {
/*  503 */     Connection conn = getConnection();
/*  504 */     boolean lockOwner = false;
/*      */     try {
/*  506 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  507 */       lockOwner = true;
/*      */ 
/*  509 */       boolean removed = removeCalendar(conn, ctxt, calName);
/*  510 */       commitConnection(conn);
/*  511 */       bool1 = removed;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       boolean bool1;
/*  513 */       rollbackConnection(conn);
/*  514 */       throw e;
/*      */     } finally {
/*      */       try {
/*  517 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
/*      */       } finally {
/*  519 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Calendar retrieveCalendar(SchedulingContext ctxt, String calName)
/*      */     throws JobPersistenceException
/*      */   {
/*  536 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  539 */       Calendar cal = retrieveCalendar(conn, ctxt, calName);
/*  540 */       commitConnection(conn);
/*  541 */       Calendar localCalendar1 = cal;
/*      */       return localCalendar1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  546 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfJobs(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  562 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  565 */       int numJobs = getNumberOfJobs(conn, ctxt);
/*  566 */       commitConnection(conn);
/*  567 */       int i = numJobs;
/*      */       return i;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  572 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfTriggers(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  584 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  587 */       int numTriggers = getNumberOfTriggers(conn, ctxt);
/*  588 */       commitConnection(conn);
/*  589 */       int i = numTriggers;
/*      */       return i;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  594 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfCalendars(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  606 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  609 */       int numCals = getNumberOfCalendars(conn, ctxt);
/*  610 */       commitConnection(conn);
/*  611 */       int i = numCals;
/*      */       return i;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  616 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public Set getPausedTriggerGroups(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  624 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  627 */       Set groups = getPausedTriggerGroups(conn, ctxt);
/*  628 */       commitConnection(conn);
/*  629 */       Set localSet1 = groups;
/*      */       return localSet1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  634 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getJobNames(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  651 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  654 */       String[] jobNames = getJobNames(conn, ctxt, groupName);
/*  655 */       commitConnection(conn);
/*  656 */       String[] arrayOfString1 = jobNames;
/*      */       return arrayOfString1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  661 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getTriggerNames(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  678 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  681 */       String[] triggerNames = getTriggerNames(conn, ctxt, groupName);
/*  682 */       commitConnection(conn);
/*  683 */       String[] arrayOfString1 = triggerNames;
/*      */       return arrayOfString1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  688 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getJobGroupNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  705 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  708 */       String[] groupNames = getJobGroupNames(conn, ctxt);
/*  709 */       commitConnection(conn);
/*  710 */       String[] arrayOfString1 = groupNames;
/*      */       return arrayOfString1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  715 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getTriggerGroupNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  732 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  735 */       String[] triggerGroups = getTriggerGroupNames(conn, ctxt);
/*  736 */       commitConnection(conn);
/*  737 */       String[] arrayOfString1 = triggerGroups;
/*      */       return arrayOfString1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  742 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getCalendarNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  759 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  762 */       String[] calNames = getCalendarNames(conn, ctxt);
/*  763 */       commitConnection(conn);
/*  764 */       String[] arrayOfString1 = calNames;
/*      */       return arrayOfString1;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  769 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  784 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  787 */       Trigger[] arrayOfTrigger = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */       return arrayOfTrigger;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  792 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  809 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  812 */       int i = getTriggerState(conn, ctxt, triggerName, groupName);
/*      */       return i;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       throw e;
/*      */     } finally {
/*  817 */       closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  834 */     Connection conn = getConnection();
/*  835 */     boolean transOwner = false;
/*      */     try {
/*  837 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  838 */       transOwner = true;
/*      */ 
/*  841 */       pauseTrigger(conn, ctxt, triggerName, groupName);
/*  842 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  844 */       rollbackConnection(conn);
/*  845 */       throw e;
/*      */     } finally {
/*      */       try {
/*  848 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  850 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  865 */     Connection conn = getConnection();
/*  866 */     boolean transOwner = false;
/*      */     try {
/*  868 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  869 */       transOwner = true;
/*      */ 
/*  872 */       pauseTriggerGroup(conn, ctxt, groupName);
/*  873 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  875 */       rollbackConnection(conn);
/*  876 */       throw e;
/*      */     } finally {
/*      */       try {
/*  879 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  881 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  896 */     Connection conn = getConnection();
/*  897 */     boolean transOwner = false;
/*      */     try {
/*  899 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  900 */       transOwner = true;
/*      */ 
/*  903 */       Trigger[] triggers = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */ 
/*  905 */       for (int j = 0; j < triggers.length; j++) {
/*  906 */         pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */ 
/*  910 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  912 */       rollbackConnection(conn);
/*  913 */       throw e;
/*      */     } finally {
/*      */       try {
/*  916 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  918 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJobGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  933 */     Connection conn = getConnection();
/*  934 */     boolean transOwner = false;
/*      */     try {
/*  936 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  937 */       transOwner = true;
/*      */ 
/*  940 */       String[] jobNames = getJobNames(conn, ctxt, groupName);
/*      */ 
/*  942 */       for (int i = 0; i < jobNames.length; i++) {
/*  943 */         Trigger[] triggers = getTriggersForJob(conn, ctxt, jobNames[i], groupName);
/*      */ 
/*  945 */         for (int j = 0; j < triggers.length; j++) {
/*  946 */           pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  951 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  953 */       rollbackConnection(conn);
/*  954 */       throw e;
/*      */     } finally {
/*      */       try {
/*  957 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  959 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  979 */     Connection conn = getConnection();
/*  980 */     boolean transOwner = false;
/*      */     try {
/*  982 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  983 */       transOwner = true;
/*      */ 
/*  986 */       resumeTrigger(conn, ctxt, triggerName, groupName);
/*  987 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/*  989 */       rollbackConnection(conn);
/*  990 */       throw e;
/*      */     } finally {
/*      */       try {
/*  993 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  995 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/* 1015 */     Connection conn = getConnection();
/* 1016 */     boolean transOwner = false;
/*      */     try {
/* 1018 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1019 */       transOwner = true;
/*      */ 
/* 1022 */       resumeTriggerGroup(conn, ctxt, groupName);
/* 1023 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1025 */       rollbackConnection(conn);
/* 1026 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1029 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1031 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/* 1052 */     Connection conn = getConnection();
/* 1053 */     boolean transOwner = false;
/*      */     try {
/* 1055 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1056 */       transOwner = true;
/*      */ 
/* 1059 */       Trigger[] triggers = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */ 
/* 1061 */       for (int j = 0; j < triggers.length; j++) {
/* 1062 */         resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */ 
/* 1066 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1068 */       rollbackConnection(conn);
/* 1069 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1072 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1074 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJobGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/* 1095 */     Connection conn = getConnection();
/* 1096 */     boolean transOwner = false;
/*      */     try {
/* 1098 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1099 */       transOwner = true;
/*      */ 
/* 1102 */       String[] jobNames = getJobNames(conn, ctxt, groupName);
/*      */ 
/* 1104 */       for (int i = 0; i < jobNames.length; i++) {
/* 1105 */         Trigger[] triggers = getTriggersForJob(conn, ctxt, jobNames[i], groupName);
/*      */ 
/* 1107 */         for (int j = 0; j < triggers.length; j++) {
/* 1108 */           resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */         }
/*      */       }
/*      */ 
/* 1112 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1114 */       rollbackConnection(conn);
/* 1115 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1118 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1120 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseAll(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/* 1140 */     Connection conn = getConnection();
/* 1141 */     boolean transOwner = false;
/*      */     try {
/* 1143 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1144 */       transOwner = true;
/*      */ 
/* 1147 */       pauseAll(conn, ctxt);
/* 1148 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1150 */       rollbackConnection(conn);
/* 1151 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1154 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1156 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeAll(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/* 1176 */     Connection conn = getConnection();
/* 1177 */     boolean transOwner = false;
/*      */     try {
/* 1179 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1180 */       transOwner = true;
/*      */ 
/* 1183 */       resumeAll(conn, ctxt);
/* 1184 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1186 */       rollbackConnection(conn);
/* 1187 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1190 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1192 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan)
/*      */     throws JobPersistenceException
/*      */   {
/* 1211 */     Connection conn = getConnection();
/* 1212 */     boolean transOwner = false;
/*      */     try {
/* 1214 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1215 */       transOwner = true;
/*      */ 
/* 1218 */       Trigger trigger = acquireNextTrigger(conn, ctxt, noLaterThan);
/* 1219 */       commitConnection(conn);
/* 1220 */       localTrigger1 = trigger;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       Trigger localTrigger1;
/* 1222 */       rollbackConnection(conn);
/* 1223 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1226 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1228 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger)
/*      */     throws JobPersistenceException
/*      */   {
/* 1242 */     Connection conn = getConnection();
/* 1243 */     boolean transOwner = false;
/*      */     try {
/* 1245 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1246 */       transOwner = true;
/*      */ 
/* 1249 */       releaseAcquiredTrigger(conn, ctxt, trigger);
/* 1250 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1252 */       rollbackConnection(conn);
/* 1253 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1256 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1258 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger)
/*      */     throws JobPersistenceException
/*      */   {
/* 1276 */     Connection conn = getConnection();
/* 1277 */     boolean transOwner = false;
/*      */     try {
/* 1279 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1280 */       transOwner = true;
/*      */ 
/* 1283 */       TriggerFiredBundle tfb = null;
/* 1284 */       JobPersistenceException err = null;
/*      */       try {
/* 1286 */         tfb = triggerFired(conn, ctxt, trigger);
/*      */       } catch (JobPersistenceException jpe) {
/* 1288 */         if (jpe.getErrorCode() != 410)
/* 1289 */           throw jpe;
/* 1290 */         err = jpe;
/*      */       }
/*      */ 
/* 1293 */       commitConnection(conn);
/* 1294 */       if (err != null) throw err;
/* 1295 */       jpe = tfb;
/*      */     } catch (JobPersistenceException e) {
/* 1297 */       rollbackConnection(conn);
/* 1298 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1301 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1303 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode)
/*      */     throws JobPersistenceException
/*      */   {
/* 1320 */     Connection conn = getConnection();
/* 1321 */     boolean transOwner = false;
/*      */     try {
/* 1323 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1324 */       transOwner = true;
/*      */ 
/* 1327 */       triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
/*      */ 
/* 1329 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1331 */       rollbackConnection(conn);
/* 1332 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1335 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1337 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean doRecoverMisfires() throws JobPersistenceException {
/* 1343 */     Connection conn = getConnection();
/* 1344 */     boolean transOwner = false;
/* 1345 */     boolean moreToDo = false;
/*      */     try {
/* 1347 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1348 */       transOwner = true;
/*      */       try
/*      */       {
/* 1352 */         moreToDo = recoverMisfiredJobs(conn, false);
/*      */       } catch (Exception e) {
/* 1354 */         throw new JobPersistenceException(e.getMessage(), e);
/*      */       }
/*      */ 
/* 1357 */       commitConnection(conn);
/*      */ 
/* 1359 */       e = moreToDo;
/*      */     } catch (JobPersistenceException e) {
/* 1361 */       rollbackConnection(conn);
/* 1362 */       throw e;
/*      */     } finally {
/*      */       try {
/* 1365 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1367 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean doCheckin() throws JobPersistenceException {
/* 1373 */     Connection conn = getConnection();
/*      */ 
/* 1375 */     boolean transOwner = false;
/* 1376 */     boolean transStateOwner = false;
/* 1377 */     boolean recovered = false;
/*      */     try
/*      */     {
/* 1383 */       List failedRecords = this.firstCheckIn ? null : clusterCheckIn(conn);
/*      */ 
/* 1385 */       if ((this.firstCheckIn) || (failedRecords.size() > 0)) {
/* 1386 */         getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
/* 1387 */         transStateOwner = true;
/*      */ 
/* 1391 */         failedRecords = this.firstCheckIn ? clusterCheckIn(conn) : findFailedInstances(conn);
/*      */ 
/* 1393 */         if (failedRecords.size() > 0) {
/* 1394 */           getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*      */ 
/* 1396 */           transOwner = true;
/*      */ 
/* 1398 */           clusterRecover(conn, failedRecords);
/* 1399 */           recovered = true;
/*      */         }
/*      */       }
/* 1402 */       commitConnection(conn);
/*      */     } catch (JobPersistenceException e) {
/* 1404 */       rollbackConnection(conn);
/* 1405 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*      */     }
/*      */ 
/* 1413 */     ret;
/*      */ 
/* 1418 */     this.firstCheckIn = false;
/*      */ 
/* 1420 */     return recovered;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.JobStoreTX
 * JD-Core Version:    0.6.0
 */