/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.quartz.Calendar;
/*     */ import org.quartz.CronTrigger;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.utils.Key;
/*     */ 
/*     */ public class DB2v7Delegate extends StdJDBCDelegate
/*     */ {
/*     */   public DB2v7Delegate(Log logger, String tablePrefix, String instanceId)
/*     */   {
/*  52 */     super(logger, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public DB2v7Delegate(Log log, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  57 */     super(log, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException
/*     */   {
/*  62 */     PreparedStatement ps = null;
/*  63 */     ResultSet rs = null;
/*     */     try
/*     */     {
/*  66 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
/*     */ 
/*  68 */       ps.setString(1, this.instanceId);
/*  69 */       ps.setString(2, "1");
/*     */ 
/*  71 */       rs = ps.executeQuery();
/*     */ 
/*  73 */       long dumId = System.currentTimeMillis();
/*  74 */       ArrayList list = new ArrayList();
/*  75 */       while (rs.next()) {
/*  76 */         String jobName = rs.getString("JOB_NAME");
/*  77 */         String jobGroup = rs.getString("JOB_GROUP");
/*  78 */         trigName = rs.getString("TRIGGER_NAME");
/*  79 */         String trigGroup = rs.getString("TRIGGER_GROUP");
/*  80 */         long firedTime = rs.getLong("FIRED_TIME");
/*  81 */         SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
/*     */ 
/*  84 */         rcvryTrig.setJobName(jobName);
/*  85 */         rcvryTrig.setJobGroup(jobGroup);
/*  86 */         rcvryTrig.setMisfireInstruction(1);
/*     */ 
/*  89 */         JobDataMap jd = selectTriggerJobDataMap(conn, trigName, trigGroup);
/*  90 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", trigName);
/*  91 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", trigGroup);
/*  92 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTime));
/*  93 */         rcvryTrig.setJobDataMap(jd);
/*     */ 
/*  95 */         list.add(rcvryTrig);
/*     */       }
/*  97 */       Object[] oArr = list.toArray();
/*  98 */       Trigger[] tArr = new Trigger[oArr.length];
/*  99 */       System.arraycopy(oArr, 0, tArr, 0, oArr.length);
/* 100 */       trigName = tArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       String trigName;
/* 102 */       if (null != rs)
/*     */         try {
/* 104 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 108 */       if (null != ps)
/*     */         try {
/* 110 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
/* 119 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 121 */     PreparedStatement ps = null;
/*     */ 
/* 123 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 127 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 128 */       ps.setString(1, job.getName());
/* 129 */       ps.setString(2, job.getGroup());
/* 130 */       ps.setString(3, job.getDescription());
/* 131 */       ps.setString(4, job.getJobClass().getName());
/* 132 */       ps.setString(5, toBooleanIntString(job.isDurable()));
/* 133 */       ps.setString(6, toBooleanIntString(job.isVolatile()));
/* 134 */       ps.setString(7, toBooleanIntString(job.isStateful()));
/* 135 */       ps.setString(8, toBooleanIntString(job.requestsRecovery()));
/*     */ 
/* 140 */       ps.setObject(9, baos.toByteArray(), 2004);
/*     */ 
/* 143 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 145 */       if (null != ps)
/*     */         try {
/* 147 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 153 */     if (insertResult > 0) {
/* 154 */       String[] jobListeners = job.getJobListenerNames();
/* 155 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 156 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 159 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException
/*     */   {
/* 164 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 166 */     PreparedStatement ps = null;
/*     */ 
/* 168 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 171 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 172 */       ps.setString(1, job.getDescription());
/* 173 */       ps.setString(2, job.getJobClass().getName());
/* 174 */       ps.setString(3, toBooleanIntString(job.isDurable()));
/* 175 */       ps.setString(4, toBooleanIntString(job.isVolatile()));
/* 176 */       ps.setString(5, toBooleanIntString(job.isStateful()));
/* 177 */       ps.setString(6, toBooleanIntString(job.requestsRecovery()));
/*     */ 
/* 182 */       ps.setObject(7, baos.toByteArray(), 2004);
/*     */ 
/* 184 */       ps.setString(8, job.getName());
/* 185 */       ps.setString(9, job.getGroup());
/*     */ 
/* 187 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 189 */       if (null != ps)
/*     */         try {
/* 191 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 197 */     if (insertResult > 0) {
/* 198 */       deleteJobListeners(conn, job.getName(), job.getGroup());
/*     */ 
/* 200 */       String[] jobListeners = job.getJobListenerNames();
/* 201 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 202 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 205 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail)
/*     */     throws SQLException, IOException
/*     */   {
/* 211 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/*     */ 
/* 213 */     PreparedStatement ps = null;
/*     */ 
/* 215 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 218 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 219 */       ps.setString(1, trigger.getName());
/* 220 */       ps.setString(2, trigger.getGroup());
/* 221 */       ps.setString(3, trigger.getJobName());
/* 222 */       ps.setString(4, trigger.getJobGroup());
/* 223 */       ps.setString(5, toBooleanIntString(trigger.isVolatile()));
/*     */ 
/* 225 */       ps.setString(6, trigger.getDescription());
/* 226 */       ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*     */ 
/* 228 */       long prevFireTime = -1L;
/* 229 */       if (trigger.getPreviousFireTime() != null) {
/* 230 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 232 */       ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
/* 233 */       ps.setString(9, state);
/* 234 */       if ((trigger instanceof SimpleTrigger))
/* 235 */         ps.setString(10, "SIMPLE");
/* 236 */       else if ((trigger instanceof CronTrigger))
/* 237 */         ps.setString(10, "CRON");
/*     */       else {
/* 239 */         ps.setString(10, "BLOB");
/*     */       }
/* 241 */       ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 243 */       long endTime = 0L;
/* 244 */       if (trigger.getEndTime() != null) {
/* 245 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 247 */       ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
/* 248 */       ps.setString(13, trigger.getCalendarName());
/* 249 */       ps.setInt(14, trigger.getMisfireInstruction());
/* 250 */       ps.setObject(15, baos.toByteArray(), 2004);
/*     */ 
/* 252 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 254 */       if (null != ps)
/*     */         try {
/* 256 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 262 */     if (insertResult > 0) {
/* 263 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 264 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 265 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 268 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException
/*     */   {
/* 273 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/*     */ 
/* 275 */     PreparedStatement ps = null;
/*     */ 
/* 277 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 280 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 281 */       ps.setString(1, trigger.getJobName());
/* 282 */       ps.setString(2, trigger.getJobGroup());
/* 283 */       ps.setString(3, toBooleanIntString(trigger.isVolatile()));
/*     */ 
/* 285 */       ps.setString(4, trigger.getDescription());
/* 286 */       long nextFireTime = -1L;
/* 287 */       if (trigger.getNextFireTime() != null) {
/* 288 */         nextFireTime = trigger.getNextFireTime().getTime();
/*     */       }
/* 290 */       ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
/* 291 */       long prevFireTime = -1L;
/* 292 */       if (trigger.getPreviousFireTime() != null) {
/* 293 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 295 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
/* 296 */       ps.setString(7, state);
/* 297 */       if ((trigger instanceof SimpleTrigger))
/*     */       {
/* 299 */         ps.setString(8, "SIMPLE");
/* 300 */       } else if ((trigger instanceof CronTrigger))
/*     */       {
/* 302 */         ps.setString(8, "CRON");
/*     */       }
/*     */       else {
/* 305 */         ps.setString(8, "BLOB");
/*     */       }
/* 307 */       ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 309 */       long endTime = 0L;
/* 310 */       if (trigger.getEndTime() != null) {
/* 311 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 313 */       ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
/* 314 */       ps.setString(11, trigger.getCalendarName());
/* 315 */       ps.setInt(12, trigger.getMisfireInstruction());
/* 316 */       ps.setObject(13, baos.toByteArray(), 2004);
/* 317 */       ps.setString(14, trigger.getName());
/* 318 */       ps.setString(15, trigger.getGroup());
/*     */ 
/* 320 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 322 */       if (null != ps)
/*     */         try {
/* 324 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 330 */     if (insertResult > 0) {
/* 331 */       deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
/*     */ 
/* 333 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 334 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 335 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 338 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job) throws SQLException
/*     */   {
/* 343 */     PreparedStatement ps = null;
/*     */     try {
/* 345 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 346 */       ps.setString(1, trigger.getFireInstanceId());
/* 347 */       ps.setString(2, trigger.getName());
/* 348 */       ps.setString(3, trigger.getGroup());
/* 349 */       ps.setString(4, toBooleanIntString(trigger.isVolatile()));
/*     */ 
/* 351 */       ps.setString(5, this.instanceId);
/* 352 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*     */ 
/* 354 */       ps.setString(7, state);
/* 355 */       if (job != null) {
/* 356 */         ps.setString(8, trigger.getJobName());
/* 357 */         ps.setString(9, trigger.getJobGroup());
/* 358 */         ps.setString(10, toBooleanIntString(job.isStateful()));
/* 359 */         ps.setString(11, toBooleanIntString(job.requestsRecovery()));
/*     */       }
/*     */       else
/*     */       {
/* 363 */         ps.setString(8, null);
/* 364 */         ps.setString(9, null);
/* 365 */         ps.setString(10, "0");
/* 366 */         ps.setString(11, "0");
/*     */       }
/*     */ 
/* 371 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 373 */       if (null != ps)
/*     */         try {
/* 375 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
/* 384 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 386 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 389 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 390 */       ps.setObject(1, baos.toByteArray(), 2004);
/*     */ 
/* 392 */       ps.setString(2, job.getName());
/* 393 */       ps.setString(3, job.getGroup());
/*     */ 
/* 395 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 397 */       if (null != ps)
/*     */         try {
/* 399 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
/* 408 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*     */ 
/* 410 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 413 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
/* 414 */       ps.setString(1, calendarName);
/* 415 */       ps.setObject(2, baos.toByteArray(), 2004);
/*     */ 
/* 418 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 420 */       if (null != ps)
/*     */         try {
/* 422 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
/* 431 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*     */ 
/* 433 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 436 */       ps = conn.prepareStatement(rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
/* 437 */       ps.setString(1, calendarName);
/* 438 */       ps.setObject(2, baos.toByteArray(), 2004);
/*     */ 
/* 441 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 443 */       if (null != ps)
/*     */         try {
/* 445 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
/* 453 */     PreparedStatement ps = null;
/*     */     try {
/* 455 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
/* 456 */       ps.setString(1, "1");
/*     */ 
/* 459 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 461 */       if (null != ps)
/*     */         try {
/* 463 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
/* 471 */     PreparedStatement ps = null;
/* 472 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 475 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
/* 476 */       ps.setString(1, "1");
/*     */ 
/* 478 */       rs = ps.executeQuery();
/*     */ 
/* 480 */       ArrayList list = new ArrayList();
/* 481 */       while (rs.next()) {
/* 482 */         String triggerName = rs.getString("TRIGGER_NAME");
/* 483 */         String groupName = rs.getString("TRIGGER_GROUP");
/* 484 */         list.add(new Key(triggerName, groupName));
/*     */       }
/* 486 */       Object[] oArr = list.toArray();
/* 487 */       Key[] kArr = new Key[oArr.length];
/* 488 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 489 */       arrayOfKey1 = kArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Key[] arrayOfKey1;
/* 491 */       if (null != rs)
/*     */         try {
/* 493 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 497 */       if (null != ps)
/*     */         try {
/* 499 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Key[] selectVolatileJobs(Connection conn) throws SQLException {
/* 507 */     PreparedStatement ps = null;
/* 508 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 511 */       ps = conn.prepareStatement(rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
/* 512 */       ps.setString(1, "1");
/*     */ 
/* 514 */       rs = ps.executeQuery();
/*     */ 
/* 516 */       ArrayList list = new ArrayList();
/* 517 */       while (rs.next()) {
/* 518 */         String triggerName = rs.getString("JOB_NAME");
/* 519 */         String groupName = rs.getString("JOB_GROUP");
/* 520 */         list.add(new Key(triggerName, groupName));
/*     */       }
/* 522 */       Object[] oArr = list.toArray();
/* 523 */       Key[] kArr = new Key[oArr.length];
/* 524 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 525 */       arrayOfKey1 = kArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Key[] arrayOfKey1;
/* 527 */       if (null != rs)
/*     */         try {
/* 529 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 533 */       if (null != ps)
/*     */         try {
/* 535 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String toBooleanIntString(boolean theBoolean) {
/* 543 */     if (String.valueOf(theBoolean).equals("true")) {
/* 544 */       return "1";
/*     */     }
/* 546 */     return "0";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.DB2v7Delegate
 * JD-Core Version:    0.6.0
 */