/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collections;
/*     */ import java.util.Date;
/*     */ import java.util.SortedSet;
/*     */ import java.util.TreeSet;
/*     */ 
/*     */ public class HolidayCalendar extends BaseCalendar
/*     */   implements org.quartz.Calendar, Serializable
/*     */ {
/*  50 */   private TreeSet dates = new TreeSet();
/*     */ 
/*     */   public HolidayCalendar()
/*     */   {
/*     */   }
/*     */ 
/*     */   public HolidayCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  62 */     setBaseCalendar(baseCalendar);
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp)
/*     */   {
/*  76 */     if (!super.isTimeIncluded(timeStamp)) return false;
/*     */ 
/*  78 */     Date lookFor = buildHoliday(new Date(timeStamp));
/*     */ 
/*  80 */     return !this.dates.contains(lookFor);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp)
/*     */   {
/*  96 */     long baseTime = super.getNextIncludedTime(timeStamp);
/*  97 */     if ((baseTime > 0L) && (baseTime > timeStamp)) timeStamp = baseTime;
/*     */ 
/* 100 */     long newTimeStamp = buildHoliday(timeStamp);
/*     */ 
/* 102 */     java.util.Calendar day = getJavaCalendar(newTimeStamp);
/* 103 */     while (!isTimeIncluded(day.getTime().getTime())) {
/* 104 */       day.add(5, 1);
/*     */     }
/*     */ 
/* 107 */     return day.getTime().getTime();
/*     */   }
/*     */ 
/*     */   public void addExcludedDate(Date excludedDate)
/*     */   {
/* 117 */     Date date = buildHoliday(excludedDate);
/*     */ 
/* 122 */     this.dates.add(date);
/*     */   }
/*     */ 
/*     */   public void removeExcludedDate(Date dateToRemove) {
/* 126 */     Date date = buildHoliday(dateToRemove);
/* 127 */     this.dates.remove(date);
/*     */   }
/*     */ 
/*     */   public SortedSet getExcludedDates()
/*     */   {
/* 138 */     return Collections.unmodifiableSortedSet(this.dates);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.HolidayCalendar
 * JD-Core Version:    0.6.0
 */