/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.text.NumberFormat;
/*     */ 
/*     */ public class DailyCalendar extends BaseCalendar
/*     */ {
/*     */   private static final String invalidHourOfDay = "Invalid hour of day: ";
/*     */   private static final String invalidMinute = "Invalid minute: ";
/*     */   private static final String invalidSecond = "Invalid second: ";
/*     */   private static final String invalidMillis = "Invalid millis: ";
/*     */   private static final String invalidTimeRange = "Invalid time range: ";
/*     */   private static final String separator = " - ";
/*     */   private static final long oneMillis = 1L;
/*     */   private static final String colon = ":";
/*     */   private String name;
/*     */   private int rangeStartingHourOfDay;
/*     */   private int rangeStartingMinute;
/*     */   private int rangeStartingSecond;
/*     */   private int rangeStartingMillis;
/*     */   private int rangeEndingHourOfDay;
/*     */   private int rangeEndingMinute;
/*     */   private int rangeEndingSecond;
/*     */   private int rangeEndingMillis;
/*  47 */   private boolean invertTimeRange = false;
/*     */ 
/*     */   public DailyCalendar(String name, String rangeStartingTime, String rangeEndingTime)
/*     */   {
/*  79 */     this.name = name;
/*  80 */     setTimeRange(rangeStartingTime, rangeEndingTime);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, org.quartz.Calendar baseCalendar, String rangeStartingTime, String rangeEndingTime)
/*     */   {
/* 116 */     super(baseCalendar);
/* 117 */     this.name = name;
/* 118 */     setTimeRange(rangeStartingTime, rangeEndingTime);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, int rangeStartingHourOfDay, int rangeStartingMinute, int rangeStartingSecond, int rangeStartingMillis, int rangeEndingHourOfDay, int rangeEndingMinute, int rangeEndingSecond, int rangeEndingMillis)
/*     */   {
/* 157 */     this.name = name;
/* 158 */     setTimeRange(rangeStartingHourOfDay, rangeStartingMinute, rangeStartingSecond, rangeStartingMillis, rangeEndingHourOfDay, rangeEndingMinute, rangeEndingSecond, rangeEndingMillis);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, org.quartz.Calendar baseCalendar, int rangeStartingHourOfDay, int rangeStartingMinute, int rangeStartingSecond, int rangeStartingMillis, int rangeEndingHourOfDay, int rangeEndingMinute, int rangeEndingSecond, int rangeEndingMillis)
/*     */   {
/* 210 */     super(baseCalendar);
/* 211 */     this.name = name;
/* 212 */     setTimeRange(rangeStartingHourOfDay, rangeStartingMinute, rangeStartingSecond, rangeStartingMillis, rangeEndingHourOfDay, rangeEndingMinute, rangeEndingSecond, rangeEndingMillis);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, java.util.Calendar rangeStartingCalendar, java.util.Calendar rangeEndingCalendar)
/*     */   {
/* 248 */     this.name = name;
/* 249 */     setTimeRange(rangeStartingCalendar, rangeEndingCalendar);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, org.quartz.Calendar baseCalendar, java.util.Calendar rangeStartingCalendar, java.util.Calendar rangeEndingCalendar)
/*     */   {
/* 281 */     super(baseCalendar);
/* 282 */     this.name = name;
/* 283 */     setTimeRange(rangeStartingCalendar, rangeEndingCalendar);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, long rangeStartingTimeInMillis, long rangeEndingTimeInMillis)
/*     */   {
/* 311 */     this.name = name;
/* 312 */     setTimeRange(rangeStartingTimeInMillis, rangeEndingTimeInMillis);
/*     */   }
/*     */ 
/*     */   public DailyCalendar(String name, org.quartz.Calendar baseCalendar, long rangeStartingTimeInMillis, long rangeEndingTimeInMillis)
/*     */   {
/* 345 */     super(baseCalendar);
/* 346 */     this.name = name;
/* 347 */     setTimeRange(rangeStartingTimeInMillis, rangeEndingTimeInMillis);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 357 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeInMillis)
/*     */   {
/* 369 */     if ((getBaseCalendar() != null) && (!getBaseCalendar().isTimeIncluded(timeInMillis)))
/*     */     {
/* 371 */       return false;
/*     */     }
/*     */ 
/* 374 */     long startOfDayInMillis = getStartOfDayInMillis(timeInMillis);
/* 375 */     long endOfDayInMillis = getEndOfDayInMillis(timeInMillis);
/* 376 */     long timeRangeStartingTimeInMillis = getTimeRangeStartingTimeInMillis(timeInMillis);
/*     */ 
/* 378 */     long timeRangeEndingTimeInMillis = getTimeRangeEndingTimeInMillis(timeInMillis);
/*     */ 
/* 380 */     if (!this.invertTimeRange)
/*     */     {
/* 386 */       return ((timeInMillis > startOfDayInMillis) && (timeInMillis < timeRangeStartingTimeInMillis)) || ((timeInMillis > timeRangeEndingTimeInMillis) && (timeInMillis < endOfDayInMillis));
/*     */     }
/*     */ 
/* 393 */     return (timeInMillis >= timeRangeStartingTimeInMillis) && (timeInMillis <= timeRangeEndingTimeInMillis);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeInMillis)
/*     */   {
/* 410 */     long nextIncludedTime = timeInMillis + 1L;
/*     */ 
/* 412 */     while (!isTimeIncluded(nextIncludedTime)) {
/* 413 */       if (!this.invertTimeRange)
/*     */       {
/* 420 */         if ((nextIncludedTime >= getTimeRangeStartingTimeInMillis(nextIncludedTime)) && (nextIncludedTime <= getTimeRangeEndingTimeInMillis(nextIncludedTime)))
/*     */         {
/* 425 */           nextIncludedTime = getTimeRangeEndingTimeInMillis(nextIncludedTime) + 1L; continue;
/*     */         }
/*     */ 
/* 428 */         if ((getBaseCalendar() != null) && (!getBaseCalendar().isTimeIncluded(nextIncludedTime)))
/*     */         {
/* 430 */           nextIncludedTime = getBaseCalendar().getNextIncludedTime(nextIncludedTime); continue;
/*     */         }
/*     */ 
/* 433 */         nextIncludedTime += 1L; continue;
/*     */       }
/*     */ 
/* 442 */       if (nextIncludedTime < getTimeRangeStartingTimeInMillis(nextIncludedTime))
/*     */       {
/* 444 */         nextIncludedTime = getTimeRangeStartingTimeInMillis(nextIncludedTime); continue;
/*     */       }
/* 446 */       if (nextIncludedTime > getTimeRangeEndingTimeInMillis(nextIncludedTime))
/*     */       {
/* 449 */         nextIncludedTime = getEndOfDayInMillis(nextIncludedTime);
/* 450 */         nextIncludedTime += 1L; continue;
/* 451 */       }if ((getBaseCalendar() != null) && (!getBaseCalendar().isTimeIncluded(nextIncludedTime)))
/*     */       {
/* 453 */         nextIncludedTime = getBaseCalendar().getNextIncludedTime(nextIncludedTime); continue;
/*     */       }
/*     */ 
/* 456 */       nextIncludedTime += 1L;
/*     */     }
/*     */ 
/* 461 */     return nextIncludedTime;
/*     */   }
/*     */ 
/*     */   public long getTimeRangeStartingTimeInMillis(long timeInMillis)
/*     */   {
/* 474 */     java.util.Calendar rangeStartingTime = java.util.Calendar.getInstance();
/* 475 */     rangeStartingTime.setTimeInMillis(timeInMillis);
/* 476 */     rangeStartingTime.set(11, this.rangeStartingHourOfDay);
/* 477 */     rangeStartingTime.set(12, this.rangeStartingMinute);
/* 478 */     rangeStartingTime.set(13, this.rangeStartingSecond);
/* 479 */     rangeStartingTime.set(14, this.rangeStartingMillis);
/* 480 */     return rangeStartingTime.getTimeInMillis();
/*     */   }
/*     */ 
/*     */   public long getTimeRangeEndingTimeInMillis(long timeInMillis)
/*     */   {
/* 493 */     java.util.Calendar rangeEndingTime = java.util.Calendar.getInstance();
/* 494 */     rangeEndingTime.setTimeInMillis(timeInMillis);
/* 495 */     rangeEndingTime.set(11, this.rangeEndingHourOfDay);
/* 496 */     rangeEndingTime.set(12, this.rangeEndingMinute);
/* 497 */     rangeEndingTime.set(13, this.rangeEndingSecond);
/* 498 */     rangeEndingTime.set(14, this.rangeEndingMillis);
/* 499 */     return rangeEndingTime.getTimeInMillis();
/*     */   }
/*     */ 
/*     */   public boolean getInvertTimeRange()
/*     */   {
/* 509 */     return this.invertTimeRange;
/*     */   }
/*     */ 
/*     */   public void setInvertTimeRange(boolean flag)
/*     */   {
/* 519 */     this.invertTimeRange = flag;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 529 */     long todayInMillis = java.util.Calendar.getInstance().getTimeInMillis();
/* 530 */     NumberFormat numberFormatter = NumberFormat.getNumberInstance();
/* 531 */     numberFormatter.setMaximumFractionDigits(0);
/* 532 */     numberFormatter.setMinimumIntegerDigits(2);
/* 533 */     StringBuffer buffer = new StringBuffer();
/* 534 */     buffer.append(getName());
/* 535 */     buffer.append(": base calendar: [");
/* 536 */     if (getBaseCalendar() != null)
/* 537 */       buffer.append(getBaseCalendar().toString());
/*     */     else {
/* 539 */       buffer.append("null");
/*     */     }
/* 541 */     buffer.append("], time range: '");
/* 542 */     buffer.append(numberFormatter.format(this.rangeStartingHourOfDay));
/* 543 */     buffer.append(":");
/* 544 */     buffer.append(numberFormatter.format(this.rangeStartingMinute));
/* 545 */     buffer.append(":");
/* 546 */     buffer.append(numberFormatter.format(this.rangeStartingSecond));
/* 547 */     buffer.append(":");
/* 548 */     numberFormatter.setMinimumIntegerDigits(3);
/* 549 */     buffer.append(numberFormatter.format(this.rangeStartingMillis));
/* 550 */     numberFormatter.setMinimumIntegerDigits(2);
/* 551 */     buffer.append(" - ");
/* 552 */     buffer.append(numberFormatter.format(this.rangeEndingHourOfDay));
/* 553 */     buffer.append(":");
/* 554 */     buffer.append(numberFormatter.format(this.rangeEndingMinute));
/* 555 */     buffer.append(":");
/* 556 */     buffer.append(numberFormatter.format(this.rangeEndingSecond));
/* 557 */     buffer.append(":");
/* 558 */     numberFormatter.setMinimumIntegerDigits(3);
/* 559 */     buffer.append(numberFormatter.format(this.rangeEndingMillis));
/* 560 */     buffer.append("', inverted: " + Boolean.toString(this.invertTimeRange) + "]");
/*     */ 
/* 562 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private void setTimeRange(String rangeStartingTimeString, String rangeEndingTimeString)
/*     */   {
/* 588 */     String[] rangeStartingTime = rangeStartingTimeString.split(":");
/*     */ 
/* 590 */     if ((rangeStartingTime.length < 2) || (rangeStartingTime.length > 4)) {
/* 591 */       throw new IllegalArgumentException("Invalid time string '" + rangeStartingTimeString + "'");
/*     */     }
/*     */ 
/* 595 */     int rangeStartingHourOfDay = Integer.parseInt(rangeStartingTime[0]);
/* 596 */     int rangeStartingMinute = Integer.parseInt(rangeStartingTime[1]);
/*     */     int rangeStartingSecond;
/*     */     int rangeStartingSecond;
/* 597 */     if (rangeStartingTime.length > 2)
/* 598 */       rangeStartingSecond = Integer.parseInt(rangeStartingTime[2]);
/*     */     else
/* 600 */       rangeStartingSecond = 0;
/*     */     int rangeStartingMillis;
/*     */     int rangeStartingMillis;
/* 602 */     if (rangeStartingTime.length == 4)
/* 603 */       rangeStartingMillis = Integer.parseInt(rangeStartingTime[3]);
/*     */     else {
/* 605 */       rangeStartingMillis = 0;
/*     */     }
/*     */ 
/* 608 */     String[] rangeEndingTime = rangeEndingTimeString.split(":");
/*     */ 
/* 610 */     if ((rangeEndingTime.length < 2) || (rangeEndingTime.length > 4)) {
/* 611 */       throw new IllegalArgumentException("Invalid time string '" + rangeEndingTimeString + "'");
/*     */     }
/*     */ 
/* 615 */     int rangeEndingHourOfDay = Integer.parseInt(rangeEndingTime[0]);
/* 616 */     int rangeEndingMinute = Integer.parseInt(rangeEndingTime[1]);
/*     */     int rangeEndingSecond;
/*     */     int rangeEndingSecond;
/* 617 */     if (rangeEndingTime.length > 2)
/* 618 */       rangeEndingSecond = Integer.parseInt(rangeEndingTime[2]);
/*     */     else
/* 620 */       rangeEndingSecond = 0;
/*     */     int rangeEndingMillis;
/*     */     int rangeEndingMillis;
/* 622 */     if (rangeEndingTime.length == 4)
/* 623 */       rangeEndingMillis = Integer.parseInt(rangeEndingTime[3]);
/*     */     else {
/* 625 */       rangeEndingMillis = 0;
/*     */     }
/*     */ 
/* 628 */     setTimeRange(rangeStartingHourOfDay, rangeStartingMinute, rangeStartingSecond, rangeStartingMillis, rangeEndingHourOfDay, rangeEndingMinute, rangeEndingSecond, rangeEndingMillis);
/*     */   }
/*     */ 
/*     */   private void setTimeRange(int rangeStartingHourOfDay, int rangeStartingMinute, int rangeStartingSecond, int rangeStartingMillis, int rangeEndingHourOfDay, int rangeEndingMinute, int rangeEndingSecond, int rangeEndingMillis)
/*     */   {
/* 661 */     validate(rangeStartingHourOfDay, rangeStartingMinute, rangeStartingSecond, rangeStartingMillis);
/*     */ 
/* 666 */     validate(rangeEndingHourOfDay, rangeEndingMinute, rangeEndingSecond, rangeEndingMillis);
/*     */ 
/* 671 */     java.util.Calendar startCal = java.util.Calendar.getInstance();
/* 672 */     startCal.set(11, rangeStartingHourOfDay);
/* 673 */     startCal.set(12, rangeStartingMinute);
/* 674 */     startCal.set(13, rangeStartingSecond);
/* 675 */     startCal.set(14, rangeStartingMillis);
/*     */ 
/* 677 */     java.util.Calendar endCal = java.util.Calendar.getInstance();
/* 678 */     endCal.set(11, rangeEndingHourOfDay);
/* 679 */     endCal.set(12, rangeEndingMinute);
/* 680 */     endCal.set(13, rangeEndingSecond);
/* 681 */     endCal.set(14, rangeEndingMillis);
/*     */ 
/* 683 */     if (!startCal.before(endCal)) {
/* 684 */       throw new IllegalArgumentException("Invalid time range: " + rangeStartingHourOfDay + ":" + rangeStartingMinute + ":" + rangeStartingSecond + ":" + rangeStartingMillis + " - " + rangeEndingHourOfDay + ":" + rangeEndingMinute + ":" + rangeEndingSecond + ":" + rangeEndingMillis);
/*     */     }
/*     */ 
/* 695 */     this.rangeStartingHourOfDay = rangeStartingHourOfDay;
/* 696 */     this.rangeStartingMinute = rangeStartingMinute;
/* 697 */     this.rangeStartingSecond = rangeStartingSecond;
/* 698 */     this.rangeStartingMillis = rangeStartingMillis;
/* 699 */     this.rangeEndingHourOfDay = rangeEndingHourOfDay;
/* 700 */     this.rangeEndingMinute = rangeEndingMinute;
/* 701 */     this.rangeEndingSecond = rangeEndingSecond;
/* 702 */     this.rangeEndingMillis = rangeEndingMillis;
/*     */   }
/*     */ 
/*     */   private void setTimeRange(java.util.Calendar rangeStartingCalendar, java.util.Calendar rangeEndingCalendar)
/*     */   {
/* 716 */     setTimeRange(rangeStartingCalendar.get(11), rangeStartingCalendar.get(12), rangeStartingCalendar.get(13), rangeStartingCalendar.get(14), rangeEndingCalendar.get(11), rangeEndingCalendar.get(12), rangeEndingCalendar.get(13), rangeEndingCalendar.get(14));
/*     */   }
/*     */ 
/*     */   private void setTimeRange(long rangeStartingTime, long rangeEndingTime)
/*     */   {
/* 738 */     java.util.Calendar startCal = java.util.Calendar.getInstance();
/* 739 */     java.util.Calendar endCal = java.util.Calendar.getInstance();
/* 740 */     startCal.setTimeInMillis(rangeStartingTime);
/* 741 */     endCal.setTimeInMillis(rangeEndingTime);
/*     */ 
/* 743 */     setTimeRange(startCal, endCal);
/*     */   }
/*     */ 
/*     */   private long getStartOfDayInMillis(long timeInMillis)
/*     */   {
/* 754 */     java.util.Calendar startOfDay = java.util.Calendar.getInstance();
/* 755 */     startOfDay.setTimeInMillis(timeInMillis);
/* 756 */     startOfDay.set(11, 0);
/* 757 */     startOfDay.set(12, 0);
/* 758 */     startOfDay.set(13, 0);
/* 759 */     startOfDay.set(14, 0);
/* 760 */     return startOfDay.getTimeInMillis();
/*     */   }
/*     */ 
/*     */   private long getEndOfDayInMillis(long timeInMillis)
/*     */   {
/* 771 */     java.util.Calendar endOfDay = java.util.Calendar.getInstance();
/* 772 */     endOfDay.setTimeInMillis(timeInMillis);
/* 773 */     endOfDay.set(11, 23);
/* 774 */     endOfDay.set(12, 59);
/* 775 */     endOfDay.set(13, 59);
/* 776 */     endOfDay.set(14, 999);
/* 777 */     return endOfDay.getTimeInMillis();
/*     */   }
/*     */ 
/*     */   private void validate(int hourOfDay, int minute, int second, int millis)
/*     */   {
/* 790 */     if ((hourOfDay < 0) || (hourOfDay > 23)) {
/* 791 */       throw new IllegalArgumentException("Invalid hour of day: " + hourOfDay);
/*     */     }
/* 793 */     if ((minute < 0) || (minute > 59)) {
/* 794 */       throw new IllegalArgumentException("Invalid minute: " + minute);
/*     */     }
/* 796 */     if ((second < 0) || (second > 59)) {
/* 797 */       throw new IllegalArgumentException("Invalid second: " + second);
/*     */     }
/* 799 */     if ((millis < 0) || (millis > 999))
/* 800 */       throw new IllegalArgumentException("Invalid millis: " + millis);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.DailyCalendar
 * JD-Core Version:    0.6.0
 */