/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.text.ParseException;
/*     */ import java.util.Date;
/*     */ import org.quartz.Calendar;
/*     */ import org.quartz.CronExpression;
/*     */ 
/*     */ public class CronCalendar extends BaseCalendar
/*     */ {
/*     */   static final long serialVersionUID = -8172103999750856831L;
/*     */   private String name;
/*     */   CronExpression cronExpression;
/*     */ 
/*     */   public CronCalendar(String name, String expression)
/*     */     throws ParseException
/*     */   {
/*  41 */     this.name = name;
/*  42 */     this.cronExpression = new CronExpression(expression);
/*     */   }
/*     */ 
/*     */   public CronCalendar(String name, Calendar baseCalendar, String expression)
/*     */     throws ParseException
/*     */   {
/*  57 */     super(baseCalendar);
/*  58 */     this.name = name;
/*  59 */     this.cronExpression = new CronExpression(expression);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  68 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeInMillis)
/*     */   {
/*  80 */     if ((getBaseCalendar() != null) && (!getBaseCalendar().isTimeIncluded(timeInMillis)))
/*     */     {
/*  82 */       return false;
/*     */     }
/*     */ 
/*  85 */     return !this.cronExpression.isSatisfiedBy(new Date(timeInMillis));
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeInMillis)
/*     */   {
/*  98 */     long nextIncludedTime = timeInMillis + 1L;
/*     */ 
/* 100 */     while (!isTimeIncluded(nextIncludedTime))
/*     */     {
/* 107 */       if (this.cronExpression.isSatisfiedBy(new Date(nextIncludedTime))) {
/* 108 */         nextIncludedTime = this.cronExpression.getNextValidTimeAfter(new Date(nextIncludedTime)).getTime(); continue;
/*     */       }
/*     */ 
/* 111 */       if ((getBaseCalendar() != null) && (!getBaseCalendar().isTimeIncluded(nextIncludedTime)))
/*     */       {
/* 113 */         nextIncludedTime = getBaseCalendar().getNextIncludedTime(nextIncludedTime); continue;
/*     */       }
/*     */ 
/* 116 */       nextIncludedTime += 1L;
/*     */     }
/*     */ 
/* 120 */     return nextIncludedTime;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 130 */     StringBuffer buffer = new StringBuffer();
/* 131 */     buffer.append(getName());
/* 132 */     buffer.append(": base calendar: [");
/* 133 */     if (getBaseCalendar() != null)
/* 134 */       buffer.append(getBaseCalendar().toString());
/*     */     else {
/* 136 */       buffer.append("null");
/*     */     }
/* 138 */     buffer.append("], excluded cron expression: '");
/* 139 */     buffer.append(this.cronExpression);
/* 140 */     buffer.append("'");
/* 141 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public CronExpression getCronExpression()
/*     */   {
/* 152 */     return this.cronExpression;
/*     */   }
/*     */ 
/*     */   public void setCronExpression(String expression)
/*     */     throws ParseException
/*     */   {
/* 163 */     CronExpression newExp = new CronExpression(expression);
/*     */ 
/* 165 */     this.cronExpression = newExp;
/*     */   }
/*     */ 
/*     */   public void setCronExpression(CronExpression expression)
/*     */   {
/* 174 */     if (expression == null) {
/* 175 */       throw new IllegalArgumentException("expression cannot be null");
/*     */     }
/*     */ 
/* 178 */     this.cronExpression = expression;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.CronCalendar
 * JD-Core Version:    0.6.0
 */