/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class BaseCalendar
/*     */   implements org.quartz.Calendar, Serializable
/*     */ {
/*     */   private org.quartz.Calendar baseCalendar;
/*     */   private String description;
/*     */ 
/*     */   public BaseCalendar()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BaseCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  71 */     setBaseCalendar(baseCalendar);
/*     */   }
/*     */ 
/*     */   public void setBaseCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  80 */     this.baseCalendar = baseCalendar;
/*     */   }
/*     */ 
/*     */   public org.quartz.Calendar getBaseCalendar()
/*     */   {
/*  89 */     return this.baseCalendar;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 101 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 112 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp)
/*     */   {
/* 126 */     if (timeStamp <= 0L) {
/* 127 */       throw new IllegalArgumentException("timeStamp must be greater 0");
/*     */     }
/*     */ 
/* 131 */     return (this.baseCalendar == null) || 
/* 131 */       (this.baseCalendar.isTimeIncluded(timeStamp));
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp)
/*     */   {
/* 148 */     if (timeStamp <= 0L) {
/* 149 */       throw new IllegalArgumentException("timeStamp must be greater 0");
/*     */     }
/*     */ 
/* 152 */     if (this.baseCalendar != null) return this.baseCalendar.getNextIncludedTime(timeStamp);
/*     */ 
/* 155 */     return timeStamp;
/*     */   }
/*     */ 
/*     */   public static Date buildHoliday(Date excludedDate)
/*     */   {
/* 165 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/* 166 */     java.util.Calendar clEx = java.util.Calendar.getInstance();
/* 167 */     clEx.setTime(excludedDate);
/*     */ 
/* 169 */     cl.setLenient(false);
/* 170 */     cl.clear();
/* 171 */     cl.set(clEx.get(1), clEx.get(2), clEx.get(5));
/*     */ 
/* 175 */     return cl.getTime();
/*     */   }
/*     */ 
/*     */   public static long buildHoliday(long timeStamp)
/*     */   {
/* 185 */     return buildHoliday(new Date(timeStamp)).getTime();
/*     */   }
/*     */ 
/*     */   public static java.util.Calendar getJavaCalendar(long timeStamp)
/*     */   {
/* 197 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/* 198 */     cl.setTime(new Date(timeStamp));
/* 199 */     return cl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.BaseCalendar
 * JD-Core Version:    0.6.0
 */