/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Date;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class AnnualCalendar extends BaseCalendar
/*     */   implements org.quartz.Calendar, Serializable
/*     */ {
/*  47 */   private ArrayList excludeDays = new ArrayList();
/*     */ 
/*  50 */   private boolean dataSorted = false;
/*     */ 
/*     */   public AnnualCalendar()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AnnualCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  67 */     super(baseCalendar);
/*     */   }
/*     */ 
/*     */   public ArrayList getDaysExcluded()
/*     */   {
/*  76 */     return this.excludeDays;
/*     */   }
/*     */ 
/*     */   public boolean isDayExcluded(java.util.Calendar day)
/*     */   {
/*  85 */     if (day == null) {
/*  86 */       throw new IllegalArgumentException("Parameter day must not be null");
/*     */     }
/*     */ 
/*  89 */     int dmonth = day.get(2);
/*  90 */     int dday = day.get(5);
/*     */ 
/*  92 */     if (!this.dataSorted) {
/*  93 */       Collections.sort(this.excludeDays, new CalendarComparator());
/*  94 */       this.dataSorted = true;
/*     */     }
/*     */ 
/*  97 */     Iterator iter = this.excludeDays.iterator();
/*  98 */     while (iter.hasNext()) {
/*  99 */       java.util.Calendar cl = (java.util.Calendar)iter.next();
/*     */ 
/* 102 */       if (dmonth < cl.get(2)) return false;
/*     */ 
/* 104 */       if ((dday == cl.get(5)) && 
/* 106 */         (dmonth == cl.get(2)))
/*     */       {
/* 108 */         return true;
/*     */       }
/*     */     }
/* 111 */     return false;
/*     */   }
/*     */ 
/*     */   public void setDaysExcluded(ArrayList days)
/*     */   {
/* 121 */     if (days == null) this.excludeDays = new ArrayList();
/*     */ 
/* 123 */     this.excludeDays = days;
/* 124 */     this.dataSorted = false;
/*     */   }
/*     */ 
/*     */   public void setDayExcluded(java.util.Calendar day, boolean exclude)
/*     */   {
/* 133 */     if (isDayExcluded(day)) return;
/*     */ 
/* 135 */     this.excludeDays.add(day);
/* 136 */     this.dataSorted = false;
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp)
/*     */   {
/* 152 */     if (!super.isTimeIncluded(timeStamp)) return false;
/*     */ 
/* 154 */     java.util.Calendar day = getJavaCalendar(timeStamp);
/*     */ 
/* 156 */     return !isDayExcluded(day);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp)
/*     */   {
/* 172 */     long baseTime = super.getNextIncludedTime(timeStamp);
/* 173 */     if ((baseTime > 0L) && (baseTime > timeStamp)) timeStamp = baseTime;
/*     */ 
/* 176 */     long newTimeStamp = buildHoliday(timeStamp);
/*     */ 
/* 178 */     java.util.Calendar day = getJavaCalendar(newTimeStamp);
/* 179 */     if (!isDayExcluded(day)) return timeStamp;
/*     */ 
/* 182 */     while (isDayExcluded(day) == true) {
/* 183 */       day.add(5, 1);
/*     */     }
/*     */ 
/* 186 */     return day.getTime().getTime();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.AnnualCalendar
 * JD-Core Version:    0.6.0
 */